/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.agent.rt_c722md.core.instr;

import java.io.IOException;
import java.io.InputStream;
import org.jacoco.agent.rt_c722md.asm.ClassReader;
import org.jacoco.agent.rt_c722md.asm.ClassVisitor;
import org.jacoco.agent.rt_c722md.asm.ClassWriter;
import org.jacoco.agent.rt_c722md.core.internal.data.CRC64;
import org.jacoco.agent.rt_c722md.core.internal.flow.ClassProbesAdapter;
import org.jacoco.agent.rt_c722md.core.internal.instr.ClassInstrumenter;
import org.jacoco.agent.rt_c722md.core.runtime.IRuntime;

public class Instrumenter {
    private final IRuntime runtime;

    public Instrumenter(IRuntime runtime) {
        this.runtime = runtime;
    }

    private ClassVisitor createInstrumentingVisitor(long classid, ClassVisitor cv) {
        return new ClassProbesAdapter(new ClassInstrumenter(classid, this.runtime, cv));
    }

    public byte[] instrument(ClassReader reader) {
        ClassWriter writer = new ClassWriter(reader, 0);
        ClassVisitor visitor = this.createInstrumentingVisitor(CRC64.checksum(reader.b), writer);
        reader.accept(visitor, 8);
        return writer.toByteArray();
    }

    public byte[] instrument(byte[] buffer) {
        return this.instrument(new ClassReader(buffer));
    }

    public byte[] instrument(InputStream input) throws IOException {
        return this.instrument(new ClassReader(input));
    }
}

