/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.agent.rt_c722md.core.data;

import java.util.Arrays;

public final class ExecutionData {
    private final long id;
    private final String name;
    private final boolean[] data;

    public ExecutionData(long id, String name, boolean[] data) {
        this.id = id;
        this.name = name;
        this.data = data;
    }

    public ExecutionData(long id, String name, int dataLength) {
        this.id = id;
        this.name = name;
        this.data = new boolean[dataLength];
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean[] getData() {
        return this.data;
    }

    public void reset() {
        Arrays.fill(this.data, false);
    }

    public void merge(ExecutionData other) {
        this.assertCompatibility(other.getId(), other.getName(), other.getData().length);
        boolean[] otherData = other.getData();
        for (int i = 0; i < this.data.length; ++i) {
            if (!otherData[i]) continue;
            this.data[i] = true;
        }
    }

    public void assertCompatibility(long id, String name, int dataLength) throws IllegalStateException {
        if (this.id != id) {
            throw new IllegalStateException(String.format("Different ids (%016x and %016x).", this.id, id));
        }
        if (!this.name.equals(name)) {
            throw new IllegalStateException(String.format("Different class names %s and %s for id %016x.", this.name, name, id));
        }
        if (this.data.length != dataLength) {
            throw new IllegalStateException(String.format("Incompatible execution data for class %s with id %016x.", name, id));
        }
    }

    public String toString() {
        return String.format("ExecutionData [name=%s, id=%016x]", this.name, this.id);
    }
}

