/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.addons.internal.canvas;

import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.addons.canvas.ClientCanvas;
import org.eclipse.rap.rwt.addons.internal.canvas.ClientDrawListenerAdapter;
import org.eclipse.rap.rwt.addons.internal.canvas.DrawingsCache;
import org.eclipse.rap.rwt.internal.lifecycle.ProcessActionRunner;
import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.widgets.canvaskit.CanvasOperationHandler;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Control;

public class ClientCanvasOperator
extends CanvasOperationHandler {
    public static final String DRAWING_EVENT = "Drawing";
    public static final String DRAWINGS_PROPERTY = "drawings";

    public ClientCanvasOperator(ClientCanvas canvas) {
        super((Canvas)canvas);
        if (canvas == null) {
            SWT.error((int)4);
        }
    }

    public void handleNotify(Canvas control, String eventName, JsonObject properties) {
        if (eventName.equals(DRAWING_EVENT)) {
            ClientCanvasOperator.handleDrawings(control, properties);
        } else {
            super.handleNotify((Control)control, eventName, properties);
        }
    }

    private static void handleDrawings(final Canvas control, final JsonObject properties) {
        ProcessActionRunner.add((Runnable)new Runnable(){

            @Override
            public void run() {
                DrawingsCache cache = (DrawingsCache)control.getAdapter(DrawingsCache.class);
                JsonValue drawings = properties.get(ClientCanvasOperator.DRAWINGS_PROPERTY);
                if (drawings != null) {
                    cache.cache(drawings.asString());
                    cache.clearRemoved();
                    ClientCanvasOperator.fireDrawEvent((ClientCanvas)control);
                }
            }
        });
    }

    private static void fireDrawEvent(ClientCanvas control) {
        if (!control.isDisposed()) {
            control.getAdapter(ClientDrawListenerAdapter.class).notifyReceivedDrawing();
        }
    }
}

