/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import oracle.kv.impl.security.util.SNKrbInstance;
import oracle.kv.impl.topo.StorageNode;
import oracle.kv.impl.util.FastExternalizable;
import oracle.kv.impl.util.SerializationUtil;

public class KerberosPrincipals
implements Serializable,
FastExternalizable {
    private static final long serialVersionUID = 1L;
    private final SNKrbInstance[] instanceNames;

    public KerberosPrincipals(SNKrbInstance[] instanceNames) {
        this.instanceNames = instanceNames == null || instanceNames.length == 0 ? null : instanceNames;
    }

    public KerberosPrincipals(DataInput in, short serialVersion) throws IOException {
        boolean hasInstances = in.readBoolean();
        if (hasInstances) {
            int len = serialVersion >= 14 ? SerializationUtil.readNonNullSequenceLength(in) : (int)in.readShort();
            this.instanceNames = new SNKrbInstance[len];
            for (int i = 0; i < len; ++i) {
                this.instanceNames[i] = new SNKrbInstance(in, serialVersion);
            }
        } else {
            this.instanceNames = null;
        }
    }

    public SNKrbInstance[] getSNInstanceNames() {
        return this.instanceNames;
    }

    public String getInstanceName(StorageNode sn) {
        for (SNKrbInstance snKrb : this.getSNInstanceNames()) {
            if (sn.getStorageNodeId().getStorageNodeId() != snKrb.getStorageNodeId()) continue;
            return snKrb.getInstanceName();
        }
        return null;
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        if (this.instanceNames != null && this.instanceNames.length != 0) {
            out.writeBoolean(true);
            if (serialVersion >= 14) {
                SerializationUtil.writeNonNullArray(out, serialVersion, this.instanceNames);
            } else {
                out.writeShort(this.instanceNames.length);
                for (SNKrbInstance instance : this.instanceNames) {
                    instance.writeFastExternal(out, serialVersion);
                }
            }
        } else {
            out.writeBoolean(false);
        }
    }
}

