/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.parallelscan;

import com.sleepycat.je.utilint.PropUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import oracle.kv.Consistency;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.Request;
import oracle.kv.impl.api.StoreIteratorParams;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.api.parallelscan.BaseParallelScanIteratorImpl;
import oracle.kv.impl.api.parallelscan.DetailedMetricsImpl;
import oracle.kv.impl.async.IterationHandleNotifier;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.topo.TopologyUtil;
import oracle.kv.query.ExecuteOptions;
import oracle.kv.stats.DetailedMetrics;

public abstract class PartitionScanIterator<K>
extends BaseParallelScanIteratorImpl<K> {
    private final Map<Integer, DetailedMetricsImpl> partitionMetrics;
    private final Map<RepGroupId, DetailedMetricsImpl> shardMetrics;
    protected final StoreIteratorParams storeIteratorParams;

    public PartitionScanIterator(KVStoreImpl store, ExecuteOptions options, StoreIteratorParams storeIteratorParams) {
        this(store, options, storeIteratorParams, null);
    }

    public PartitionScanIterator(KVStoreImpl store, ExecuteOptions options, StoreIteratorParams storeIteratorParams, IterationHandleNotifier iterHandleNotifier) {
        super(store, store.getLogger(), PartitionScanIterator.computeRequestTimeout(store, storeIteratorParams), storeIteratorParams.getDirection(), 0, options.getDoPrefetching(), iterHandleNotifier);
        this.storeIteratorParams = storeIteratorParams;
        this.partitionMetrics = new HashMap<Integer, DetailedMetricsImpl>(this.storeImpl.getNPartitions());
        this.shardMetrics = new HashMap<RepGroupId, DetailedMetricsImpl>();
        this.createAndSubmitStreams(options);
    }

    private static long computeRequestTimeout(KVStoreImpl store, StoreIteratorParams storeIteratorParams) {
        long requestTimeoutMs = store.getDefaultRequestTimeoutMs();
        long timeout = storeIteratorParams.getTimeout();
        if (timeout > 0L && (requestTimeoutMs = (long)PropUtil.durationToMillis(timeout, storeIteratorParams.getTimeoutUnit())) > (long)store.getReadTimeoutMs()) {
            String format = "Request timeout parameter: %,d ms exceeds socket read timeout: %,d ms";
            throw new IllegalArgumentException(String.format(format, requestTimeoutMs, store.getReadTimeoutMs()));
        }
        return requestTimeoutMs;
    }

    private Consistency getConsistency() {
        return this.storeIteratorParams.getConsistency() != null ? this.storeIteratorParams.getConsistency() : this.storeImpl.getDefaultConsistency();
    }

    private void createAndSubmitStreams(ExecuteOptions options) {
        boolean didSomething;
        Map<RepGroupId, Set<Integer>> partitionsByShard = this.getPartitionTopology(this.storeIteratorParams.getPartitions());
        int nShards = partitionsByShard.size();
        if (nShards < 1) {
            throw new IllegalStateException("partitionsByShard has no entries");
        }
        int RNThreads = 2 * (this.getConsistency() == Consistency.ABSOLUTE ? nShards : TopologyUtil.getNumRepNodesForRead(this.storeImpl.getTopology(), this.storeImpl.getDispatcher().getReadZoneIds()));
        int nThreads = options.getMaxConcurrentRequests();
        int useNThreads = nThreads == 0 ? RNThreads : Math.min(nThreads, RNThreads);
        this.setTaskExecutor(useNThreads);
        Map<RepGroupId, List<PartitionStream>> streamsByShard = this.generatePartitionStreams(partitionsByShard);
        Collection<List<PartitionStream>> streamsByShardColl = streamsByShard.values();
        List[] streamsByShardArr = streamsByShardColl.toArray(new List[0]);
        do {
            didSomething = false;
            for (int idx = 0; idx < nShards; ++idx) {
                List tasks = streamsByShardArr[idx];
                if (tasks.size() <= 0) continue;
                PartitionStream task = (PartitionStream)tasks.get(0);
                task.submit();
                this.streams.add(task);
                tasks.remove(0);
                didSomething = true;
            }
        } while (didSomething);
    }

    private Map<RepGroupId, List<PartitionStream>> generatePartitionStreams(Map<RepGroupId, Set<Integer>> partitionsByShard) {
        this.logger.fine("Generating Partition Streams");
        HashMap<RepGroupId, List<PartitionStream>> ret = new HashMap<RepGroupId, List<PartitionStream>>(partitionsByShard.size());
        for (Map.Entry<RepGroupId, Set<Integer>> ent : partitionsByShard.entrySet()) {
            RepGroupId rgid = ent.getKey();
            Set<Integer> parts = ent.getValue();
            for (Integer part : parts) {
                PartitionStream pis = this.createStream(rgid, part);
                ArrayList<PartitionStream> partitionStreams = (ArrayList<PartitionStream>)ret.get(rgid);
                if (partitionStreams == null) {
                    partitionStreams = new ArrayList<PartitionStream>();
                    ret.put(rgid, partitionStreams);
                }
                partitionStreams.add(pis);
            }
        }
        return ret;
    }

    private Map<RepGroupId, Set<Integer>> getPartitionTopology(Set<Integer> partitions) {
        Topology topology = this.storeImpl.getDispatcher().getTopologyManager().getTopology();
        Collection datacenters = topology.getDatacenterMap().getAll();
        if (datacenters.size() < 1) {
            throw new IllegalStateException("No zones in topology?");
        }
        HashMap<RepGroupId, Set<Integer>> shardPartitions = new HashMap<RepGroupId, Set<Integer>>();
        if (partitions != null) {
            for (Integer i : partitions) {
                PartitionId partId = new PartitionId(i);
                RepGroupId rgid = topology.getRepGroupId(partId);
                if (rgid == null) {
                    throw new IllegalStateException("Partition " + partId + " not in topology?");
                }
                HashSet<Integer> parts = (HashSet<Integer>)shardPartitions.get(rgid);
                if (parts == null) {
                    parts = new HashSet<Integer>();
                    shardPartitions.put(rgid, parts);
                }
                parts.add(i);
            }
            return shardPartitions;
        }
        for (int i = 1; i <= this.storeImpl.getNPartitions(); ++i) {
            PartitionId partId = new PartitionId(i);
            RepGroupId rgid = topology.getRepGroupId(partId);
            if (rgid == null) {
                throw new IllegalStateException("Partition " + partId + " not in topology?");
            }
            HashSet<Integer> parts = (HashSet<Integer>)shardPartitions.get(rgid);
            if (parts == null) {
                parts = new HashSet<Integer>();
                shardPartitions.put(rgid, parts);
            }
            parts.add(i);
        }
        return shardPartitions;
    }

    protected PartitionStream createStream(RepGroupId groupId, int partitionId) {
        return new PartitionStream(groupId, partitionId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DetailedMetrics> getPartitionMetrics() {
        Map<Integer, DetailedMetricsImpl> map = this.partitionMetrics;
        synchronized (map) {
            ArrayList<DetailedMetricsImpl> l = new ArrayList<DetailedMetricsImpl>(this.partitionMetrics.size());
            l.addAll(this.partitionMetrics.values());
            return Collections.unmodifiableList(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DetailedMetrics> getShardMetrics() {
        Map<RepGroupId, DetailedMetricsImpl> map = this.shardMetrics;
        synchronized (map) {
            ArrayList<DetailedMetrics> ret = new ArrayList<DetailedMetrics>(this.shardMetrics.size());
            ret.addAll(this.shardMetrics.values());
            return ret;
        }
    }

    protected abstract InternalOperation generateGetterOp(byte[] var1);

    @Override
    protected boolean close(Throwable reason) {
        if (!super.close(reason)) {
            return false;
        }
        List<Runnable> unfinishedBusiness = this.getTaskExecutor().shutdownNow();
        if (!unfinishedBusiness.isEmpty()) {
            this.logger.log(Level.FINE, "ParallelScan executor didn''t shutdown cleanly. {0} tasks remaining.", unfinishedBusiness.size());
        }
        return true;
    }

    protected class PartitionStream
    extends BaseParallelScanIteratorImpl.Stream {
        protected final RepGroupId groupId;
        protected final int partitionId;
        protected byte[] resumeKey = null;

        protected PartitionStream(RepGroupId rgi, int part, byte[] resumeKey) {
            this.groupId = rgi;
            this.partitionId = part;
            this.resumeKey = resumeKey;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void updateDetailedMetrics(long timeInMs, long recordCount) {
            DetailedMetricsImpl dmi;
            int partIdx = this.partitionId - 1;
            String shardName = this.groupId.toString();
            Map map = PartitionScanIterator.this.partitionMetrics;
            synchronized (map) {
                dmi = (DetailedMetricsImpl)PartitionScanIterator.this.partitionMetrics.get(partIdx);
                if (dmi != null) {
                    dmi.inc(timeInMs, recordCount);
                } else {
                    StringBuilder sb = new StringBuilder();
                    sb.append(this.partitionId).append(" (").append(shardName).append(")");
                    dmi = new DetailedMetricsImpl(sb.toString(), timeInMs, recordCount);
                    PartitionScanIterator.this.partitionMetrics.put(partIdx, dmi);
                }
            }
            map = PartitionScanIterator.this.shardMetrics;
            synchronized (map) {
                dmi = (DetailedMetricsImpl)PartitionScanIterator.this.shardMetrics.get(this.groupId);
                if (dmi == null) {
                    dmi = new DetailedMetricsImpl(shardName, timeInMs, recordCount);
                    PartitionScanIterator.this.shardMetrics.put(this.groupId, dmi);
                    return;
                }
            }
            dmi.inc(timeInMs, recordCount);
        }

        @Override
        protected Request makeReadRequest() {
            return PartitionScanIterator.this.storeImpl.makeReadRequest(PartitionScanIterator.this.generateGetterOp(this.resumeKey), new PartitionId(this.partitionId), PartitionScanIterator.this.storeIteratorParams.getConsistency(), PartitionScanIterator.this.storeIteratorParams.getTimeout(), PartitionScanIterator.this.storeIteratorParams.getTimeoutUnit(), null);
        }

        @Override
        protected void setResumeKey(Result result) {
            this.resumeKey = result.getPrimaryResumeKey();
        }

        public String toString() {
            return "PartitionStream[" + this.groupId + ":" + this.partitionId + ", " + this.getStatus() + "]";
        }
    }
}

