/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.ResourceLimitException;
import oracle.kv.impl.util.SerializationUtil;

public class ThroughputLimitException
extends ResourceLimitException {
    private static final long serialVersionUID = 1L;
    private final int readRate;
    private final int readRateLimit;
    private final int writeRate;
    private final int writeRateLimit;

    public ThroughputLimitException(String tableName, int readRate, int readRateLimit, int writeRate, int writeRateLimit, String msg) {
        super(tableName, msg);
        assert (readRate > 0 || writeRate > 0);
        this.readRate = readRate;
        this.readRateLimit = readRateLimit;
        this.writeRate = writeRate;
        this.writeRateLimit = writeRateLimit;
    }

    public ThroughputLimitException(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.readRate = SerializationUtil.readPackedInt(in);
        this.readRateLimit = SerializationUtil.readPackedInt(in);
        this.writeRate = SerializationUtil.readPackedInt(in);
        this.writeRateLimit = SerializationUtil.readPackedInt(in);
    }

    public int getReadRate() {
        return this.readRate;
    }

    public int getReadRateLimit() {
        return this.readRateLimit;
    }

    public int getWriteRate() {
        return this.writeRate;
    }

    public int getWriteRateLimit() {
        return this.writeRateLimit;
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        SerializationUtil.writePackedInt(out, this.readRate);
        SerializationUtil.writePackedInt(out, this.readRateLimit);
        SerializationUtil.writePackedInt(out, this.writeRate);
        SerializationUtil.writePackedInt(out, this.writeRateLimit);
    }
}

