/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.compiler;

import jakarta.xml.bind.JAXBElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.JAXBException;
import org.eclipse.persistence.internal.oxm.Constants;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.jaxb.TypeMappingInfo;
import org.eclipse.persistence.jaxb.compiler.AnnotationsProcessor;
import org.eclipse.persistence.jaxb.compiler.EnumTypeInfo;
import org.eclipse.persistence.jaxb.compiler.JAXBMetadataLogger;
import org.eclipse.persistence.jaxb.compiler.NamespaceInfo;
import org.eclipse.persistence.jaxb.compiler.PackageInfo;
import org.eclipse.persistence.jaxb.compiler.Property;
import org.eclipse.persistence.jaxb.compiler.TypeInfo;
import org.eclipse.persistence.jaxb.javamodel.Helper;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaField;
import org.eclipse.persistence.jaxb.javamodel.JavaHasAnnotations;
import org.eclipse.persistence.jaxb.javamodel.JavaMethod;
import org.eclipse.persistence.jaxb.javamodel.JavaModelInput;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaClassImpl;
import org.eclipse.persistence.jaxb.xmlmodel.JavaAttribute;
import org.eclipse.persistence.jaxb.xmlmodel.JavaType;
import org.eclipse.persistence.jaxb.xmlmodel.XmlAbstractNullPolicy;
import org.eclipse.persistence.jaxb.xmlmodel.XmlAccessType;
import org.eclipse.persistence.jaxb.xmlmodel.XmlAnyAttribute;
import org.eclipse.persistence.jaxb.xmlmodel.XmlAnyElement;
import org.eclipse.persistence.jaxb.xmlmodel.XmlAttribute;
import org.eclipse.persistence.jaxb.xmlmodel.XmlBindings;
import org.eclipse.persistence.jaxb.xmlmodel.XmlElement;
import org.eclipse.persistence.jaxb.xmlmodel.XmlElementNillable;
import org.eclipse.persistence.jaxb.xmlmodel.XmlElementRef;
import org.eclipse.persistence.jaxb.xmlmodel.XmlElementRefs;
import org.eclipse.persistence.jaxb.xmlmodel.XmlElementWrapper;
import org.eclipse.persistence.jaxb.xmlmodel.XmlElements;
import org.eclipse.persistence.jaxb.xmlmodel.XmlEnum;
import org.eclipse.persistence.jaxb.xmlmodel.XmlEnumValue;
import org.eclipse.persistence.jaxb.xmlmodel.XmlInverseReference;
import org.eclipse.persistence.jaxb.xmlmodel.XmlJavaTypeAdapter;
import org.eclipse.persistence.jaxb.xmlmodel.XmlJavaTypeAdapters;
import org.eclipse.persistence.jaxb.xmlmodel.XmlJoinNodes;
import org.eclipse.persistence.jaxb.xmlmodel.XmlMap;
import org.eclipse.persistence.jaxb.xmlmodel.XmlNamedObjectGraph;
import org.eclipse.persistence.jaxb.xmlmodel.XmlNsForm;
import org.eclipse.persistence.jaxb.xmlmodel.XmlNullPolicy;
import org.eclipse.persistence.jaxb.xmlmodel.XmlProperties;
import org.eclipse.persistence.jaxb.xmlmodel.XmlRegistry;
import org.eclipse.persistence.jaxb.xmlmodel.XmlSchema;
import org.eclipse.persistence.jaxb.xmlmodel.XmlSchemaType;
import org.eclipse.persistence.jaxb.xmlmodel.XmlSchemaTypes;
import org.eclipse.persistence.jaxb.xmlmodel.XmlTransformation;
import org.eclipse.persistence.jaxb.xmlmodel.XmlTransient;
import org.eclipse.persistence.jaxb.xmlmodel.XmlValue;
import org.eclipse.persistence.jaxb.xmlmodel.XmlVariableNode;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLNameTransformer;

public class XMLProcessor {
    private Map<String, XmlBindings> xmlBindingMap;
    private JavaModelInput jModelInput;
    private AnnotationsProcessor aProcessor;
    private JAXBMetadataLogger logger;
    private static final char COLON = ':';
    private static final char SLASH = '/';
    private static final String SELF = ".";
    private static final char OPEN_BRACKET = '[';
    private static final String IS_STR = "is";
    private static final String GET_STR = "get";
    private static final String SET_STR = "set";
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";
    public static final String DEFAULT = "##default";
    public static final String GENERATE = "##generate";

    public XMLProcessor(Map<String, XmlBindings> bindings) {
        this.xmlBindingMap = bindings;
    }

    /*
     * WARNING - void declaration
     */
    public void processXML(AnnotationsProcessor annotationsProcessor, JavaModelInput jModelInput, TypeMappingInfo[] typeMappingInfos, JavaClass[] originalJavaClasses) {
        XmlBindings xmlBindings;
        ArrayList<JavaClass> classesToProcess;
        this.jModelInput = jModelInput;
        this.aProcessor = annotationsProcessor;
        this.aProcessor.setHasXmlBindings(true);
        HashMap<String, XmlEnum> xmlEnumMap = new HashMap<String, XmlEnum>();
        this.aProcessor.init(originalJavaClasses, typeMappingInfos);
        Map<String, ArrayList<JavaClass>> pkgToClassMap = this.buildPackageToJavaClassMap();
        for (String packageName : this.xmlBindingMap.keySet()) {
            XmlBindings.JavaTypes jTypes;
            void var16_29;
            XmlBindings.XmlRegistries xmlRegs;
            classesToProcess = pkgToClassMap.get(packageName);
            if (classesToProcess == null) {
                this.getLogger().logWarning("jaxb_metadata_warning_no_classes_to_process", new Object[]{packageName});
                continue;
            }
            xmlBindings = this.xmlBindingMap.get(packageName);
            NamespaceInfo namespaceInfo = this.processXmlSchema(xmlBindings, packageName);
            if (namespaceInfo != null) {
                this.aProcessor.addPackageToNamespaceMapping(packageName, namespaceInfo);
            }
            if (null != xmlBindings.getXmlElementNillable()) {
                this.aProcessor.addPackageToXmlElementNillable(packageName, xmlBindings.getXmlElementNillable());
            }
            if (null != xmlBindings.getXmlNullPolicy()) {
                this.aProcessor.addPackageToXmlNullPolicy(packageName, xmlBindings.getXmlNullPolicy());
            }
            if ((xmlRegs = xmlBindings.getXmlRegistries()) != null) {
                for (XmlRegistry xmlRegistry : xmlRegs.getXmlRegistry()) {
                    this.aProcessor.addXmlRegistry(xmlRegistry.getName(), xmlRegistry);
                }
            }
            JavaClass[] javaClasses = classesToProcess.toArray(new JavaClass[classesToProcess.size()]);
            XmlBindings.XmlEnums xmlEnums = xmlBindings.getXmlEnums();
            if (xmlEnums != null) {
                for (XmlEnum xmlEnum : xmlEnums.getXmlEnum()) {
                    xmlEnumMap.put(Helper.getQualifiedJavaTypeName(xmlEnum.getJavaEnum(), packageName), xmlEnum);
                }
            }
            if (xmlBindings.getJavaTypes() != null) {
                List<JavaType> types = xmlBindings.getJavaTypes().getJavaType();
                for (JavaType next : types) {
                    JavaClass typeClass = jModelInput.getJavaModel().getClass(Helper.getQualifiedJavaTypeName(next.getName(), packageName));
                    if (typeClass == null || typeClass.getClass() != JavaClassImpl.class || next.getSuperType() == null || next.getSuperType().equals(DEFAULT)) continue;
                    JavaClass newSuperClass = jModelInput.getJavaModel().getClass(next.getSuperType());
                    ((JavaClassImpl)typeClass).setSuperClassOverride(newSuperClass);
                }
            }
            Map<String, TypeInfo> typeInfoMap = this.aProcessor.preBuildTypeInfo(javaClasses);
            Object var16_34 = null;
            XmlSchemaTypes sTypes = xmlBindings.getXmlSchemaTypes();
            if (sTypes != null) {
                List<XmlSchemaType> list = sTypes.getXmlSchemaType();
            } else {
                ArrayList arrayList = new ArrayList();
            }
            if (xmlBindings.getXmlSchemaType() != null) {
                var16_29.add(xmlBindings.getXmlSchemaType());
            }
            for (XmlSchemaType sType : var16_29) {
                JavaClass jClass = this.aProcessor.getHelper().getJavaClass(sType.getType());
                if (jClass == null) continue;
                this.aProcessor.processSchemaType(sType.getName(), sType.getNamespace(), jClass.getQualifiedName());
            }
            PackageInfo packageInfo = this.aProcessor.getPackageToPackageInfoMappings().get(packageName);
            if (packageInfo == null) {
                packageInfo = new PackageInfo();
            }
            if (xmlBindings.isSetXmlAccessorType()) {
                packageInfo.setAccessType(xmlBindings.getXmlAccessorType());
            }
            if ((jTypes = xmlBindings.getJavaTypes()) != null) {
                for (JavaType javaType : jTypes.getJavaType()) {
                    String transformerClassName;
                    XMLNameTransformer transformer;
                    XmlElementNillable xmlElementNillable;
                    XmlNullPolicy xmlNullPolicy;
                    TypeInfo info = typeInfoMap.get(Helper.getQualifiedJavaTypeName(javaType.getName(), packageName));
                    if (javaType.getXmlJavaTypeAdapter() != null) {
                        info.setXmlJavaTypeAdapter(javaType.getXmlJavaTypeAdapter());
                    }
                    if (null != (xmlNullPolicy = javaType.getXmlNullPolicy())) {
                        info.setXmlNullPolicy(xmlNullPolicy);
                    }
                    if (null != (xmlElementNillable = javaType.getXmlElementNillable())) {
                        info.setXmlElementNillable(xmlElementNillable.isNillable());
                    }
                    if ((transformer = this.getXMLNameTransformerClassFromString(transformerClassName = javaType.getXmlNameTransformer())) != null) {
                        info.setXmlNameTransformer(transformer);
                    }
                    if (javaType.getXmlVirtualAccessMethods() != null) {
                        info.setXmlVirtualAccessMethods(javaType.getXmlVirtualAccessMethods());
                    }
                    if (javaType.isSetXmlAccessorOrder()) {
                        info.setXmlAccessOrder(javaType.getXmlAccessorOrder());
                    } else if (!info.isSetXmlAccessOrder()) {
                        if (xmlBindings.isSetXmlAccessorOrder()) {
                            info.setXmlAccessOrder(xmlBindings.getXmlAccessorOrder());
                        } else {
                            info.setXmlAccessOrder(packageInfo.getAccessOrder());
                        }
                    }
                    if (javaType.isSetXmlAccessorType()) {
                        info.setXmlAccessType(javaType.getXmlAccessorType());
                    }
                    if (javaType.isSetXmlInlineBinaryData()) {
                        info.setInlineBinaryData(javaType.isXmlInlineBinaryData());
                    }
                    if (javaType.isSetXmlTransient()) {
                        info.setXmlTransient(javaType.isXmlTransient());
                    }
                    if (javaType.getXmlRootElement() != null) {
                        info.setXmlRootElement(javaType.getXmlRootElement());
                    }
                    if (javaType.getXmlSeeAlso() != null && javaType.getXmlSeeAlso().size() > 0) {
                        info.setXmlSeeAlso(javaType.getXmlSeeAlso());
                    }
                    if (javaType.getXmlType() != null) {
                        info.setXmlType(javaType.getXmlType());
                    }
                    if (javaType.getXmlCustomizer() != null) {
                        info.setXmlCustomizer(javaType.getXmlCustomizer());
                    }
                    if (javaType.getXmlClassExtractor() != null) {
                        info.setClassExtractorName(javaType.getXmlClassExtractor().getClazz());
                    }
                    if (javaType.getXmlProperties() != null && javaType.getXmlProperties().getXmlProperty().size() > 0) {
                        if (info.getUserProperties() != null) {
                            info.setUserProperties(this.mergeUserPropertyMap(javaType.getXmlProperties().getXmlProperty(), info.getUserProperties()));
                        } else {
                            info.setUserProperties(this.createUserPropertyMap(javaType.getXmlProperties().getXmlProperty()));
                        }
                    }
                    if (javaType.getXmlDiscriminatorNode() != null) {
                        info.setXmlDiscriminatorNode(javaType.getXmlDiscriminatorNode());
                    }
                    if (javaType.getXmlNamedObjectGraphs() != null) {
                        List<XmlNamedObjectGraph> currentGraphs = info.getObjectGraphs();
                        block8: for (XmlNamedObjectGraph nextGraph : javaType.getXmlNamedObjectGraphs().getXmlNamedObjectGraph()) {
                            for (XmlNamedObjectGraph nextExistingGraph : currentGraphs) {
                                if (!nextGraph.getName().equals(nextExistingGraph.getName())) continue;
                                currentGraphs.remove(nextExistingGraph);
                                continue block8;
                            }
                        }
                        currentGraphs.addAll(javaType.getXmlNamedObjectGraphs().getXmlNamedObjectGraph());
                    }
                    if (javaType.getXmlDiscriminatorValue() == null) continue;
                    info.setXmlDiscriminatorValue(javaType.getXmlDiscriminatorValue());
                }
            }
            Map<String, TypeInfo> typeInfos = this.aProcessor.getTypeInfosForPackage(packageName);
            String transformerClassName = xmlBindings.getXmlNameTransformer();
            XMLNameTransformer transformer = this.getXMLNameTransformerClassFromString(transformerClassName);
            if (transformer != null) {
                packageInfo.setXmlNameTransformer(transformer);
            }
            for (TypeInfo tInfo : typeInfos.values()) {
                if (xmlBindings.getXmlJavaTypeAdapters() == null) continue;
                List<XmlJavaTypeAdapter> adapters = xmlBindings.getXmlJavaTypeAdapters().getXmlJavaTypeAdapter();
                for (XmlJavaTypeAdapter xja : adapters) {
                    try {
                        JavaClass adapterClass = jModelInput.getJavaModel().getClass(xja.getValue());
                        JavaClass boundType = jModelInput.getJavaModel().getClass(xja.getType());
                        if (boundType == null) continue;
                        tInfo.addPackageLevelAdapterClass(adapterClass, boundType);
                        packageInfo.getPackageLevelAdaptersByClass().put(boundType.getQualifiedName(), adapterClass);
                    }
                    catch (JAXBException e) {
                        throw JAXBException.invalidPackageAdapterClass(xja.getValue(), packageName);
                    }
                }
            }
        }
        for (String packageName : this.xmlBindingMap.keySet()) {
            classesToProcess = pkgToClassMap.get(packageName);
            if (classesToProcess == null) {
                this.getLogger().logWarning("jaxb_metadata_warning_no_classes_to_process", new Object[]{packageName});
                continue;
            }
            xmlBindings = this.xmlBindingMap.get(packageName);
            JavaClass[] javaClassArray2 = classesToProcess.toArray(new JavaClass[classesToProcess.size()]);
            javaClassArray2 = this.aProcessor.postBuildTypeInfo(javaClassArray2);
            Map<String, TypeInfo> typeInfosForPackage = this.aProcessor.getTypeInfosForPackage(packageName);
            for (Map.Entry entry : typeInfosForPackage.entrySet()) {
                EnumTypeInfo enumTypeInfo;
                XmlEnum xmlEnum;
                TypeInfo tInfo = (TypeInfo)entry.getValue();
                if (!tInfo.isEnumerationType() || (xmlEnum = (XmlEnum)xmlEnumMap.get((enumTypeInfo = (EnumTypeInfo)tInfo).getClassName())) == null) continue;
                JavaClass restrictionClass = this.aProcessor.getHelper().getJavaClass(xmlEnum.getValue());
                if (restrictionClass == null) {
                    restrictionClass = jModelInput.getJavaModel().getClass(String.class);
                }
                enumTypeInfo.setRestrictionBase(this.aProcessor.getSchemaTypeFor(restrictionClass));
                for (XmlEnumValue xmlEnumValue : xmlEnum.getXmlEnumValue()) {
                    enumTypeInfo.addJavaFieldToXmlEnumValuePair(true, xmlEnumValue.getJavaEnumValue(), xmlEnumValue.getValue());
                }
            }
            XmlBindings.JavaTypes jTypes = xmlBindings.getJavaTypes();
            if (jTypes != null) {
                PackageInfo packageInfo = this.aProcessor.getPackageToPackageInfoMappings().get(packageName);
                NamespaceInfo nsInfo = null;
                if (null != packageInfo) {
                    nsInfo = packageInfo.getNamespaceInfo();
                }
                for (JavaType javaType : jTypes.getJavaType()) {
                    this.processJavaType(javaType, typeInfosForPackage.get(Helper.getQualifiedJavaTypeName(javaType.getName(), packageName)), nsInfo);
                }
            }
            pkgToClassMap.remove(packageName);
        }
        for (ArrayList<JavaClass> jClassList : pkgToClassMap.values()) {
            JavaClass[] jClassArray = jClassList.toArray(new JavaClass[jClassList.size()]);
            this.aProcessor.buildNewTypeInfo(jClassArray);
            this.aProcessor.checkForCallbackMethods();
        }
        Map typeInfos = (Map)((HashMap)this.aProcessor.getTypeInfos()).clone();
        for (Map.Entry entry : typeInfos.entrySet()) {
            for (Property property : ((TypeInfo)entry.getValue()).getPropertyList()) {
                if (!property.isSetXmlJavaTypeAdapter()) continue;
                JavaClass[] jClassArray = new JavaClass[]{property.getActualType()};
                this.aProcessor.buildNewTypeInfo(jClassArray);
            }
        }
        List<JavaClass> jClasses = this.aProcessor.getTypeInfoClasses();
        if (this.xmlBindingMap.size() > 1) {
            for (JavaClass c : jClasses) {
                TypeInfo ti = this.aProcessor.getTypeInfos().get(c.getQualifiedName());
                this.aProcessor.processPropertiesSuperClass(c, ti);
            }
        }
        this.aProcessor.processPropertyTypes(jClasses.toArray(new JavaClass[jClasses.size()]));
        this.aProcessor.finalizeProperties();
        this.aProcessor.createElementsForTypeMappingInfo();
        this.aProcessor.checkForCallbackMethods();
    }

    private XMLNameTransformer getXMLNameTransformerClassFromString(String transformerClassName) {
        XMLNameTransformer transformer = null;
        if (transformerClassName != null) {
            Class<?> nameTransformerClass;
            try {
                nameTransformerClass = Class.forName(transformerClassName);
            }
            catch (ClassNotFoundException ex) {
                throw JAXBException.exceptionWithNameTransformerClass(transformerClassName, ex);
            }
            try {
                transformer = (XMLNameTransformer)nameTransformerClass.newInstance();
            }
            catch (InstantiationException ex) {
                throw JAXBException.exceptionWithNameTransformerClass(transformerClassName, ex);
            }
            catch (IllegalAccessException ex) {
                throw JAXBException.exceptionWithNameTransformerClass(transformerClassName, ex);
            }
        }
        return transformer;
    }

    private void processJavaType(JavaType javaType, TypeInfo typeInfo, NamespaceInfo nsInfo) {
        if (null != javaType.getJavaAttributes()) {
            ArrayList<String> processedPropertyNames = new ArrayList<String>();
            for (JAXBElement<? extends JavaAttribute> jaxbElement : javaType.getJavaAttributes().getJavaAttribute()) {
                boolean alreadyProcessed;
                JavaAttribute javaAttribute = (JavaAttribute)jaxbElement.getValue();
                Property originalProperty = typeInfo.getOriginalProperties().get(javaAttribute.getJavaAttribute());
                if (javaAttribute.getXmlAccessorType() != null) {
                    originalProperty = this.processPropertyForAccessorType(typeInfo, javaAttribute, originalProperty);
                }
                if (originalProperty == null) {
                    if (typeInfo.getXmlVirtualAccessMethods() != null) {
                        Property newProperty = new Property(this.aProcessor.getHelper());
                        newProperty.setPropertyName(javaAttribute.getJavaAttribute());
                        newProperty.setExtension(true);
                        String attributeType = null;
                        if (javaAttribute instanceof XmlElement) {
                            attributeType = ((XmlElement)javaAttribute).getType();
                        } else if (javaAttribute instanceof XmlAttribute) {
                            attributeType = ((XmlAttribute)javaAttribute).getType();
                        }
                        if (attributeType != null && attributeType.equals("DEFAULT")) {
                            newProperty.setType(this.jModelInput.getJavaModel().getClass(attributeType));
                        } else {
                            newProperty.setType(this.jModelInput.getJavaModel().getClass("java.lang.String"));
                        }
                        originalProperty = newProperty;
                        typeInfo.addProperty(javaAttribute.getJavaAttribute(), newProperty);
                    } else {
                        this.getLogger().logWarning("jaxb_metadata_warning_ignoring_java_attribute", new Object[]{javaAttribute.getJavaAttribute(), javaType.getName()});
                        continue;
                    }
                }
                Property propToProcess = (alreadyProcessed = processedPropertyNames.contains(javaAttribute.getJavaAttribute())) ? (Property)originalProperty.clone() : typeInfo.getProperties().get(javaAttribute.getJavaAttribute());
                this.processJavaAttribute(typeInfo, javaAttribute, propToProcess, nsInfo, javaType);
                if (propToProcess.isTransient()) {
                    typeInfo.getPropertyList().remove(propToProcess);
                }
                if (alreadyProcessed) {
                    List<Property> additionalProps = null;
                    if (typeInfo.hasAdditionalProperties()) {
                        additionalProps = typeInfo.getAdditionalProperties().get(javaAttribute.getJavaAttribute());
                    }
                    if (additionalProps == null) {
                        additionalProps = new ArrayList<Property>();
                    }
                    additionalProps.add(propToProcess);
                    typeInfo.getAdditionalProperties().put(javaAttribute.getJavaAttribute(), additionalProps);
                    continue;
                }
                typeInfo.getProperties().put(javaAttribute.getJavaAttribute(), propToProcess);
                processedPropertyNames.add(javaAttribute.getJavaAttribute());
            }
        }
    }

    private Property processPropertyForAccessorType(TypeInfo typeInfo, JavaAttribute javaAttribute, Property originalProperty) {
        if (originalProperty == null) {
            Property prop = this.createProperty(typeInfo, javaAttribute);
            if (prop != null) {
                typeInfo.addProperty(prop.getPropertyName(), prop);
            }
            return prop;
        }
        if (javaAttribute.getXmlAccessorType() == XmlAccessType.FIELD && !originalProperty.isMethodProperty() || javaAttribute.getXmlAccessorType() == XmlAccessType.PROPERTY && originalProperty.isMethodProperty()) {
            return originalProperty;
        }
        originalProperty.setMethodProperty(!originalProperty.isMethodProperty());
        if (originalProperty.isMethodProperty()) {
            JavaClass jClass = this.jModelInput.getJavaModel().getClass(typeInfo.getJavaClassName());
            String propName = originalProperty.getPropertyName();
            propName = Character.toUpperCase(propName.charAt(0)) + propName.substring(1);
            String getMethodName = GET_STR + propName;
            String setMethodName = SET_STR + propName;
            JavaMethod getMethod = jClass.getDeclaredMethod(getMethodName, new JavaClass[0]);
            if (getMethod == null) {
                getMethodName = IS_STR + propName;
                getMethod = jClass.getDeclaredMethod(getMethodName, new JavaClass[0]);
            }
            JavaMethod setMethod = jClass.getDeclaredMethod(setMethodName, new JavaClass[]{originalProperty.getType()});
            if (getMethod != null) {
                originalProperty.setGetMethodName(getMethodName);
            }
            if (setMethod != null) {
                originalProperty.setSetMethodName(setMethodName);
            }
        } else {
            originalProperty.setGetMethodName(null);
            originalProperty.setSetMethodName(null);
            originalProperty.setMethodProperty(false);
        }
        return originalProperty;
    }

    private Property createProperty(TypeInfo info, JavaAttribute javaAttribute) {
        XmlAccessType xmlAccessorType = javaAttribute.getXmlAccessorType();
        String propName = javaAttribute.getJavaAttribute();
        JavaHasAnnotations element = null;
        JavaClass pType = null;
        JavaClass jClass = this.jModelInput.getJavaModel().getClass(info.getJavaClassName());
        if (xmlAccessorType == XmlAccessType.PROPERTY) {
            String name = Character.toUpperCase(propName.charAt(0)) + propName.substring(1);
            String getMethodName = GET_STR + name;
            String setMethodName = SET_STR + name;
            JavaMethod jMethod = jClass.getDeclaredMethod(getMethodName, new JavaClass[0]);
            if (jMethod == null) {
                getMethodName = IS_STR + name;
                jMethod = jClass.getDeclaredMethod(getMethodName, new JavaClass[0]);
            }
            if (jMethod != null) {
                pType = jMethod.getReturnType();
                element = jMethod;
            } else {
                for (Object next : jClass.getDeclaredMethods()) {
                    JavaMethod nextMethod = (JavaMethod)next;
                    if (!nextMethod.getName().equals(setMethodName) || nextMethod.getParameterTypes().length != 1) continue;
                    pType = nextMethod.getParameterTypes()[0];
                    element = nextMethod;
                }
                if (element == null) {
                    return null;
                }
            }
        } else {
            JavaField jField = jClass.getDeclaredField(propName);
            if (jField == null) {
                return null;
            }
            pType = jField.getResolvedType();
            element = jField;
        }
        return this.aProcessor.buildNewProperty(info, jClass, element, propName, pType);
    }

    private Property processJavaAttribute(TypeInfo typeInfo, JavaAttribute javaAttribute, Property oldProperty, NamespaceInfo nsInfo, JavaType javaType) {
        if (javaAttribute instanceof XmlVariableNode) {
            return this.processXmlVariableNodeAttribute((XmlVariableNode)javaAttribute, oldProperty, typeInfo, javaType);
        }
        if (javaAttribute instanceof XmlAnyAttribute) {
            return this.processXmlAnyAttribute((XmlAnyAttribute)javaAttribute, oldProperty, typeInfo, javaType);
        }
        if (javaAttribute instanceof XmlAnyElement) {
            return this.processXmlAnyElement((XmlAnyElement)javaAttribute, oldProperty, typeInfo, javaType);
        }
        if (javaAttribute instanceof XmlAttribute) {
            return this.processXmlAttribute((XmlAttribute)javaAttribute, oldProperty, typeInfo, nsInfo, javaType);
        }
        if (javaAttribute instanceof XmlElement) {
            return this.processXmlElement((XmlElement)javaAttribute, oldProperty, typeInfo, nsInfo, javaType);
        }
        if (javaAttribute instanceof XmlElements) {
            return this.processXmlElements((XmlElements)javaAttribute, oldProperty, typeInfo);
        }
        if (javaAttribute instanceof XmlElementRef) {
            return this.processXmlElementRef((XmlElementRef)javaAttribute, oldProperty, typeInfo);
        }
        if (javaAttribute instanceof XmlElementRefs) {
            return this.processXmlElementRefs((XmlElementRefs)javaAttribute, oldProperty, typeInfo);
        }
        if (javaAttribute instanceof XmlTransient) {
            return this.processXmlTransient((XmlTransient)javaAttribute, oldProperty);
        }
        if (javaAttribute instanceof XmlValue) {
            return this.processXmlValue((XmlValue)javaAttribute, oldProperty, typeInfo, javaType);
        }
        if (javaAttribute instanceof XmlJavaTypeAdapter) {
            return this.processXmlJavaTypeAdapter((XmlJavaTypeAdapter)javaAttribute, oldProperty);
        }
        if (javaAttribute instanceof XmlInverseReference) {
            return this.processXmlInverseReference((XmlInverseReference)javaAttribute, oldProperty, typeInfo);
        }
        if (javaAttribute instanceof XmlTransformation) {
            return this.processXmlTransformation((XmlTransformation)javaAttribute, oldProperty, typeInfo);
        }
        if (javaAttribute instanceof XmlJoinNodes) {
            return this.processXmlJoinNodes((XmlJoinNodes)javaAttribute, oldProperty, typeInfo);
        }
        this.getLogger().logWarning("jaxb_metadata_warning_invalid_java_attribute", new Object[]{javaAttribute.getClass()});
        return null;
    }

    private Property processXmlJavaTypeAdapter(XmlJavaTypeAdapter xmlAdapter, Property oldProperty) {
        oldProperty.setXmlJavaTypeAdapter(xmlAdapter);
        return oldProperty;
    }

    private Property processXmlInverseReference(XmlInverseReference xmlInverseReference, Property oldProperty, TypeInfo info) {
        this.resetProperty(oldProperty, info);
        oldProperty.setInverseReference(true, false);
        oldProperty.setInverseReferencePropertyName(xmlInverseReference.getMappedBy());
        if (xmlInverseReference.getXmlAccessMethods() != null) {
            oldProperty.setInverseReferencePropertyGetMethodName(xmlInverseReference.getXmlAccessMethods().getGetMethod());
            oldProperty.setInverseReferencePropertySetMethodName(xmlInverseReference.getXmlAccessMethods().getSetMethod());
        }
        if (xmlInverseReference.getXmlProperties() != null && xmlInverseReference.getXmlProperties().getXmlProperty().size() > 0) {
            oldProperty.setUserProperties(this.createUserPropertyMap(xmlInverseReference.getXmlProperties().getXmlProperty()));
        }
        if (!xmlInverseReference.getContainerType().equals(DEFAULT)) {
            this.setContainerType(oldProperty, xmlInverseReference.getContainerType());
        }
        if (!xmlInverseReference.getType().equals(DEFAULT)) {
            JavaClass pType = this.jModelInput.getJavaModel().getClass(xmlInverseReference.getType());
            if (this.aProcessor.getHelper().isCollectionType(oldProperty.getType())) {
                oldProperty.setGenericType(pType);
            } else {
                oldProperty.setType(pType);
            }
            oldProperty.setHasXmlElementType(true);
            if (this.aProcessor.shouldGenerateTypeInfo(pType) && this.aProcessor.getTypeInfos().get(pType.getQualifiedName()) == null) {
                this.aProcessor.buildNewTypeInfo(new JavaClass[]{pType});
            }
        }
        return oldProperty;
    }

    private Property processXmlAnyAttribute(XmlAnyAttribute xmlAnyAttribute, Property oldProperty, TypeInfo tInfo, JavaType javaType) {
        if (oldProperty.isAnyAttribute()) {
            return oldProperty;
        }
        if (!this.aProcessor.getHelper().isMapType(oldProperty.getType())) {
            if (oldProperty.getType().getClass().getName().contains("OXMJavaClassImpl")) {
                JavaClass pType = this.jModelInput.getJavaModel().getClass("java.util.Map");
                oldProperty.setType(pType);
            } else {
                throw JAXBException.anyAttributeOnNonMap(oldProperty.getPropertyName());
            }
        }
        this.resetProperty(oldProperty, tInfo);
        oldProperty.setIsAnyAttribute(true);
        tInfo.setAnyAttributePropertyName(oldProperty.getPropertyName());
        if (xmlAnyAttribute.getXmlPath() != null) {
            oldProperty.setXmlPath(xmlAnyAttribute.getXmlPath());
        }
        if (xmlAnyAttribute.getXmlAccessMethods() != null) {
            oldProperty.setMethodProperty(true);
            oldProperty.setGetMethodName(xmlAnyAttribute.getXmlAccessMethods().getGetMethod());
            oldProperty.setSetMethodName(xmlAnyAttribute.getXmlAccessMethods().getSetMethod());
        }
        if (xmlAnyAttribute.isSetReadOnly()) {
            oldProperty.setReadOnly(xmlAnyAttribute.isReadOnly());
        }
        if (xmlAnyAttribute.isSetWriteOnly()) {
            oldProperty.setWriteOnly(xmlAnyAttribute.isWriteOnly());
        }
        if (xmlAnyAttribute.getXmlProperties() != null && xmlAnyAttribute.getXmlProperties().getXmlProperty().size() > 0) {
            oldProperty.setUserProperties(this.createUserPropertyMap(xmlAnyAttribute.getXmlProperties().getXmlProperty()));
        }
        if (!xmlAnyAttribute.getContainerType().equals(DEFAULT)) {
            this.setContainerType(oldProperty, xmlAnyAttribute.getContainerType());
        }
        return oldProperty;
    }

    private Property processXmlVariableNodeAttribute(XmlVariableNode xmlVariableNode, Property oldProperty, TypeInfo tInfo, JavaType javaType) {
        this.processObjectFactory(tInfo);
        this.resetProperty(oldProperty, tInfo);
        oldProperty.setVariableAttributeName(xmlVariableNode.getJavaVariableAttribute());
        String type = xmlVariableNode.getType();
        if (!type.equals(DEFAULT)) {
            oldProperty.setVariableClassName(type);
        }
        if (xmlVariableNode.getXmlPath() != null) {
            oldProperty.setXmlPath(xmlVariableNode.getXmlPath());
        } else {
            XmlElementWrapper xmlElementWrapper = xmlVariableNode.getXmlElementWrapper();
            if (xmlElementWrapper != null) {
                if (DEFAULT.equals(xmlElementWrapper.getName())) {
                    xmlElementWrapper.setName(tInfo.getXmlNameTransformer().transformElementName(oldProperty.getPropertyName()));
                }
                oldProperty.setXmlElementWrapper(xmlVariableNode.getXmlElementWrapper());
            }
        }
        return oldProperty;
    }

    private Property processXmlAnyElement(XmlAnyElement xmlAnyElement, Property oldProperty, TypeInfo tInfo, JavaType javaType) {
        this.processObjectFactory(tInfo);
        this.resetProperty(oldProperty, tInfo);
        oldProperty.setIsAny(true);
        oldProperty.setDomHandlerClassName(xmlAnyElement.getDomHandler());
        oldProperty.setLax(xmlAnyElement.isLax());
        oldProperty.setMixedContent(xmlAnyElement.isXmlMixed());
        oldProperty.setXmlJavaTypeAdapter(xmlAnyElement.getXmlJavaTypeAdapter());
        tInfo.setMixed(xmlAnyElement.isXmlMixed());
        tInfo.setAnyElementPropertyName(oldProperty.getPropertyName());
        if (xmlAnyElement.getXmlPath() != null) {
            oldProperty.setXmlPath(xmlAnyElement.getXmlPath());
        }
        if (xmlAnyElement.getXmlAccessMethods() != null) {
            oldProperty.setMethodProperty(true);
            oldProperty.setGetMethodName(xmlAnyElement.getXmlAccessMethods().getGetMethod());
            oldProperty.setSetMethodName(xmlAnyElement.getXmlAccessMethods().getSetMethod());
        }
        if (xmlAnyElement.isSetReadOnly()) {
            oldProperty.setReadOnly(xmlAnyElement.isReadOnly());
        }
        if (xmlAnyElement.isSetWriteOnly()) {
            oldProperty.setWriteOnly(xmlAnyElement.isWriteOnly());
        }
        if (xmlAnyElement.getXmlProperties() != null && xmlAnyElement.getXmlProperties().getXmlProperty().size() > 0) {
            oldProperty.setUserProperties(this.createUserPropertyMap(xmlAnyElement.getXmlProperties().getXmlProperty()));
        }
        if (!xmlAnyElement.getContainerType().equals(DEFAULT)) {
            this.setContainerType(oldProperty, xmlAnyElement.getContainerType());
        }
        if (xmlAnyElement.getXmlElementRefs() != null) {
            oldProperty.setXmlElementRefs(xmlAnyElement.getXmlElementRefs().getXmlElementRef());
            oldProperty.setIsReference(true);
            boolean required = true;
            for (XmlElementRef eltRef : xmlAnyElement.getXmlElementRefs().getXmlElementRef()) {
                required = required && eltRef.isRequired();
            }
            oldProperty.setIsRequired(required);
            if (xmlAnyElement.getXmlElementRefs().isSetXmlMixed()) {
                oldProperty.setMixedContent(xmlAnyElement.getXmlElementRefs().isXmlMixed());
            }
        }
        return oldProperty;
    }

    private Property processXmlAttribute(XmlAttribute xmlAttribute, Property oldProperty, TypeInfo typeInfo, NamespaceInfo nsInfo, JavaType javaType) {
        String namespace;
        String name;
        this.resetProperty(oldProperty, typeInfo);
        if (xmlAttribute.isXmlId()) {
            oldProperty.setIsXmlId(true);
            oldProperty.setIsXmlIdExtension(true);
            typeInfo.setIDProperty(oldProperty);
        } else if (typeInfo.getIDProperty() != null && typeInfo.getIDProperty().getPropertyName().equals(oldProperty.getPropertyName())) {
            typeInfo.setIDProperty(null);
        }
        oldProperty.setIsXmlIdRef(xmlAttribute.isXmlIdref());
        if (xmlAttribute.isXmlKey()) {
            typeInfo.addXmlKeyProperty(oldProperty);
        }
        oldProperty.setIsAttribute(true);
        oldProperty.setisInlineBinaryData(xmlAttribute.isXmlInlineBinaryData());
        if (xmlAttribute.getXmlPath() != null) {
            oldProperty.setXmlPath(xmlAttribute.getXmlPath());
            name = XMLProcessor.getNameFromXPath(xmlAttribute.getXmlPath(), oldProperty.getPropertyName(), true);
            namespace = DEFAULT;
        } else {
            name = xmlAttribute.getName();
            namespace = xmlAttribute.getNamespace();
        }
        if (javaType.getXmlType() != null && javaType.getXmlType().getNamespace() != null && xmlAttribute.getNamespace() != null && xmlAttribute.getNamespace().equals(DEFAULT)) {
            namespace = javaType.getXmlType().getNamespace();
        }
        if (name.equals(DEFAULT)) {
            name = typeInfo.getXmlNameTransformer().transformAttributeName(oldProperty.getPropertyName());
        }
        QName qName = namespace.equals(DEFAULT) ? (nsInfo.isAttributeFormQualified() ? new QName(nsInfo.getNamespace(), name) : new QName(name)) : new QName(namespace, name);
        oldProperty.setSchemaName(qName);
        if (!xmlAttribute.getContainerType().equals(DEFAULT)) {
            this.setContainerType(oldProperty, xmlAttribute.getContainerType());
        }
        if (!xmlAttribute.getType().equals(DEFAULT)) {
            JavaClass pType = this.jModelInput.getJavaModel().getClass(xmlAttribute.getType());
            if (this.aProcessor.getHelper().isCollectionType(oldProperty.getType())) {
                oldProperty.setGenericType(pType);
            } else {
                oldProperty.setType(pType);
            }
            oldProperty.setHasXmlElementType(true);
            if (this.aProcessor.shouldGenerateTypeInfo(pType) && this.aProcessor.getTypeInfos().get(pType.getQualifiedName()) == null) {
                this.aProcessor.buildNewTypeInfo(new JavaClass[]{pType});
            }
        }
        this.reapplyPackageAndClassAdapters(oldProperty, typeInfo);
        if (xmlAttribute.getXmlJavaTypeAdapter() != null) {
            oldProperty.setXmlJavaTypeAdapter(xmlAttribute.getXmlJavaTypeAdapter());
        }
        if (xmlAttribute.isSetRequired()) {
            oldProperty.setIsRequired(xmlAttribute.isRequired());
        } else if (oldProperty.getActualType().isPrimitive()) {
            oldProperty.setIsRequired(true);
        }
        if (xmlAttribute.getXmlMimeType() != null) {
            oldProperty.setMimeType(xmlAttribute.getXmlMimeType());
        }
        if (xmlAttribute.isXmlAttachmentRef()) {
            oldProperty.setIsSwaAttachmentRef(true);
            oldProperty.setSchemaType(Constants.SWA_REF_QNAME);
        } else if (this.aProcessor.isMtomAttachment(oldProperty)) {
            oldProperty.setIsMtomAttachment(true);
            oldProperty.setSchemaType(Constants.BASE_64_BINARY_QNAME);
        }
        if (xmlAttribute.getXmlSchemaType() != null) {
            oldProperty.setSchemaType(new QName(xmlAttribute.getXmlSchemaType().getNamespace(), xmlAttribute.getXmlSchemaType().getName()));
        }
        if (xmlAttribute.getXmlAccessMethods() != null) {
            oldProperty.setMethodProperty(true);
            oldProperty.setGetMethodName(xmlAttribute.getXmlAccessMethods().getGetMethod());
            oldProperty.setSetMethodName(xmlAttribute.getXmlAccessMethods().getSetMethod());
        }
        if (xmlAttribute.isSetReadOnly()) {
            oldProperty.setReadOnly(xmlAttribute.isReadOnly());
        }
        if (xmlAttribute.isSetWriteOnly()) {
            oldProperty.setWriteOnly(xmlAttribute.isWriteOnly());
        }
        if (xmlAttribute.getXmlAbstractNullPolicy() != null) {
            JAXBElement<? extends XmlAbstractNullPolicy> jaxbElt = xmlAttribute.getXmlAbstractNullPolicy();
            oldProperty.setNullPolicy((XmlAbstractNullPolicy)jaxbElt.getValue());
        }
        if (xmlAttribute.getXmlProperties() != null && xmlAttribute.getXmlProperties().getXmlProperty().size() > 0) {
            oldProperty.setUserProperties(this.createUserPropertyMap(xmlAttribute.getXmlProperties().getXmlProperty()));
        }
        return oldProperty;
    }

    private Property processXmlElement(XmlElement xmlElement, Property oldProperty, TypeInfo typeInfo, NamespaceInfo nsInfo, JavaType javaType) {
        String namespace;
        String name;
        this.resetProperty(oldProperty, typeInfo);
        if (xmlElement.getXmlMap() != null) {
            this.processXmlMap(xmlElement.getXmlMap(), oldProperty);
        }
        if (xmlElement.isXmlLocation()) {
            if (!this.aProcessor.getHelper().getJavaClass(Constants.LOCATOR_CLASS).isAssignableFrom(oldProperty.getType())) {
                throw JAXBException.invalidXmlLocation(oldProperty.getPropertyName(), oldProperty.getType().getName());
            }
            oldProperty.setXmlLocation(true);
        }
        if (xmlElement.isXmlId()) {
            oldProperty.setIsXmlId(true);
            oldProperty.setIsXmlIdExtension(true);
            typeInfo.setIDProperty(oldProperty);
        } else if (typeInfo.getIDProperty() != null && typeInfo.getIDProperty().getPropertyName().equals(oldProperty.getPropertyName())) {
            typeInfo.setIDProperty(null);
        }
        if (xmlElement.getXmlInverseReference() != null) {
            String mappedBy = xmlElement.getXmlInverseReference().getMappedBy();
            oldProperty.setInverseReference(true, true);
            oldProperty.setInverseReferencePropertyName(mappedBy);
        }
        oldProperty.setIsXmlIdRef(xmlElement.isXmlIdref());
        if (xmlElement.isXmlKey()) {
            typeInfo.addXmlKeyProperty(oldProperty);
        }
        oldProperty.setIsRequired(xmlElement.isRequired());
        oldProperty.setisInlineBinaryData(xmlElement.isXmlInlineBinaryData());
        oldProperty.setNillable(xmlElement.isNillable());
        if (xmlElement.getDefaultValue().equals("\u0000")) {
            oldProperty.setDefaultValue(null);
        } else {
            oldProperty.setDefaultValue(xmlElement.getDefaultValue());
        }
        if (xmlElement.getXmlPath() != null) {
            oldProperty.setXmlPath(xmlElement.getXmlPath());
            name = XMLProcessor.getNameFromXPath(xmlElement.getXmlPath(), oldProperty.getPropertyName(), false);
            namespace = DEFAULT;
        } else {
            name = xmlElement.getName();
            namespace = xmlElement.getNamespace();
            XmlElementWrapper xmlElementWrapper = xmlElement.getXmlElementWrapper();
            if (xmlElementWrapper != null) {
                if (DEFAULT.equals(xmlElementWrapper.getName())) {
                    xmlElementWrapper.setName(typeInfo.getXmlNameTransformer().transformElementName(oldProperty.getPropertyName()));
                }
                oldProperty.setXmlElementWrapper(xmlElement.getXmlElementWrapper());
                if (oldProperty.isMap()) {
                    name = xmlElement.getXmlElementWrapper().getName();
                    namespace = xmlElement.getXmlElementWrapper().getNamespace();
                }
            }
        }
        if (javaType.getXmlType() != null && javaType.getXmlType().getNamespace() != null && xmlElement.getNamespace() != null && xmlElement.getNamespace().equals(DEFAULT)) {
            namespace = javaType.getXmlType().getNamespace();
        }
        if (name.equals(DEFAULT)) {
            name = typeInfo.getXmlNameTransformer().transformElementName(oldProperty.getPropertyName());
        }
        QName qName = namespace.equals(DEFAULT) ? (nsInfo.isElementFormQualified() ? new QName(nsInfo.getNamespace(), name) : new QName(name)) : new QName(namespace, name);
        oldProperty.setSchemaName(qName);
        if (!xmlElement.getContainerType().equals(DEFAULT)) {
            this.setContainerType(oldProperty, xmlElement.getContainerType());
        }
        if (xmlElement.getType().equals("jakarta.xml.bind.annotation.XmlElement.DEFAULT")) {
            if (oldProperty.isXmlElementType()) {
                oldProperty.setType(oldProperty.getOriginalType());
            }
        } else if (xmlElement.getXmlMap() != null) {
            this.getLogger().logWarning("jaxb_metadata_warning_ignoring_type_on_map", new Object[]{xmlElement.getName()});
        } else {
            JavaClass pType = this.jModelInput.getJavaModel().getClass(xmlElement.getType());
            if (this.aProcessor.getHelper().isCollectionType(oldProperty.getType())) {
                oldProperty.setGenericType(pType);
            } else {
                oldProperty.setType(pType);
            }
            oldProperty.setHasXmlElementType(true);
            if (this.aProcessor.shouldGenerateTypeInfo(pType) && this.aProcessor.getTypeInfos().get(pType.getQualifiedName()) == null) {
                this.aProcessor.buildNewTypeInfo(new JavaClass[]{pType});
            }
        }
        this.reapplyPackageAndClassAdapters(oldProperty, typeInfo);
        if (xmlElement.getXmlJavaTypeAdapter() != null) {
            try {
                oldProperty.setXmlJavaTypeAdapter(xmlElement.getXmlJavaTypeAdapter());
            }
            catch (JAXBException e) {
                throw JAXBException.invalidPropertyAdapterClass(xmlElement.getXmlJavaTypeAdapter().getValue(), xmlElement.getJavaAttribute(), javaType.getName());
            }
        }
        if (!oldProperty.isRequired()) {
            JavaClass ptype = oldProperty.getActualType();
            oldProperty.setIsRequired(ptype.isPrimitive() || ptype.isArray() && ptype.getComponentType().isPrimitive());
        }
        if (xmlElement.isSetXmlList()) {
            if (!this.aProcessor.getHelper().isCollectionType(oldProperty.getType()) && !oldProperty.getType().isArray()) {
                throw JAXBException.invalidList(oldProperty.getPropertyName());
            }
            oldProperty.setIsXmlList(xmlElement.isXmlList());
        }
        if (xmlElement.getXmlMimeType() != null) {
            oldProperty.setMimeType(xmlElement.getXmlMimeType());
        }
        if (xmlElement.isXmlAttachmentRef()) {
            oldProperty.setIsSwaAttachmentRef(true);
            oldProperty.setSchemaType(Constants.SWA_REF_QNAME);
        } else if (this.aProcessor.isMtomAttachment(oldProperty)) {
            oldProperty.setIsMtomAttachment(true);
            oldProperty.setSchemaType(Constants.BASE_64_BINARY_QNAME);
        }
        if (xmlElement.getXmlSchemaType() != null) {
            oldProperty.setSchemaType(new QName(xmlElement.getXmlSchemaType().getNamespace(), xmlElement.getXmlSchemaType().getName()));
        }
        if (xmlElement.getXmlAccessMethods() != null) {
            oldProperty.setMethodProperty(true);
            oldProperty.setGetMethodName(xmlElement.getXmlAccessMethods().getGetMethod());
            oldProperty.setSetMethodName(xmlElement.getXmlAccessMethods().getSetMethod());
        }
        if (xmlElement.isSetReadOnly()) {
            oldProperty.setReadOnly(xmlElement.isReadOnly());
        }
        if (xmlElement.isSetWriteOnly()) {
            oldProperty.setWriteOnly(xmlElement.isWriteOnly());
        }
        if (xmlElement.isSetCdata()) {
            oldProperty.setCdata(xmlElement.isCdata());
        }
        if (xmlElement.getXmlAbstractNullPolicy() != null) {
            JAXBElement<? extends XmlAbstractNullPolicy> jaxbElt = xmlElement.getXmlAbstractNullPolicy();
            oldProperty.setNullPolicy((XmlAbstractNullPolicy)jaxbElt.getValue());
        }
        if (xmlElement.getXmlProperties() != null && xmlElement.getXmlProperties().getXmlProperty().size() > 0) {
            oldProperty.setUserProperties(this.createUserPropertyMap(xmlElement.getXmlProperties().getXmlProperty()));
        }
        return oldProperty;
    }

    private Property processXmlMap(XmlMap xmlMap, Property oldProperty) {
        XmlMap.Key mapKey = xmlMap.getKey();
        XmlMap.Value mapValue = xmlMap.getValue();
        if (mapKey != null && mapKey.getType() != null) {
            oldProperty.setKeyType(this.jModelInput.getJavaModel().getClass(mapKey.getType()));
        } else {
            oldProperty.setKeyType(this.jModelInput.getJavaModel().getClass(JAVA_LANG_OBJECT));
        }
        if (mapValue != null && mapValue.getType() != null) {
            oldProperty.setValueType(this.jModelInput.getJavaModel().getClass(mapValue.getType()));
        } else {
            oldProperty.setValueType(this.jModelInput.getJavaModel().getClass(JAVA_LANG_OBJECT));
        }
        return oldProperty;
    }

    private Property processXmlElements(XmlElements xmlElements, Property oldProperty, TypeInfo tInfo) {
        this.resetProperty(oldProperty, tInfo);
        oldProperty.setChoice(true);
        oldProperty.setXmlElements(xmlElements);
        oldProperty.setIsXmlIdRef(xmlElements.isXmlIdref());
        if (xmlElements.getXmlElementWrapper() != null) {
            oldProperty.setXmlElementWrapper(xmlElements.getXmlElementWrapper());
        }
        if (xmlElements.getXmlAccessMethods() != null) {
            oldProperty.setMethodProperty(true);
            oldProperty.setGetMethodName(xmlElements.getXmlAccessMethods().getGetMethod());
            oldProperty.setSetMethodName(xmlElements.getXmlAccessMethods().getSetMethod());
        }
        if (xmlElements.isSetReadOnly()) {
            oldProperty.setReadOnly(xmlElements.isReadOnly());
        }
        if (xmlElements.isSetWriteOnly()) {
            oldProperty.setWriteOnly(xmlElements.isWriteOnly());
        }
        if (xmlElements.getXmlProperties() != null && xmlElements.getXmlProperties().getXmlProperty().size() > 0) {
            oldProperty.setUserProperties(this.createUserPropertyMap(xmlElements.getXmlProperties().getXmlProperty()));
        }
        if (!xmlElements.getContainerType().equals(DEFAULT)) {
            this.setContainerType(oldProperty, xmlElements.getContainerType());
        }
        if (xmlElements.hasXmlJoinNodes()) {
            oldProperty.setXmlJoinNodesList(xmlElements.getXmlJoinNodes());
        }
        if (xmlElements.getXmlJavaTypeAdapter() != null) {
            try {
                oldProperty.setXmlJavaTypeAdapter(xmlElements.getXmlJavaTypeAdapter());
            }
            catch (JAXBException e) {
                throw JAXBException.invalidPropertyAdapterClass(xmlElements.getXmlJavaTypeAdapter().getValue(), xmlElements.getJavaAttribute(), tInfo.getJavaClassName());
            }
        }
        return oldProperty;
    }

    private Property processXmlElementRef(XmlElementRef xmlElementRef, Property oldProperty, TypeInfo info) {
        this.processObjectFactory(info);
        this.resetProperty(oldProperty, info);
        ArrayList<XmlElementRef> eltRefs = new ArrayList<XmlElementRef>();
        eltRefs.add(xmlElementRef);
        oldProperty.setXmlElementRefs(eltRefs);
        oldProperty.setIsReference(true);
        oldProperty.setIsRequired(xmlElementRef.isRequired());
        if (xmlElementRef.getXmlJavaTypeAdapter() != null) {
            oldProperty.setXmlJavaTypeAdapter(xmlElementRef.getXmlJavaTypeAdapter());
        }
        if (!xmlElementRef.getContainerType().equals(DEFAULT)) {
            this.setContainerType(oldProperty, xmlElementRef.getContainerType());
        }
        if (xmlElementRef.getXmlElementWrapper() != null) {
            oldProperty.setXmlElementWrapper(xmlElementRef.getXmlElementWrapper());
        }
        if (xmlElementRef.getXmlProperties() != null && xmlElementRef.getXmlProperties().getXmlProperty().size() > 0) {
            oldProperty.setUserProperties(this.createUserPropertyMap(xmlElementRef.getXmlProperties().getXmlProperty()));
        }
        if (xmlElementRef.isSetXmlMixed()) {
            oldProperty.setMixedContent(xmlElementRef.isXmlMixed());
        }
        if (xmlElementRef.getXmlAccessMethods() != null) {
            oldProperty.setMethodProperty(true);
            oldProperty.setGetMethodName(xmlElementRef.getXmlAccessMethods().getGetMethod());
            oldProperty.setSetMethodName(xmlElementRef.getXmlAccessMethods().getSetMethod());
        }
        if (xmlElementRef.isSetReadOnly()) {
            oldProperty.setReadOnly(xmlElementRef.isReadOnly());
        }
        if (xmlElementRef.isSetWriteOnly()) {
            oldProperty.setWriteOnly(xmlElementRef.isWriteOnly());
        }
        return oldProperty;
    }

    private Property processXmlElementRefs(XmlElementRefs xmlElementRefs, Property oldProperty, TypeInfo info) {
        this.processObjectFactory(info);
        this.resetProperty(oldProperty, info);
        ArrayList<XmlElementRef> eltRefs = new ArrayList<XmlElementRef>();
        boolean required = true;
        for (XmlElementRef eltRef : xmlElementRefs.getXmlElementRef()) {
            eltRefs.add(eltRef);
            required = required && eltRef.isRequired();
        }
        oldProperty.setXmlElementRefs(eltRefs);
        oldProperty.setIsReference(true);
        oldProperty.setIsRequired(required);
        if (xmlElementRefs.getXmlJavaTypeAdapter() != null) {
            oldProperty.setXmlJavaTypeAdapter(xmlElementRefs.getXmlJavaTypeAdapter());
        }
        if (xmlElementRefs.getXmlElementWrapper() != null) {
            oldProperty.setXmlElementWrapper(xmlElementRefs.getXmlElementWrapper());
        }
        if (xmlElementRefs.getXmlProperties() != null && xmlElementRefs.getXmlProperties().getXmlProperty().size() > 0) {
            oldProperty.setUserProperties(this.createUserPropertyMap(xmlElementRefs.getXmlProperties().getXmlProperty()));
        }
        if (xmlElementRefs.isSetXmlMixed()) {
            oldProperty.setMixedContent(xmlElementRefs.isXmlMixed());
        }
        if (xmlElementRefs.getXmlAccessMethods() != null) {
            oldProperty.setMethodProperty(true);
            oldProperty.setGetMethodName(xmlElementRefs.getXmlAccessMethods().getGetMethod());
            oldProperty.setSetMethodName(xmlElementRefs.getXmlAccessMethods().getSetMethod());
        }
        if (xmlElementRefs.isSetReadOnly()) {
            oldProperty.setReadOnly(xmlElementRefs.isReadOnly());
        }
        if (xmlElementRefs.isSetWriteOnly()) {
            oldProperty.setWriteOnly(xmlElementRefs.isWriteOnly());
        }
        return oldProperty;
    }

    private Property processXmlTransient(XmlTransient xmlTransient, Property oldProperty) {
        if (xmlTransient.isXmlLocation()) {
            if (!this.aProcessor.getHelper().getJavaClass(Constants.LOCATOR_CLASS).isAssignableFrom(oldProperty.getType())) {
                throw JAXBException.invalidXmlLocation(oldProperty.getPropertyName(), oldProperty.getType().getName());
            }
            oldProperty.setXmlLocation(true);
        }
        oldProperty.setTransient(true);
        return oldProperty;
    }

    private Property processXmlValue(XmlValue xmlValue, Property oldProperty, TypeInfo info, JavaType javaType) {
        this.resetProperty(oldProperty, info);
        oldProperty.setIsXmlValue(true);
        oldProperty.setIsXmlValueExtension(true);
        info.setXmlValueProperty(oldProperty);
        if (xmlValue.getXmlAccessMethods() != null) {
            oldProperty.setMethodProperty(true);
            oldProperty.setGetMethodName(xmlValue.getXmlAccessMethods().getGetMethod());
            oldProperty.setSetMethodName(xmlValue.getXmlAccessMethods().getSetMethod());
        }
        if (!xmlValue.getContainerType().equals(DEFAULT)) {
            this.setContainerType(oldProperty, xmlValue.getContainerType());
        }
        if (!xmlValue.getType().equals(DEFAULT)) {
            JavaClass pType = this.jModelInput.getJavaModel().getClass(xmlValue.getType());
            if (this.aProcessor.getHelper().isCollectionType(oldProperty.getType())) {
                oldProperty.setGenericType(pType);
            } else {
                oldProperty.setType(pType);
            }
            oldProperty.setHasXmlElementType(true);
            if (this.aProcessor.shouldGenerateTypeInfo(pType) && this.aProcessor.getTypeInfos().get(pType.getQualifiedName()) == null) {
                this.aProcessor.buildNewTypeInfo(new JavaClass[]{pType});
            }
        }
        this.reapplyPackageAndClassAdapters(oldProperty, info);
        if (xmlValue.getXmlJavaTypeAdapter() != null) {
            try {
                oldProperty.setXmlJavaTypeAdapter(xmlValue.getXmlJavaTypeAdapter());
            }
            catch (JAXBException e) {
                throw JAXBException.invalidPropertyAdapterClass(xmlValue.getXmlJavaTypeAdapter().getValue(), xmlValue.getJavaAttribute(), javaType.getName());
            }
        }
        if (xmlValue.isSetReadOnly()) {
            oldProperty.setReadOnly(xmlValue.isReadOnly());
        }
        if (xmlValue.isSetWriteOnly()) {
            oldProperty.setWriteOnly(xmlValue.isWriteOnly());
        }
        if (xmlValue.isSetCdata()) {
            oldProperty.setCdata(xmlValue.isCdata());
        }
        if (xmlValue.getXmlAbstractNullPolicy() != null) {
            JAXBElement<? extends XmlAbstractNullPolicy> jaxbElt = xmlValue.getXmlAbstractNullPolicy();
            oldProperty.setNullPolicy((XmlAbstractNullPolicy)jaxbElt.getValue());
        }
        if (xmlValue.getXmlProperties() != null && xmlValue.getXmlProperties().getXmlProperty().size() > 0) {
            oldProperty.setUserProperties(this.createUserPropertyMap(xmlValue.getXmlProperties().getXmlProperty()));
        }
        return oldProperty;
    }

    private NamespaceInfo processXmlSchema(XmlBindings xmlBindings, String packageName) {
        XmlSchema schema = xmlBindings.getXmlSchema();
        if (schema == null) {
            return null;
        }
        NamespaceInfo nsInfo = this.aProcessor.findInfoForNamespace(schema.getNamespace());
        if (nsInfo == null) {
            nsInfo = new NamespaceInfo();
        }
        XmlNsForm form = schema.getAttributeFormDefault();
        nsInfo.setAttributeFormQualified(form.equals((Object)XmlNsForm.QUALIFIED));
        form = schema.getElementFormDefault();
        nsInfo.setElementFormQualified(form.equals((Object)XmlNsForm.QUALIFIED));
        if (!nsInfo.isElementFormQualified() || nsInfo.isAttributeFormQualified()) {
            this.aProcessor.setDefaultNamespaceAllowed(false);
        }
        nsInfo.setLocation(schema.getLocation() == null ? GENERATE : schema.getLocation());
        String namespace = schema.getNamespace();
        if (namespace == null) {
            namespace = this.aProcessor.getDefaultTargetNamespace();
        }
        nsInfo.setNamespace(namespace == null ? "" : schema.getNamespace());
        NamespaceResolver nsr = new NamespaceResolver();
        for (XmlSchema.XmlNs xmlns : schema.getXmlNs()) {
            nsr.put(xmlns.getPrefix(), xmlns.getNamespaceUri());
        }
        nsInfo.setNamespaceResolver(nsr);
        return nsInfo;
    }

    private Property processXmlTransformation(XmlTransformation xmlTransformation, Property oldProperty, TypeInfo tInfo) {
        this.resetProperty(oldProperty, tInfo);
        oldProperty.setIsXmlTransformation(true);
        oldProperty.setXmlTransformation(xmlTransformation);
        if (xmlTransformation.getXmlAccessMethods() != null) {
            oldProperty.setMethodProperty(true);
            oldProperty.setGetMethodName(xmlTransformation.getXmlAccessMethods().getGetMethod());
            oldProperty.setSetMethodName(xmlTransformation.getXmlAccessMethods().getSetMethod());
        }
        if (xmlTransformation.getXmlProperties() != null && xmlTransformation.getXmlProperties().getXmlProperty().size() > 0) {
            oldProperty.setUserProperties(this.createUserPropertyMap(xmlTransformation.getXmlProperties().getXmlProperty()));
        }
        this.aProcessor.getReferencedByTransformer().add(oldProperty.getType().getName());
        return oldProperty;
    }

    private Property processXmlJoinNodes(XmlJoinNodes xmlJoinNodes, Property oldProperty, TypeInfo typeInfo) {
        this.resetProperty(oldProperty, typeInfo);
        oldProperty.setXmlJoinNodes(xmlJoinNodes);
        if (!xmlJoinNodes.getContainerType().equals(DEFAULT)) {
            this.setContainerType(oldProperty, xmlJoinNodes.getContainerType());
        }
        if (!xmlJoinNodes.getType().equals(DEFAULT)) {
            JavaClass pType = this.jModelInput.getJavaModel().getClass(xmlJoinNodes.getType());
            if (this.aProcessor.getHelper().isCollectionType(oldProperty.getType())) {
                oldProperty.setGenericType(pType);
            } else {
                oldProperty.setType(pType);
            }
            oldProperty.setHasXmlElementType(true);
            if (this.aProcessor.shouldGenerateTypeInfo(pType) && this.aProcessor.getTypeInfos().get(pType.getQualifiedName()) == null) {
                this.aProcessor.buildNewTypeInfo(new JavaClass[]{pType});
            }
        }
        return oldProperty;
    }

    private Map<String, ArrayList<JavaClass>> buildPackageToJavaClassMap() {
        HashMap<String, ArrayList<JavaClass>> theMap = new HashMap<String, ArrayList<JavaClass>>();
        HashMap xmlBindingsMap = new HashMap();
        for (String packageName : this.xmlBindingMap.keySet()) {
            XmlBindings.XmlEnums xmlEnums;
            XmlBindings xmlBindings = this.xmlBindingMap.get(packageName);
            ArrayList classes = new ArrayList();
            XmlBindings.JavaTypes jTypes = xmlBindings.getJavaTypes();
            if (jTypes != null) {
                for (JavaType javaType : jTypes.getJavaType()) {
                    this.addClassToList(classes, javaType.getName(), packageName);
                }
            }
            if ((xmlEnums = xmlBindings.getXmlEnums()) != null) {
                for (XmlEnum xmlEnum : xmlEnums.getXmlEnum()) {
                    this.addClassToList(classes, xmlEnum.getJavaEnum(), packageName);
                }
            }
            theMap.put(packageName, classes);
            xmlBindingsMap.put(packageName, new ArrayList(classes));
        }
        for (JavaClass jClass : this.jModelInput.getJavaClasses()) {
            String pkg = jClass.getPackageName();
            ArrayList arrayList = (ArrayList)xmlBindingsMap.get(pkg);
            ArrayList allExistingClasses = (ArrayList)theMap.get(pkg);
            if (arrayList != null) {
                if (this.classExistsInArray(jClass, arrayList)) continue;
                allExistingClasses.add(jClass);
                continue;
            }
            if (allExistingClasses != null) {
                allExistingClasses.add(jClass);
                continue;
            }
            ArrayList<JavaClass> classes = new ArrayList<JavaClass>();
            classes.add(jClass);
            theMap.put(pkg, classes);
        }
        return theMap;
    }

    private void addClassToList(List classes, String name, String packageName) {
        JavaClass nextClass = this.jModelInput.getJavaModel().getClass(Helper.getQualifiedJavaTypeName(name, packageName));
        String nextPackageName = nextClass.getPackageName();
        if (nextPackageName == null || !nextPackageName.equals(packageName)) {
            throw JAXBException.javaTypeNotAllowedInBindingsFile(nextPackageName, packageName);
        }
        classes.add(nextClass);
    }

    private JAXBMetadataLogger getLogger() {
        if (this.logger == null) {
            this.logger = new JAXBMetadataLogger();
        }
        return this.logger;
    }

    public boolean classExistsInArray(JavaClass theClass, ArrayList<JavaClass> existingClasses) {
        return this.aProcessor.getHelper().classExistsInArray(theClass, existingClasses);
    }

    private Property resetProperty(Property oldProperty, TypeInfo tInfo) {
        oldProperty.setIsAttribute(false);
        oldProperty.setHasXmlElementType(false);
        oldProperty.setIsRequired(false);
        oldProperty.setIsXmlList(false);
        oldProperty.setXmlJavaTypeAdapter(null);
        oldProperty.setInverseReferencePropertyName(null);
        oldProperty.setDefaultValue(null);
        oldProperty.setDomHandlerClassName(null);
        oldProperty.setIsSwaAttachmentRef(false);
        oldProperty.setIsXmlIdRef(false);
        oldProperty.setIsXmlTransformation(false);
        oldProperty.setXmlElementWrapper(null);
        oldProperty.setLax(false);
        oldProperty.setNillable(false);
        oldProperty.setMixedContent(false);
        oldProperty.setMimeType(null);
        oldProperty.setTransient(false);
        oldProperty.setChoice(false);
        oldProperty.setIsReference(false);
        oldProperty.setXmlPath(null);
        oldProperty.setReadOnly(false);
        oldProperty.setWriteOnly(false);
        oldProperty.setCdata(false);
        oldProperty.setNullPolicy(null);
        oldProperty.setUserProperties(null);
        oldProperty.setGetMethodName(oldProperty.getOriginalGetMethodName());
        oldProperty.setSetMethodName(oldProperty.getOriginalSetMethodName());
        oldProperty.setXmlTransformation(null);
        oldProperty.setXmlJoinNodes(null);
        if (oldProperty.getGetMethodName() == null && oldProperty.getSetMethodName() == null) {
            oldProperty.setMethodProperty(false);
        }
        oldProperty.setIsSwaAttachmentRef(false);
        oldProperty.setIsMtomAttachment(false);
        oldProperty.setSchemaType(null);
        this.unsetXmlElementRefs(oldProperty, tInfo);
        this.unsetXmlElements(oldProperty);
        this.unsetXmlAnyAttribute(oldProperty, tInfo);
        this.unsetXmlAnyElement(oldProperty, tInfo);
        this.unsetXmlValue(oldProperty, tInfo);
        this.unsetXmlID(oldProperty, tInfo);
        this.unsetXmlKey(oldProperty, tInfo);
        return oldProperty;
    }

    private void unsetXmlID(Property oldProperty, TypeInfo tInfo) {
        oldProperty.setIsXmlId(false);
        oldProperty.setIsXmlIdExtension(false);
        if (tInfo.isIDSet() && tInfo.getIDProperty().getPropertyName().equals(oldProperty.getPropertyName())) {
            tInfo.setIDProperty(null);
        }
    }

    private void unsetXmlKey(Property oldProperty, TypeInfo tInfo) {
        if (tInfo.hasXmlKeyProperties()) {
            Property propToRemove = null;
            for (Property prop : tInfo.getXmlKeyProperties()) {
                if (!prop.getPropertyName().equals(oldProperty.getPropertyName())) continue;
                propToRemove = prop;
            }
            if (propToRemove != null) {
                tInfo.getXmlKeyProperties().remove(propToRemove);
            }
        }
    }

    private void unsetXmlElementRefs(Property oldProperty, TypeInfo tInfo) {
        if (tInfo.hasElementRefs() && tInfo.getElementRefsPropName().equals(oldProperty.getPropertyName())) {
            tInfo.setElementRefsPropertyName(null);
        }
    }

    private void unsetXmlElements(Property oldProperty) {
        oldProperty.setXmlElements(null);
        oldProperty.setChoiceProperties(null);
    }

    private void unsetXmlAnyAttribute(Property oldProperty, TypeInfo tInfo) {
        oldProperty.setIsAnyAttribute(false);
        if (tInfo.isSetAnyAttributePropertyName() && tInfo.getAnyAttributePropertyName().equals(oldProperty.getPropertyName())) {
            tInfo.setAnyAttributePropertyName(null);
        }
    }

    private void unsetXmlAnyElement(Property oldProperty, TypeInfo tInfo) {
        oldProperty.setIsAny(false);
        if (tInfo.isSetAnyElementPropertyName() && tInfo.getAnyElementPropertyName().equals(oldProperty.getPropertyName())) {
            tInfo.setAnyElementPropertyName(null);
        }
    }

    private void unsetXmlValue(Property oldProperty, TypeInfo tInfo) {
        oldProperty.setIsXmlValue(false);
        oldProperty.setIsXmlValueExtension(false);
        if (tInfo.isSetXmlValueProperty() && tInfo.getXmlValueProperty().getPropertyName().equals(oldProperty.getPropertyName())) {
            tInfo.setXmlValueProperty(null);
        }
    }

    public static String getNameFromXPath(String xpath, String propertyName, boolean isAttribute) {
        String name;
        if (xpath.equals(SELF)) {
            return propertyName;
        }
        int idx = xpath.indexOf("/text()");
        String path = idx >= 0 ? xpath.substring(0, idx) : xpath;
        idx = path.lastIndexOf(47);
        if (idx >= 0 && path.length() > 1) {
            name = path.substring(idx + 1);
            StringTokenizer stok = new StringTokenizer(name, Character.toString(':'));
            if (stok.countTokens() == 2) {
                stok.nextToken();
                name = stok.nextToken();
            }
        } else {
            name = path;
        }
        if (isAttribute) {
            idx = name.indexOf(Constants.ATTRIBUTE.charValue());
            if (idx >= 0 && name.length() > 1) {
                name = name.substring(idx + 1);
            }
        } else {
            idx = name.indexOf(91);
            if (idx != -1) {
                name = name.substring(0, idx);
            }
        }
        return name;
    }

    private void processObjectFactory(TypeInfo tInfo) {
        int index = tInfo.getJavaClassName().lastIndexOf(46);
        if (index > -1) {
            String objectFactoryClassName = tInfo.getJavaClassName().substring(0, index) + ".ObjectFactory";
            this.aProcessor.findAndProcessObjectFactory(objectFactoryClassName);
        } else {
            this.aProcessor.findAndProcessObjectFactory("ObjectFactory");
        }
    }

    private Map createUserPropertyMap(List<XmlProperties.XmlProperty> propList) {
        return this.mergeUserPropertyMap(propList, new HashMap());
    }

    private Map mergeUserPropertyMap(List<XmlProperties.XmlProperty> propList, Map existingMap) {
        Map propMap = existingMap;
        for (XmlProperties.XmlProperty prop : propList) {
            Object pvalue = prop.getValue();
            if (prop.isSetValueType()) {
                pvalue = XMLConversionManager.getDefaultXMLManager().convertObject(prop.getValue(), XMLConversionManager.getDefaultXMLManager().convertClassNameToClass(prop.getValueType()));
            }
            propMap.put(prop.getName(), pvalue);
        }
        return propMap;
    }

    private void setContainerType(Property property, String containerClassName) {
        JavaClass genericType = property.getGenericType();
        property.setType(this.jModelInput.getJavaModel().getClass(containerClassName));
        property.setGenericType(genericType);
    }

    public void reapplyPackageAndClassAdapters(Property prop, TypeInfo owningInfo) {
        JavaClass packageLevelAdapter;
        if (prop.getXmlJavaTypeAdapter() != null) {
            return;
        }
        JavaClass type = prop.getActualType();
        TypeInfo targetInfo = this.aProcessor.getTypeInfos().get(type.getQualifiedName());
        if (targetInfo != null && targetInfo.getXmlJavaTypeAdapter() != null) {
            prop.setXmlJavaTypeAdapter(targetInfo.getXmlJavaTypeAdapter());
        }
        if (owningInfo.hasPackageLevelAdaptersByClass() && (packageLevelAdapter = owningInfo.getPackageLevelAdaptersByClass().get(type.getQualifiedName())) != null && prop.getXmlJavaTypeAdapter() == null) {
            XmlJavaTypeAdapter xja = new XmlJavaTypeAdapter();
            xja.setValue(packageLevelAdapter.getQualifiedName());
            xja.setType(type.getQualifiedName());
            prop.setXmlJavaTypeAdapter(xja);
        }
    }

    public static XmlBindings mergeXmlBindings(List<XmlBindings> bindings) {
        if (bindings.size() == 0) {
            return null;
        }
        XmlBindings rootBindings = bindings.get(0);
        for (int i = 1; i < bindings.size(); ++i) {
            XmlBindings nextBindings = bindings.get(i);
            if (nextBindings.isSetXmlAccessorOrder()) {
                rootBindings.setXmlAccessorOrder(nextBindings.getXmlAccessorOrder());
            }
            if (nextBindings.isSetXmlAccessorType()) {
                rootBindings.setXmlAccessorType(nextBindings.getXmlAccessorType());
            }
            if (nextBindings.isSetXmlMappingMetadataComplete()) {
                rootBindings.setXmlMappingMetadataComplete(nextBindings.isXmlMappingMetadataComplete());
            }
            XMLProcessor.mergeJavaTypes(rootBindings.getJavaTypes(), nextBindings.getJavaTypes());
            if (rootBindings.getXmlEnums() == null) {
                rootBindings.setXmlEnums(nextBindings.getXmlEnums());
            } else {
                XMLProcessor.mergeXmlEnums(rootBindings.getXmlEnums(), nextBindings.getXmlEnums());
            }
            if (rootBindings.getXmlSchema() == null) {
                rootBindings.setXmlSchema(nextBindings.getXmlSchema());
            } else if (nextBindings.getXmlSchema() != null) {
                XMLProcessor.mergeXmlSchema(rootBindings.getXmlSchema(), nextBindings.getXmlSchema());
            }
            if (rootBindings.getXmlSchemaType() == null) {
                rootBindings.setXmlSchemaTypes(nextBindings.getXmlSchemaTypes());
            } else if (nextBindings.getXmlSchemaTypes() != null) {
                XMLProcessor.mergeXmlSchemaTypes(rootBindings.getXmlSchemaTypes(), nextBindings.getXmlSchemaTypes());
            }
            if (rootBindings.getXmlJavaTypeAdapters() == null) {
                rootBindings.setXmlJavaTypeAdapters(nextBindings.getXmlJavaTypeAdapters());
            } else if (nextBindings.getXmlJavaTypeAdapters() != null) {
                XMLProcessor.mergeXmlJavaTypeAdapters(rootBindings.getXmlJavaTypeAdapters(), nextBindings.getXmlJavaTypeAdapters());
            }
            if (rootBindings.getXmlNullPolicy() == null) {
                rootBindings.setXmlNullPolicy(nextBindings.getXmlNullPolicy());
            } else if (nextBindings.getXmlNullPolicy() != null) {
                XMLProcessor.mergeXmlNullPolicy(rootBindings.getXmlNullPolicy(), nextBindings.getXmlNullPolicy());
            }
            if (rootBindings.getXmlElementNillable() == null) {
                rootBindings.setXmlElementNillable(nextBindings.getXmlElementNillable());
                continue;
            }
            if (nextBindings.getXmlElementNillable() == null) continue;
            XMLProcessor.mergeXmlElementNillable(rootBindings.getXmlElementNillable(), nextBindings.getXmlElementNillable());
        }
        return rootBindings;
    }

    private static void mergeXmlElementNillable(XmlElementNillable xmlElementNillable, XmlElementNillable overrideXmlElementNillable) {
        xmlElementNillable.setNillable(overrideXmlElementNillable.isNillable());
    }

    private static void mergeXmlNullPolicy(XmlNullPolicy xmlNullPolicy, XmlNullPolicy overrideXmlNullPolicy) {
        xmlNullPolicy.setEmptyNodeRepresentsNull(overrideXmlNullPolicy.isEmptyNodeRepresentsNull());
        xmlNullPolicy.setIsSetPerformedForAbsentNode(overrideXmlNullPolicy.isIsSetPerformedForAbsentNode());
        xmlNullPolicy.setNullRepresentationForXml(overrideXmlNullPolicy.getNullRepresentationForXml());
        xmlNullPolicy.setXsiNilRepresentsNull(overrideXmlNullPolicy.isXsiNilRepresentsNull());
    }

    private static void mergeXmlJavaTypeAdapters(XmlJavaTypeAdapters xmlJavaTypeAdapters, XmlJavaTypeAdapters overrideAdapters) {
        List<XmlJavaTypeAdapter> adapterList = xmlJavaTypeAdapters.getXmlJavaTypeAdapter();
        HashMap<String, XmlJavaTypeAdapter> adapterMap = new HashMap<String, XmlJavaTypeAdapter>(adapterList.size());
        for (XmlJavaTypeAdapter next : adapterList) {
            adapterMap.put(next.getType(), next);
        }
        for (XmlJavaTypeAdapter next : overrideAdapters.getXmlJavaTypeAdapter()) {
            XmlJavaTypeAdapter existingAdapter = (XmlJavaTypeAdapter)adapterMap.get(next.getType());
            if (existingAdapter != null) {
                existingAdapter.setValue(next.getValue());
                continue;
            }
            xmlJavaTypeAdapters.getXmlJavaTypeAdapter().add(next);
        }
    }

    private static void mergeXmlSchemaTypes(XmlSchemaTypes xmlSchemaTypes, XmlSchemaTypes overrideSchemaTypes) {
        List<XmlSchemaType> schemaTypeList = xmlSchemaTypes.getXmlSchemaType();
        HashMap<String, XmlSchemaType> schemaTypeMap = new HashMap<String, XmlSchemaType>(schemaTypeList.size());
        for (XmlSchemaType next : schemaTypeList) {
            schemaTypeMap.put(next.getType(), next);
        }
        for (XmlSchemaType next : overrideSchemaTypes.getXmlSchemaType()) {
            XmlSchemaType existingType = (XmlSchemaType)schemaTypeMap.get(next.getType());
            if (existingType != null) {
                existingType.setName(next.getName());
                existingType.setNamespace(next.getNamespace());
                continue;
            }
            xmlSchemaTypes.getXmlSchemaType().add(next);
        }
    }

    private static void mergeXmlSchema(XmlSchema xmlSchema, XmlSchema overrideSchema) {
        xmlSchema.setAttributeFormDefault(overrideSchema.getAttributeFormDefault());
        xmlSchema.setElementFormDefault(overrideSchema.getElementFormDefault());
        xmlSchema.setLocation(overrideSchema.getLocation());
        xmlSchema.setNamespace(overrideSchema.getNamespace());
        List<XmlSchema.XmlNs> xmlNsList = xmlSchema.getXmlNs();
        xmlNsList.addAll(overrideSchema.getXmlNs());
    }

    private static void mergeXmlEnums(XmlBindings.XmlEnums xmlEnums, XmlBindings.XmlEnums overrideEnum) {
        if (overrideEnum == null) {
            return;
        }
        List<XmlEnum> enumList = xmlEnums.getXmlEnum();
        HashMap<String, XmlEnum> enumMap = new HashMap<String, XmlEnum>(enumList.size());
        for (XmlEnum next : enumList) {
            enumMap.put(next.getJavaEnum(), next);
        }
        for (XmlEnum next : overrideEnum.getXmlEnum()) {
            XmlEnum existingEnum = (XmlEnum)enumMap.get(next.getJavaEnum());
            if (existingEnum != null) {
                XMLProcessor.mergeXmlEnumValues(existingEnum.getXmlEnumValue(), next.getXmlEnumValue());
                continue;
            }
            xmlEnums.getXmlEnum().add(next);
        }
    }

    private static void mergeXmlEnumValues(List<XmlEnumValue> xmlEnumValue, List<XmlEnumValue> overrideXmlEnumValue) {
        HashMap<String, XmlEnumValue> values = new HashMap<String, XmlEnumValue>();
        ArrayList<XmlEnumValue> extraValues = new ArrayList<XmlEnumValue>();
        for (XmlEnumValue next : xmlEnumValue) {
            values.put(next.getJavaEnumValue(), next);
        }
        for (XmlEnumValue next : overrideXmlEnumValue) {
            XmlEnumValue existingValue = (XmlEnumValue)values.get(next.getJavaEnumValue());
            if (existingValue == null) {
                extraValues.add(next);
                continue;
            }
            existingValue.setValue(next.getValue());
        }
        xmlEnumValue.addAll(extraValues);
    }

    private static void mergeJavaTypes(XmlBindings.JavaTypes javaTypes, XmlBindings.JavaTypes overrideJavaTypes) {
        List<JavaType> javaTypeList = javaTypes.getJavaType();
        HashMap<String, JavaType> javaTypeMap = new HashMap<String, JavaType>(javaTypeList.size());
        for (JavaType next : javaTypeList) {
            javaTypeMap.put(next.getName(), next);
        }
        for (JavaType next : overrideJavaTypes.getJavaType()) {
            JavaType existingType = (JavaType)javaTypeMap.get(next.getName());
            if (existingType == null) {
                javaTypes.getJavaType().add(next);
                continue;
            }
            XMLProcessor.mergeJavaType(existingType, next);
        }
    }

    private static void mergeJavaType(JavaType existingType, JavaType next) {
        if (next.isSetXmlAccessorOrder()) {
            existingType.setXmlAccessorOrder(next.getXmlAccessorOrder());
        }
        if (next.isSetXmlAccessorType()) {
            existingType.setXmlAccessorType(next.getXmlAccessorType());
        }
        if (next.isSetXmlInlineBinaryData()) {
            existingType.setXmlInlineBinaryData(next.isXmlInlineBinaryData());
        }
        if (next.isSetXmlTransient()) {
            existingType.setXmlTransient(next.isXmlInlineBinaryData());
        }
        if (next.getXmlRootElement() != null) {
            existingType.setXmlRootElement(next.getXmlRootElement());
        }
        if (existingType.getXmlProperties() == null) {
            existingType.setXmlProperties(next.getXmlProperties());
        } else if (next.getXmlProperties() != null) {
            existingType.getXmlProperties().getXmlProperty().addAll(next.getXmlProperties().getXmlProperty());
        }
        if (next.getXmlType() != null) {
            existingType.setXmlType(next.getXmlType());
        }
        existingType.getXmlSeeAlso().addAll(next.getXmlSeeAlso());
        JavaType.JavaAttributes attributes = existingType.getJavaAttributes();
        JavaType.JavaAttributes overrideAttributes = next.getJavaAttributes();
        if (attributes == null) {
            existingType.setJavaAttributes(overrideAttributes);
        } else if (overrideAttributes != null) {
            XMLProcessor.mergeJavaAttributes(attributes, overrideAttributes, existingType);
        }
    }

    private static void mergeJavaAttributes(JavaType.JavaAttributes attributes, JavaType.JavaAttributes overrideAttributes, JavaType javaType) {
        List<JAXBElement<? extends JavaAttribute>> attributeList = attributes.getJavaAttribute();
        HashMap<String, JAXBElement<? extends JavaAttribute>> attributeMap = new HashMap<String, JAXBElement<? extends JavaAttribute>>(attributeList.size());
        for (JAXBElement<? extends JavaAttribute> next : attributeList) {
            attributeMap.put(((JavaAttribute)next.getValue()).getJavaAttribute(), next);
        }
        for (JAXBElement<? extends JavaAttribute> next : overrideAttributes.getJavaAttribute()) {
            JAXBElement existingAttribute = (JAXBElement)attributeMap.get(((JavaAttribute)next.getValue()).getJavaAttribute());
            if (existingAttribute != null) {
                attributes.getJavaAttribute().remove(existingAttribute);
            }
            attributes.getJavaAttribute().add(next);
        }
    }
}

