/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.AuthenticationMechanism;
import com.mongodb.MongoCommandException;
import com.mongodb.MongoCredential;
import com.mongodb.MongoSecurityException;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.connection.Authenticator;
import com.mongodb.connection.CommandHelper;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.InternalConnection;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;

class X509Authenticator
extends Authenticator {
    X509Authenticator(MongoCredential credential) {
        super(credential);
    }

    @Override
    void authenticate(InternalConnection connection, ConnectionDescription connectionDescription) {
        try {
            BsonDocument authCommand = this.getAuthCommand(this.getCredential().getUserName());
            CommandHelper.executeCommand(this.getCredential().getSource(), authCommand, connection);
        }
        catch (MongoCommandException e) {
            throw new MongoSecurityException(this.getCredential(), "Exception authenticating", (Throwable)e);
        }
    }

    @Override
    void authenticateAsync(InternalConnection connection, ConnectionDescription connectionDescription, final SingleResultCallback<Void> callback) {
        CommandHelper.executeCommandAsync(this.getCredential().getSource(), this.getAuthCommand(this.getCredential().getUserName()), connection, new SingleResultCallback<BsonDocument>(){

            @Override
            public void onResult(BsonDocument nonceResult, Throwable t) {
                if (t != null) {
                    callback.onResult(null, X509Authenticator.this.translateThrowable(t));
                } else {
                    callback.onResult(null, null);
                }
            }
        });
    }

    private BsonDocument getAuthCommand(String userName) {
        BsonDocument cmd = new BsonDocument();
        cmd.put("authenticate", new BsonInt32(1));
        cmd.put("user", new BsonString(userName));
        cmd.put("mechanism", new BsonString(AuthenticationMechanism.MONGODB_X509.getMechanismName()));
        return cmd;
    }

    private Throwable translateThrowable(Throwable t) {
        if (t instanceof MongoCommandException) {
            return new MongoSecurityException(this.getCredential(), "Exception authenticating", t);
        }
        return t;
    }
}

