/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.DBObject;
import com.mongodb.bulk.UpdateRequest;
import com.mongodb.bulk.WriteRequest;
import org.bson.BsonDocumentWrapper;
import org.bson.codecs.Encoder;

class ReplaceRequest
extends com.mongodb.WriteRequest {
    private final DBObject query;
    private final DBObject document;
    private final boolean upsert;
    private final Encoder<DBObject> codec;
    private final Encoder<DBObject> replacementCodec;

    public ReplaceRequest(DBObject query, DBObject document, boolean upsert, Encoder<DBObject> codec, Encoder<DBObject> replacementCodec) {
        this.query = query;
        this.document = document;
        this.upsert = upsert;
        this.codec = codec;
        this.replacementCodec = replacementCodec;
    }

    public DBObject getQuery() {
        return this.query;
    }

    public DBObject getDocument() {
        return this.document;
    }

    public boolean isUpsert() {
        return this.upsert;
    }

    @Override
    WriteRequest toNew() {
        return new UpdateRequest(new BsonDocumentWrapper<DBObject>(this.query, this.codec), new BsonDocumentWrapper<DBObject>(this.document, this.replacementCodec), WriteRequest.Type.REPLACE).upsert(this.isUpsert());
    }
}

