/*******************************************************************************
 * Copyright (c) 2012, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.transformer;

/**
 * Convenience transformer that returns <code>null</code> if the original
 * object is <code>null</code>; otherwise it calls {@link #transform_(Object)},
 * which is to be implemented by subclasses.
 *
 * @param <T1> the type of the object passed to the transformer
 * @param <T2> the type of the object returned by the transformer
 *
 * @see TransformerAdapter
 */
public abstract class AbstractTransformer<T1, T2>
	extends TransformerAdapter<T1, T2>
{
	@Override
	public final T2 transform(T1 o) {
		return (o == null) ? null : this.transform_(o);
	}

	/**
	 * Transform the specified object; its value is guaranteed to be not
	 * <code>null</code>.
	 */
	protected abstract T2 transform_(T1 o);
}