/*******************************************************************************
 * Copyright (c) 2011, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.collection;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.tools.utility.iterator.NullElementIterator;
import org.eclipse.persistence.tools.utility.iterator.NullElementListIterator;

/**
 * A <em>read-only</em> "null element" list.
 */
public class NullElementList<E>
	extends AbstractRepeatingElementList<E>
{
	/**
	 * Construct a <em>read-only</em> list with the specified number of
	 * <code>null</code>s in it.
	 */
	public NullElementList(int size) {
		super(size);
	}

	@Override
	protected Iterator<E> iterator(int iteratorSize) {
		return new NullElementIterator<E>(iteratorSize);
	}

	@Override
	protected ListIterator<E> listIterator_(int iteratorSize) {
		return new NullElementListIterator<E>(iteratorSize);
	}

	@Override
	protected List<E> subList(int subListSize) {
		return new NullElementList<E>(subListSize);
	}

	@Override
	protected E getElement() {
		return null;
	}

	private static final long serialVersionUID = 1L;
}