/*******************************************************************************
 * Copyright (c) 2012, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.tests.reference;

import junit.framework.Test;
import junit.framework.TestSuite;

/**
 * decentralize test creation code
 */
public class CommonUtilityReferenceTests {

	public static Test suite() {
		TestSuite suite = new TestSuite(CommonUtilityReferenceTests.class.getPackage().getName());

		suite.addTestSuite(SimpleBooleanReferenceTests.class);
		suite.addTestSuite(SimpleIntReferenceTests.class);
		suite.addTestSuite(SimpleObjectReferenceTests.class);
		suite.addTestSuite(SynchronizedBooleanTests.class);
		suite.addTestSuite(SynchronizedIntTests.class);
		suite.addTestSuite(SynchronizedObjectTests.class);

		return suite;
	}

	private CommonUtilityReferenceTests() {
		super();
		throw new UnsupportedOperationException();
	}
}