/*******************************************************************************
 * Copyright (c) 2011, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.tests.iterator;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.tools.utility.iterator.SimultaneousListIterator;

public class SimultaneousListIteratorTests
	extends SimultaneousIteratorTests
{
	public SimultaneousListIteratorTests(String name) {
		super(name);
	}

	@Override
	protected Iterator<List<String>> buildIterator(ListIterator<String>... iterators) {
		return new SimultaneousListIterator<String>(iterators);
	}

	@Override
	protected Iterator<List<String>> buildIterator(Iterable<ListIterator<String>> iterators) {
		return new SimultaneousListIterator<String>(iterators);
	}
}