/*******************************************************************************
 * Copyright (c) 2009, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.tests.iterable;

import java.util.Iterator;
import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.collection.LinkedStack;
import org.eclipse.persistence.tools.utility.collection.Stack;
import org.eclipse.persistence.tools.utility.iterable.StackIterable;

@SuppressWarnings("nls")
public class StackIterableTests extends TestCase {

	public StackIterableTests(String name) {
		super(name);
	}

	public void testIterator() {
		Iterator<String> iterator = this.buildIterable().iterator();
		assertEquals("three", iterator.next());
		assertEquals("two", iterator.next());
		assertEquals("one", iterator.next());
	}

	public void testToString() {
		assertNotNull(this.buildIterable().toString());
	}

	private Iterable<String> buildIterable() {
		return new StackIterable<String>(this.buildStack());
	}

	private Stack<String> buildStack() {
		Stack<String> stack = new LinkedStack<String>();
		stack.push("one");
		stack.push("two");
		stack.push("three");
		return stack;
	}
}