/*******************************************************************************
 * Copyright (c) 2009, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.tests.filter;

import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.filter.Filter;
import org.eclipse.persistence.tools.utility.filter.NotNullFilter;

@SuppressWarnings("nls")
public class NotNullFilterTests extends TestCase {

	public NotNullFilterTests(String name) {
		super(name);
	}

	public void testNotNullFilter() {
		Filter<String> filter = NotNullFilter.instance();
		assertTrue(filter.accept(""));
		assertFalse(filter.accept(null));
		assertTrue(filter.accept("foo"));
		assertTrue(filter.accept("bar"));
	}

	public void testToString() {
		Filter<String> filter = NotNullFilter.instance();
		assertNotNull(filter.toString());
	}
}