/*******************************************************************************
 * Copyright (c) 2005, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.tests.filter;

import java.io.Serializable;
import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.filter.Filter;
import org.eclipse.persistence.tools.utility.filter.FilterAdapter;
import org.eclipse.persistence.tools.utility.filter.NOTFilter;
import org.eclipse.persistence.tools.utility.tests.TestTools;

public class NOTFilterTests
	extends TestCase
{
	private NOTFilter<Number> notFilter;


	public NOTFilterTests(String name) {
		super(name);
	}

	@Override
	protected void setUp() throws Exception {
		super.setUp();
		this.notFilter = new NOTFilter<Number>(this.buildPositiveFilter());
	}

	private Filter<Number> buildPositiveFilter() {
		return new PositiveFilter();
	}

	static class PositiveFilter
		extends FilterAdapter<Number>
		implements Serializable
	{
		private static final long serialVersionUID = 1L;
		@Override
		public boolean accept(Number number) {
			return number.doubleValue() > 0;
		}
		@Override
		public boolean equals(Object obj) {
			return this.getClass() == obj.getClass();
		}
		@Override
		public int hashCode() {
			return 789;
		}
	}

	@Override
	protected void tearDown() throws Exception {
		TestTools.clear(this);
		super.tearDown();
	}

	public void testFiltering() {
		assertTrue(this.notFilter.accept(new Integer(0)));
		assertTrue(this.notFilter.accept(new Integer(-1)));
		assertTrue(this.notFilter.accept(new Double(-0.001)));
		assertFalse(this.notFilter.accept(new Double(1)));
		assertFalse(this.notFilter.accept(new Double(11)));
		assertFalse(this.notFilter.accept(new Double(111)));
	}

	public void testClone() {
		@SuppressWarnings("unchecked")
		NOTFilter<Number> notFilter2 = (NOTFilter<Number>) this.notFilter.clone();
		assertEquals(this.notFilter.getFilter(), notFilter2.getFilter());
		assertNotSame(this.notFilter, notFilter2);
	}

	public void testEquals() {
		NOTFilter<Number> notFilter2 = new NOTFilter<Number>(this.buildPositiveFilter());
		assertEquals(this.notFilter, notFilter2);
		assertEquals(this.notFilter.hashCode(), notFilter2.hashCode());
	}

	public void testSerialization() throws Exception {
		NOTFilter<Number> notFilter2 = TestTools.serialize(this.notFilter);
		assertEquals(this.notFilter.getFilter(), notFilter2.getFilter());
		assertNotSame(this.notFilter, notFilter2);
	}
}