/*******************************************************************************
 * Copyright (c) 2012, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.tests;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.CompositeExceptionHandler;
import org.eclipse.persistence.tools.utility.ExceptionHandler;
import org.eclipse.persistence.tools.utility.PrintStreamExceptionHandler;

@SuppressWarnings("nls")
public class PrintStreamExceptionHandlerTests
	extends TestCase
{
	public PrintStreamExceptionHandlerTests(String name) {
		super(name);
	}

	public void testHandleException() {
		OutputStream out = new ByteArrayOutputStream();
		PrintStream stream = new PrintStream(out);
		ExceptionHandler exceptionHandler = new PrintStreamExceptionHandler(stream);
		Exception npe = new NullPointerException();
		exceptionHandler.handleException(npe);
		stream.flush();

		assertTrue(out.toString().contains("NullPointerException"));
	}

	public void testToString() {
		CompositeExceptionHandler exceptionHandler = new CompositeExceptionHandler();
		assertNotNull(exceptionHandler.toString());
	}
}