/*******************************************************************************
 * Copyright (c) 1998, 2012 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation from Oracle TopLink
******************************************************************************/
package org.eclipse.persistence.tools.db.model.spi;

/**
 * Interface for an external database that can be queried for metadata.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see ExternalDatabaseFactory
 * @version 2.5
 */
public interface ExternalDatabase {

	/**
	 * Returns the database's catalog names.
	 * What connotes a "catalog" is typically platform-dependent.
	 */
	String[] getCatalogNames();

	/**
	 * Returns the database's schema names.
	 * What connotes a "schema" is typically platform-dependent.
	 */
	String[] getSchemaNames();

	/**
	 * Returns all the database's table descriptions.
	 * Depending on the implementation and/or runtime configuration, clients
	 * will use this method or #getTableDescriptions(String, String, String, String[]).
	 */
	ExternalTableDescription[] getTableDescriptions();

	/**
	 * Returns the database's table descriptions corresponding to the specified
	 * search criteria.
	 * Depending on the implementation and/or runtime configuration, clients
	 * will use this method or #getTableDescriptions().
	 * @see java.sql.DatabaseMetaData#getTables(String, String, String, String[])
	 */
	ExternalTableDescription[] getTableDescriptions(String catalogName, String schemaNamePattern, String tableNamePattern, String[] tableTypeNames);

	/**
	 * Returns the database's table types.
	 * What connotes a "table type" is typically platform-dependent.
	 */
	String[] getTableTypeNames();
}