/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.orm.ExternalSequenceGenerator;

/**
 * The external form of a sequence generator.
 *
 * @see BasicMapping
 * @see Entity
 * @see IdMapping
 * @see ORMConfiguration
 *
 * @version 2.5
 * @author Les Davis
 * @author Pascal Filion
 */
@SuppressWarnings("nls")
final class SequenceGenerator extends PrimaryKeyGenerator
                              implements ExternalSequenceGenerator {

	/**
	 * The node name used to store and retrieve the <code>Element</code> encapsulated by this
	 * external form.
	 */
	static final String SEQUENCE_GENERATOR = "sequence-generator";

	/**
	 * The attribute name used to store and retrieve the sequence-name property.
	 */
	static final String SEQUENCE_NAME = "sequence-name";

	/**
	 * Creates a new <code>SequenceGenerator</code>.
	 *
	 * @param parent The parent of this external form
	 */
	SequenceGenerator(BasicMapping parent) {
		super(parent);
	}

	/**
	 * Creates a new <code>SequenceGenerator</code>.
	 *
	 * @param parent The parent of this external form
	 */
	SequenceGenerator(MappedSuperClassEntity parent) {
		super(parent);
	}

	/**
	 * Creates a new <code>SequenceGenerator</code>.
	 *
	 * @param parent The parent of this external form
	 */
	SequenceGenerator(IdMapping parent) {
		super(parent);
	}

	/**
	 * Creates a new <code>SequenceGenerator</code>.
	 *
	 * @param parent The parent of this external form
	 * @param index The position of the element within the list of children with the same type owned
	 * by the parent
	 */
	SequenceGenerator(ORMConfiguration parent, int index) {
		super(parent, index);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected List<String> buildAttributeNamesOrder() {
		List<String> names = new ArrayList<String>();
		names.add(CATALOG);
		names.add(SCHEMA);
		names.add(NAME);
		names.add(SEQUENCE_NAME);
		names.add(INITIAL_VALUE);
		names.add(ALLOCATION_SIZE);
		return names;
	}


	/**
	 * {@inheritDoc}
	 */
	@Override
	protected String getElementName() {
		return SEQUENCE_GENERATOR;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getSequenceName() {
		return getAttribute(SEQUENCE_NAME);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setSequenceName(String name) {

		setAttribute(SEQUENCE_NAME, name);

		if (shouldBeRemoved()) {
			removeSelf();
		}
	}
}