/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.GenerationType;
import org.eclipse.persistence.tools.mapping.orm.ExternalEntityIDGeneratedValue;

/**
 * The external form of a generated value.
 *
 * @see IdMapping
 *
 * @version 2.5
 * @author Pascal Filion
 */
@SuppressWarnings("nls")
final class EntityIDGeneratedValue extends AbstractExternalForm
                                   implements ExternalEntityIDGeneratedValue {

	/**
	 * The node name used to store and retrieve the {@link Element} encapsulated by this external form.
	 */
	static final String GENERATED_VALUE = "generated-value";

	/**
	 * The attribute name used to store and retrieve the generator property.
	 */
	static final String GENERATOR = "generator";

	/**
	 * The attribute name used to store and retrieve the strategy property.
	 */
	static final String STRATEGY = "strategy";

	/**
	 * Creates a new <code>EntityIDGeneratedValue</code>.
	 *
	 * @param parent The parent of this external form
	 */
	EntityIDGeneratedValue(AbstractExternalForm parent) {
		super(parent);
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	protected List<String> buildAttributeNamesOrder() {
		List<String> names = new ArrayList<String>();
		names.add(STRATEGY);
		names.add(GENERATOR);
		return names;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected String getElementName() {
		return GENERATED_VALUE;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public GenerationType getGenerationType() {
		return getEnumAttribute(STRATEGY, GenerationType.class);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getGeneratorName() {
		return getAttribute(GENERATOR);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setGenerationType(GenerationType type) {
		setAttribute(STRATEGY, type);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setGeneratorName(String generatorName) {
		setAttribute(GENERATOR, generatorName);
	}
}