/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import javax.persistence.CascadeType;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;

/**
 * This interface represents the basis for all variable one to one mapping types defined by the
 * EclipseLink JPA spec that are available for configuration via the EclipseLink ORM xml.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @version 2.5
 * @author Les Davis
 */
public interface ExternalVariableOneToOneMapping extends ExternalMappedMapping,
                                                         ExternalPrivatelyOwnableMapping,
                                                         ExternalOrphanRemovableMapping {

	/**
	 * Adds a cascaded type to use.
	 */
	void addCascadeType(CascadeType type);

	/**
	 * Adds a discriminator class with the given name.
	 */
	void addDiscriminatorClass(int index, String discrimator, String value);

	/**
	 * Creates a new discriminator column definition replacing the old one.
	 */
	void addDiscriminatorColumn();

	/**
	 * Adds a join column with the given name.
	 */
	void addJoinColumn(int index, String name);

	/**
	 * Returns the enum, CascadeType to use for this relationship.
	 */
	ListIterable<CascadeType> cascadeTypes();

	/**
	 * Returns the discriminator class for this mapping.
	 */
	ListIterable<ExternalDiscriminatorClass> discriminatorClasses();

	/**
	 * Returns the count of discriminator classes for this mapping.
	 */
	int discriminatorClassesSize();

	/**
	 * Returns a discriminator class with the given target class name and value.
	 */
	ExternalDiscriminatorClass getDiscriminatorClass(String value, String discriminator);

	/**
	 * Returns the discriminator column definition.
	 */
	ExternalDiscriminatorColumn getDiscriminatorColumn();

	/**
	 * Returns a join column with the given name
	 */
	ExternalJoinColumn getJoinColumn(int index);

	/**
	 * Returns the target interface name for this mapping.
	 */
	String getTargetInterfaceName();

	/**
	 * Returns the join column for this mapping.
	 */
	ListIterable<ExternalJoinColumn> joinColumns();

	/**
	 * Returns the count of join columns for this mapping.
	 */
	int joinColumnsSize();

	/**
	 * Removes a cascade type.
	 */
	void removeCascadeType(CascadeType type);

	/**
	 * Removes the discriminator class at the given index.
	 */
	void removeDiscriminatorClass(int index);

	/**
	 * Removes the discriminator column definition.
	 */
	void removeDiscriminatorColumn();

	/**
	 * Removes the join column named.
	 */
	void removeJoinColumn(int index);

	/**
	 * Sets the target interface name.
	 */
	void setTargetInterfaceName(String entityName);
}