/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import javax.persistence.FetchType;
import org.eclipse.persistence.annotations.JoinFetchType;

/**
 * This interface represents the basis for all basic collection mapping types defined by the
 * EclipseLink JPA spec that are available for configuration via the EclipseLink ORM xml.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @version 2.5
 * @author Les Davis
 */
public interface ExternalBasicCollectionMapping extends ExternalConvertibleMapping {

	/**
	 * Adds a batch fetch to use.
	 */
	void addBatchFetch();

	/**
	 * Adds a collection table to this mapping.
	 */
	void addCollectionTable(String name);

	/**
	 * Adds the value column for this mapping.
	 */
	void addValueColumn(String columnName);

	/**
	 * Returns the batch fetch definition for this mapping.
	 */
	ExternalBatchFetch getBatchFetch();

	/**
	 * Returns the collection table for this mapping.
	 */
	ExternalCollectionTable getCollectionTable();

	/**
	 * Returns the fetch type for this mapping.
	 */
	FetchType getFetchType();

	/**
	 * Returns the join fetch type for this mapping.
	 */
	JoinFetchType getJoinFetchType();

	/**
	 * Returns the value column for this mapping.
	 */
	ExternalEntityColumn getValueColumn();

	/**
	 * Removes the batch fetch.
	 */
	void removeBatchFetch();

	/**
	 * Removes the collection table from this mapping.
	 */
	void removeCollectionTable();

	/**
	 * Removes the value column from this mapping.
	 */
	void removeValueColumn();

	/**
	 * Sets the fetch type for this mapping.
	 */
	void setFetchType(FetchType type);

	/**
	 * Sets the join fetch type from this mapping.
	 */
	void setJoinFetchType(JoinFetchType type);
}