/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.gen.db;

import java.text.Collator;
import java.util.Comparator;
import org.eclipse.persistence.tools.gen.db.ConnectionProfile;
import org.eclipse.persistence.tools.gen.db.Database;
import org.eclipse.persistence.tools.utility.transformer.Transformer;

public interface DatabaseObject {
    public static final Comparator<DatabaseObject> DEFAULT_COMPARATOR = new Comparator<DatabaseObject>(){

        @Override
        public int compare(DatabaseObject dbObject1, DatabaseObject dbObject2) {
            return Collator.getInstance().compare(dbObject1.getName(), dbObject2.getName());
        }

        public String toString() {
            return String.valueOf(this.getClass().getEnclosingClass().getSimpleName()) + ".DEFAULT_COMPARATOR";
        }
    };
    public static final Transformer<DatabaseObject, String> NAME_TRANSFORMER = new Transformer<DatabaseObject, String>(){

        public String transform(DatabaseObject dbObject) {
            return dbObject.getName();
        }

        public String toString() {
            return String.valueOf(this.getClass().getEnclosingClass().getSimpleName()) + ".NAME_TRANSFORMER";
        }
    };
    public static final Transformer<DatabaseObject, String> IDENTIFIER_TRANSFORMER = new Transformer<DatabaseObject, String>(){

        public String transform(DatabaseObject dbObject) {
            return dbObject.getIdentifier();
        }

        public String toString() {
            return String.valueOf(this.getClass().getEnclosingClass().getSimpleName()) + ".IDENTIFIER_TRANSFORMER";
        }
    };

    public String getName();

    public String getIdentifier();

    public String getIdentifier(String var1);

    public Database getDatabase();

    public ConnectionProfile getConnectionProfile();
}

