/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.transformer;

import java.io.Serializable;
import org.eclipse.persistence.tools.utility.ObjectTools;

public interface Transformer<T1, T2> {
    public T2 transform(T1 var1);

    public static final class Disabled<S1, S2>
    implements Transformer<S1, S2>,
    Serializable {
        public static final Transformer INSTANCE = new Disabled();
        private static final long serialVersionUID = 1L;

        public static <R1, R2> Transformer<R1, R2> instance() {
            return INSTANCE;
        }

        private Disabled() {
        }

        @Override
        public S2 transform(S1 o) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return ObjectTools.singletonToString(this);
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    public static final class Non<S>
    implements Transformer<S, S>,
    Serializable {
        public static final Transformer INSTANCE = new Non();
        private static final long serialVersionUID = 1L;

        public static <R> Transformer<R, R> instance() {
            return INSTANCE;
        }

        private Non() {
        }

        @Override
        public S transform(S o) {
            return o;
        }

        public String toString() {
            return ObjectTools.singletonToString(this);
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    public static final class Null<S1, S2>
    implements Transformer<S1, S2>,
    Serializable {
        public static final Transformer INSTANCE = new Null();
        private static final long serialVersionUID = 1L;

        public static <R1, R2> Transformer<R1, R2> instance() {
            return INSTANCE;
        }

        private Null() {
        }

        @Override
        public S2 transform(S1 o) {
            return null;
        }

        public String toString() {
            return ObjectTools.singletonToString(this);
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }
}

