/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.model.value;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.persistence.tools.utility.collection.CollectionTools;
import org.eclipse.persistence.tools.utility.filter.Filter;
import org.eclipse.persistence.tools.utility.iterable.FilteringIterable;
import org.eclipse.persistence.tools.utility.iterator.ReadOnlyIterator;
import org.eclipse.persistence.tools.utility.model.event.CollectionAddEvent;
import org.eclipse.persistence.tools.utility.model.event.CollectionChangeEvent;
import org.eclipse.persistence.tools.utility.model.event.CollectionClearEvent;
import org.eclipse.persistence.tools.utility.model.event.CollectionRemoveEvent;
import org.eclipse.persistence.tools.utility.model.value.CollectionValueModel;
import org.eclipse.persistence.tools.utility.model.value.CollectionValueModelWrapper;
import org.eclipse.persistence.tools.utility.model.value.ListCollectionValueModelAdapter;
import org.eclipse.persistence.tools.utility.model.value.ListValueModel;

public class FilteringCollectionValueModel<E>
extends CollectionValueModelWrapper<E>
implements CollectionValueModel<E> {
    private Filter<E> filter;
    private final ArrayList<E> filteredItems = new ArrayList();

    public FilteringCollectionValueModel(CollectionValueModel<? extends E> collectionModel) {
        this(collectionModel, Filter.Transparent.instance());
    }

    public FilteringCollectionValueModel(CollectionValueModel<? extends E> collectionModel, Filter<E> filter) {
        super(collectionModel);
        if (filter == null) {
            throw new NullPointerException();
        }
        this.filter = filter;
    }

    public FilteringCollectionValueModel(ListValueModel<? extends E> listModel) {
        this(new ListCollectionValueModelAdapter<E>(listModel));
    }

    public FilteringCollectionValueModel(ListValueModel<? extends E> listModel, Filter<E> filter) {
        this(new ListCollectionValueModelAdapter<E>(listModel), filter);
    }

    @Override
    public Iterator<E> iterator() {
        return new ReadOnlyIterator<E>(this.filteredItems);
    }

    @Override
    public int size() {
        return this.filteredItems.size();
    }

    @Override
    protected void engageModel() {
        super.engageModel();
        CollectionTools.addAll(this.filteredItems, this.filter(this.collectionModel));
    }

    @Override
    protected void disengageModel() {
        super.disengageModel();
        this.filteredItems.clear();
    }

    @Override
    protected void itemsAdded(CollectionAddEvent event) {
        this.addItemsToCollection(this.filter(this.getItems(event)), this.filteredItems, "values");
    }

    @Override
    protected void itemsRemoved(CollectionRemoveEvent event) {
        this.removeItemsFromCollection(event.getItems(), this.filteredItems, "values");
    }

    @Override
    protected void collectionCleared(CollectionClearEvent event) {
        this.clearCollection(this.filteredItems, "values");
    }

    @Override
    protected void collectionChanged(CollectionChangeEvent event) {
        this.rebuildFilteredItems();
    }

    public void setFilter(Filter<E> filter) {
        this.filter = filter;
        this.rebuildFilteredItems();
    }

    protected Iterable<E> filter(Iterable<? extends E> items) {
        return new FilteringIterable<E>(items, this.filter);
    }

    protected void rebuildFilteredItems() {
        this.filteredItems.clear();
        CollectionTools.addAll(this.filteredItems, this.filter(this.collectionModel));
        this.fireCollectionChanged("values", this.filteredItems);
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.filteredItems);
    }
}

