/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.iterable;

import java.util.Iterator;
import org.eclipse.persistence.tools.utility.collection.ListTools;
import org.eclipse.persistence.tools.utility.iterator.TransformationIterator;
import org.eclipse.persistence.tools.utility.transformer.Transformer;

public class TransformationIterable<E1, E2>
implements Iterable<E2> {
    private final Iterable<? extends E1> iterable;
    private final Transformer<E1, ? extends E2> transformer;

    public TransformationIterable(Iterable<? extends E1> iterable) {
        if (iterable == null) {
            throw new NullPointerException();
        }
        this.iterable = iterable;
        this.transformer = this.buildDefaultTransformer();
    }

    public TransformationIterable(Iterable<? extends E1> iterable, Transformer<E1, ? extends E2> transformer) {
        if (iterable == null || transformer == null) {
            throw new NullPointerException();
        }
        this.iterable = iterable;
        this.transformer = transformer;
    }

    protected Transformer<E1, ? extends E2> buildDefaultTransformer() {
        return new DefaultTransformer();
    }

    @Override
    public Iterator<E2> iterator() {
        return new TransformationIterator<E1, E2>(this.iterable.iterator(), this.transformer);
    }

    protected E2 transform(E1 o) {
        throw new RuntimeException("This method was not overridden.");
    }

    public String toString() {
        return ListTools.list(this).toString();
    }

    protected class DefaultTransformer
    implements Transformer<E1, E2> {
        protected DefaultTransformer() {
        }

        @Override
        public E2 transform(E1 o) {
            return TransformationIterable.this.transform(o);
        }
    }
}

