/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.iterable;

import java.util.Iterator;
import org.eclipse.persistence.tools.utility.collection.ListTools;
import org.eclipse.persistence.tools.utility.filter.Filter;
import org.eclipse.persistence.tools.utility.iterator.FilteringIterator;

public class FilteringIterable<E>
implements Iterable<E> {
    private final Iterable<? extends E> iterable;
    private final Filter<E> filter;

    public FilteringIterable(Iterable<? extends E> iterable) {
        this.iterable = iterable;
        this.filter = this.buildDefaultFilter();
    }

    public FilteringIterable(Iterable<? extends E> iterable, Filter<E> filter) {
        if (iterable == null || filter == null) {
            throw new NullPointerException();
        }
        this.iterable = iterable;
        this.filter = filter;
    }

    protected Filter<E> buildDefaultFilter() {
        return new DefaultFilter();
    }

    @Override
    public Iterator<E> iterator() {
        return new FilteringIterator<E>(this.iterable.iterator(), this.filter);
    }

    protected boolean accept(E o) {
        throw new RuntimeException("This method was not overridden.");
    }

    public String toString() {
        return ListTools.list(this).toString();
    }

    protected class DefaultFilter
    implements Filter<E> {
        protected DefaultFilter() {
        }

        @Override
        public boolean accept(E o) {
            return FilteringIterable.this.accept(o);
        }
    }
}

