/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.command;

import org.eclipse.persistence.tools.utility.command.AbstractQueueingCommandExecutor;
import org.eclipse.persistence.tools.utility.command.Command;
import org.eclipse.persistence.tools.utility.command.ExtendedCommandExecutor;
import org.eclipse.persistence.tools.utility.command.SimpleStatefulExtendedCommandExecutor;
import org.eclipse.persistence.tools.utility.command.StatefulExtendedCommandExecutor;
import org.eclipse.persistence.tools.utility.command.SynchronizingCommand;

public class QueueingExtendedCommandExecutor
extends AbstractQueueingCommandExecutor<StatefulExtendedCommandExecutor>
implements StatefulExtendedCommandExecutor {
    public QueueingExtendedCommandExecutor() {
        this(ExtendedCommandExecutor.Default.instance());
    }

    public QueueingExtendedCommandExecutor(ExtendedCommandExecutor commandExecutor) {
        this(new SimpleStatefulExtendedCommandExecutor(commandExecutor));
    }

    public QueueingExtendedCommandExecutor(StatefulExtendedCommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public void waitToExecute(Command command) throws InterruptedException {
        SynchronizingCommand syncCommand = new SynchronizingCommand();
        this.execute(syncCommand);
        try {
            syncCommand.waitForExecution();
            ((StatefulExtendedCommandExecutor)this.commandExecutor).waitToExecute(command);
        }
        finally {
            syncCommand.release();
        }
    }

    @Override
    public boolean waitToExecute(Command command, long timeout) throws InterruptedException {
        if (timeout == 0L) {
            this.waitToExecute(command);
            return true;
        }
        long stop = System.currentTimeMillis() + timeout;
        SynchronizingCommand syncCommand = new SynchronizingCommand();
        this.execute(syncCommand);
        try {
            if (syncCommand.waitForExecution(timeout)) {
                timeout = stop - System.currentTimeMillis();
                boolean bl = timeout > 0L && ((StatefulExtendedCommandExecutor)this.commandExecutor).waitToExecute(command, timeout);
                return bl;
            }
            return false;
        }
        finally {
            syncCommand.release();
        }
    }
}

