/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility;

import java.util.Arrays;
import org.eclipse.persistence.tools.utility.ArrayTools;
import org.eclipse.persistence.tools.utility.CharArrayTools;
import org.eclipse.persistence.tools.utility.ClassTools;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.StringBuilderTools;

public final class ClassNameTools {
    public static final String VOID = ClassTools.VOID.getName();
    public static final char[] VOID_CHAR_ARRAY = VOID.toCharArray();
    public static final String VOID_WRAPPER = ClassTools.VOID_WRAPPER.getName();
    public static final char[] VOID_WRAPPER_CHAR_ARRAY = VOID_WRAPPER.toCharArray();
    public static final char REFERENCE_CLASS_CODE = 'L';
    public static final char REFERENCE_CLASS_NAME_DELIMITER = ';';
    public static final String BRACKETS = "[]";
    public static final char[] BRACKETS_CHAR_ARRAY = "[]".toCharArray();

    public static boolean isArray(String className) {
        return className.charAt(0) == '[';
    }

    public static boolean isArray(char[] className) {
        return className[0] == '[';
    }

    public static int arrayDepth(String className) {
        int depth = 0;
        while (className.charAt(depth) == '[') {
            ++depth;
        }
        return depth;
    }

    public static int arrayDepth(char[] className) {
        int depth = 0;
        while (className[depth] == '[') {
            ++depth;
        }
        return depth;
    }

    public static String elementTypeName(String className) {
        int depth = ClassNameTools.arrayDepth(className);
        return depth == 0 ? className : ClassNameTools.elementTypeName_(className, depth);
    }

    private static String elementTypeName_(String className, int arrayDepth) {
        int last = className.length() - 1;
        if (className.charAt(arrayDepth) == 'L') {
            return className.substring(arrayDepth + 1, last);
        }
        return ClassNameTools.forCode(className.charAt(last));
    }

    public static char[] elementTypeName(char[] className) {
        int depth = ClassNameTools.arrayDepth(className);
        return depth == 0 ? className : ClassNameTools.elementTypeName_(className, depth);
    }

    private static char[] elementTypeName_(char[] className, int arrayDepth) {
        int last = className.length - 1;
        if (className[arrayDepth] == 'L') {
            return ArrayTools.subArray(className, arrayDepth + 1, last);
        }
        return ClassNameTools.forCodeCharArray(className[last]);
    }

    public static String componentTypeName(String className) {
        switch (ClassNameTools.arrayDepth(className)) {
            case 0: {
                return null;
            }
            case 1: {
                return ClassNameTools.elementTypeName_(className, 1);
            }
        }
        return className.substring(1);
    }

    public static char[] componentTypeName(char[] className) {
        switch (ClassNameTools.arrayDepth(className)) {
            case 0: {
                return null;
            }
            case 1: {
                return ClassNameTools.elementTypeName_(className, 1);
            }
        }
        return ArrayTools.subArray(className, 1, className.length);
    }

    public static String typeDeclaration(String className) {
        int arrayDepth = ClassNameTools.arrayDepth(className);
        return arrayDepth == 0 ? className : ClassNameTools.typeDeclaration_(className, arrayDepth);
    }

    private static String typeDeclaration_(String className, int arrayDepth) {
        String elementTypeName = ClassNameTools.elementTypeName_(className, arrayDepth);
        StringBuilder sb = new StringBuilder(elementTypeName.length() + (arrayDepth << 1));
        sb.append(elementTypeName);
        int i = 0;
        while (i < arrayDepth) {
            sb.append(BRACKETS);
            ++i;
        }
        return sb.toString();
    }

    public static char[] typeDeclaration(char[] className) {
        int arrayDepth = ClassNameTools.arrayDepth(className);
        return arrayDepth == 0 ? className : ClassNameTools.typeDeclaration_(className, arrayDepth);
    }

    private static char[] typeDeclaration_(char[] className, int arrayDepth) {
        char[] elementTypeName = ClassNameTools.elementTypeName_(className, arrayDepth);
        StringBuilder sb = new StringBuilder(elementTypeName.length + (arrayDepth << 1));
        sb.append(elementTypeName);
        int i = 0;
        while (i < arrayDepth) {
            sb.append(BRACKETS);
            ++i;
        }
        return StringBuilderTools.convertToCharArray(sb);
    }

    public static String simpleName(String className) {
        return ClassNameTools.isArray(className) ? String.valueOf(ClassNameTools.simpleName(ClassNameTools.componentTypeName(className))) + BRACKETS : ClassNameTools.simpleName_(className);
    }

    private static String simpleName_(String className) {
        int index = className.lastIndexOf(36);
        if (index == -1) {
            return className.substring(className.lastIndexOf(46) + 1);
        }
        int len = className.length();
        int i = ++index;
        while (i < len) {
            if (!ClassNameTools.charIsAsciiDigit(className.charAt(i))) {
                return className.substring(i);
            }
            ++i;
        }
        return "";
    }

    public static char[] simpleName(char[] className) {
        return ClassNameTools.isArray(className) ? ArrayTools.addAll(ClassNameTools.simpleName(ClassNameTools.componentTypeName(className)), BRACKETS_CHAR_ARRAY) : ClassNameTools.simpleName_(className);
    }

    private static char[] simpleName_(char[] className) {
        int index = ArrayTools.lastIndexOf(className, '$');
        if (index == -1) {
            return ArrayTools.subArray(className, ArrayTools.lastIndexOf(className, '.') + 1, className.length);
        }
        int len = className.length;
        int i = ++index;
        while (i < len) {
            if (!ClassNameTools.charIsAsciiDigit(className[i])) {
                return ArrayTools.subArray(className, i, className.length);
            }
            ++i;
        }
        return CharArrayTools.EMPTY_CHAR_ARRAY;
    }

    public static String packageName(String className) {
        if (ClassNameTools.isArray(className)) {
            return "";
        }
        int lastPeriod = className.lastIndexOf(46);
        return lastPeriod == -1 ? "" : className.substring(0, lastPeriod);
    }

    public static char[] packageName(char[] className) {
        if (ClassNameTools.isArray(className)) {
            return CharArrayTools.EMPTY_CHAR_ARRAY;
        }
        int lastPeriod = ArrayTools.lastIndexOf(className, '.');
        return lastPeriod == -1 ? CharArrayTools.EMPTY_CHAR_ARRAY : ArrayTools.subArray(className, 0, lastPeriod);
    }

    public static boolean isTopLevel(String className) {
        if (ClassNameTools.isArray(className)) {
            return false;
        }
        return className.lastIndexOf(36) == -1;
    }

    public static boolean isTopLevel(char[] className) {
        if (ClassNameTools.isArray(className)) {
            return false;
        }
        return ArrayTools.lastIndexOf(className, '$') == -1;
    }

    public static boolean isMember(String className) {
        if (ClassNameTools.isArray(className)) {
            return false;
        }
        int index = className.lastIndexOf(36);
        if (index == -1) {
            return false;
        }
        return !ClassNameTools.charIsAsciiDigit(className.charAt(++index));
    }

    public static boolean isMember(char[] className) {
        if (ClassNameTools.isArray(className)) {
            return false;
        }
        int index = ArrayTools.lastIndexOf(className, '$');
        if (index == -1) {
            return false;
        }
        return !ClassNameTools.charIsAsciiDigit(className[++index]);
    }

    public static boolean isLocal(String className) {
        if (ClassNameTools.isArray(className)) {
            return false;
        }
        int index = className.lastIndexOf(36);
        if (index == -1) {
            return false;
        }
        if (!ClassNameTools.charIsAsciiDigit(className.charAt(++index))) {
            return false;
        }
        int len = className.length();
        int i = ++index;
        while (i < len) {
            if (!ClassNameTools.charIsAsciiDigit(className.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isLocal(char[] className) {
        if (ClassNameTools.isArray(className)) {
            return false;
        }
        int index = ArrayTools.lastIndexOf(className, '$');
        if (index == -1) {
            return false;
        }
        if (!ClassNameTools.charIsAsciiDigit(className[++index])) {
            return false;
        }
        int len = className.length;
        int i = ++index;
        while (i < len) {
            if (!ClassNameTools.charIsAsciiDigit(className[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isAnonymous(String className) {
        if (ClassNameTools.isArray(className)) {
            return false;
        }
        int index = className.lastIndexOf(36);
        if (index == -1) {
            return false;
        }
        if (!ClassNameTools.charIsAsciiDigit(className.charAt(++index))) {
            return false;
        }
        int len = className.length();
        int i = ++index;
        while (i < len) {
            if (!ClassNameTools.charIsAsciiDigit(className.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isAnonymous(char[] className) {
        if (ClassNameTools.isArray(className)) {
            return false;
        }
        int index = ArrayTools.lastIndexOf(className, '$');
        if (index == -1) {
            return false;
        }
        if (!ClassNameTools.charIsAsciiDigit(className[++index])) {
            return false;
        }
        int len = className.length;
        int i = ++index;
        while (i < len) {
            if (!ClassNameTools.charIsAsciiDigit(className[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean charIsAsciiDigit(char c) {
        return '0' <= c && c <= '9';
    }

    public static boolean isReference(String className) {
        return !ClassNameTools.isPrimitive(className);
    }

    public static boolean isReference(char[] className) {
        return !ClassNameTools.isPrimitive(className);
    }

    public static boolean isPrimitive(String className) {
        if (ClassNameTools.isArray(className) || className.length() > ClassTools.MAX_PRIMITIVE_CLASS_NAME_LENGTH) {
            return false;
        }
        for (ClassTools.Primitive primitive : ClassTools.PRIMITIVES) {
            if (!className.equals(primitive.javaClass.getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isPrimitive(char[] className) {
        if (ClassNameTools.isArray(className) || className.length > ClassTools.MAX_PRIMITIVE_CLASS_NAME_LENGTH) {
            return false;
        }
        for (ClassTools.Primitive primitive : ClassTools.PRIMITIVES) {
            if (!Arrays.equals(className, primitive.javaClassName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPrimitiveWrapper(String className) {
        if (ClassNameTools.isArray(className) || className.length() > ClassTools.MAX_PRIMITIVE_WRAPPER_CLASS_NAME_LENGTH) {
            return false;
        }
        for (ClassTools.Primitive primitive : ClassTools.PRIMITIVES) {
            if (!className.equals(primitive.wrapperClass.getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isPrimitiveWrapper(char[] className) {
        if (ClassNameTools.isArray(className) || className.length > ClassTools.MAX_PRIMITIVE_WRAPPER_CLASS_NAME_LENGTH) {
            return false;
        }
        for (ClassTools.Primitive primitive : ClassTools.PRIMITIVES) {
            if (!Arrays.equals(className, primitive.wrapperClassName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isVariablePrimitive(String className) {
        return ClassNameTools.isPrimitive(className) && !className.equals(VOID);
    }

    public static boolean isVariablePrimitive(char[] className) {
        return ClassNameTools.isPrimitive(className) && !Arrays.equals(className, VOID_CHAR_ARRAY);
    }

    public static boolean isVariablePrimitiveWrapper(String className) {
        return ClassNameTools.isPrimitiveWrapper(className) && !className.equals(VOID_WRAPPER);
    }

    public static boolean isVariablePrimitiveWrapper(char[] className) {
        return ClassNameTools.isPrimitiveWrapper(className) && !Arrays.equals(className, VOID_WRAPPER_CHAR_ARRAY);
    }

    public static String primitiveWrapperClassName(String primitiveClassName) {
        for (ClassTools.Primitive primitive : ClassTools.PRIMITIVES) {
            if (!primitive.javaClass.getName().equals(primitiveClassName)) continue;
            return primitive.wrapperClass.getName();
        }
        return null;
    }

    public static char[] primitiveWrapperClassName(char[] primitiveClassName) {
        for (ClassTools.Primitive primitive : ClassTools.PRIMITIVES) {
            if (!Arrays.equals(primitive.javaClassName, primitiveClassName)) continue;
            return primitive.wrapperClassName;
        }
        return null;
    }

    public static String primitiveClassName(String primitiveWrapperClassName) {
        for (ClassTools.Primitive primitive : ClassTools.PRIMITIVES) {
            if (!primitive.wrapperClass.getName().equals(primitiveWrapperClassName)) continue;
            return primitive.javaClass.getName();
        }
        return null;
    }

    public static char[] primitiveClassName(char[] primitiveWrapperClassName) {
        for (ClassTools.Primitive primitive : ClassTools.PRIMITIVES) {
            if (!Arrays.equals(primitive.wrapperClassName, primitiveWrapperClassName)) continue;
            return primitive.javaClassName;
        }
        return null;
    }

    public static boolean isAutoboxEquivalent(String className1, String className2) {
        return ObjectTools.equals(className1, className2) || ObjectTools.equals(ClassNameTools.primitiveClassName(className1), className2) || ObjectTools.equals(ClassNameTools.primitiveWrapperClassName(className1), className2);
    }

    public static boolean isAutoboxEquivalent(char[] className1, char[] className2) {
        return Arrays.equals(className1, className2) || Arrays.equals(ClassNameTools.primitiveClassName(className1), className2) || Arrays.equals(ClassNameTools.primitiveWrapperClassName(className1), className2);
    }

    public static String forCode(int classCode) {
        return ClassNameTools.forCode((char)classCode);
    }

    public static char[] forCodeCharArray(int classCode) {
        return ClassNameTools.forCodeCharArray((char)classCode);
    }

    public static String forCode(char classCode) {
        Class<?> primitiveClass = ClassTools.primitiveForCode(classCode);
        return primitiveClass == null ? null : primitiveClass.getName();
    }

    public static char[] forCodeCharArray(char classCode) {
        Class<?> primitiveClass = ClassTools.primitiveForCode(classCode);
        return primitiveClass == null ? null : primitiveClass.getName().toCharArray();
    }

    public static char primitiveClassCode(String primitiveClassName) {
        if (!ClassNameTools.isArray(primitiveClassName) && primitiveClassName.length() <= ClassTools.MAX_PRIMITIVE_CLASS_NAME_LENGTH) {
            for (ClassTools.Primitive primitive : ClassTools.PRIMITIVES) {
                if (!primitive.javaClass.getName().equals(primitiveClassName)) continue;
                return primitive.code;
            }
        }
        return '\u0000';
    }

    public static char primitiveClassCode(char[] primitiveClassName) {
        if (!ClassNameTools.isArray(primitiveClassName) && primitiveClassName.length <= ClassTools.MAX_PRIMITIVE_CLASS_NAME_LENGTH) {
            for (ClassTools.Primitive primitive : ClassTools.PRIMITIVES) {
                if (!Arrays.equals(primitive.javaClassName, primitiveClassName)) continue;
                return primitive.code;
            }
        }
        return '\u0000';
    }

    static void appendReferenceNameTo(String className, StringBuilder sb) {
        sb.append('L');
        sb.append(className);
        sb.append(';');
    }

    static void appendReferenceNameTo(char[] className, StringBuilder sb) {
        sb.append('L');
        sb.append(className);
        sb.append(';');
    }

    public static Object newInstance(String className) {
        return ClassNameTools.newInstance(className, null);
    }

    public static Object newInstance(char[] className) {
        return ClassNameTools.newInstance(className, null);
    }

    public static Object newInstance(String className, Class<?> parameterType, Object argument) {
        return ClassNameTools.newInstance(className, parameterType, argument, null);
    }

    public static Object newInstance(char[] className, Class<?> parameterType, Object argument) {
        return ClassNameTools.newInstance(className, parameterType, argument, null);
    }

    public static Object newInstance(String className, Class<?>[] parameterTypes, Object ... arguments) {
        return ClassNameTools.newInstance(className, parameterTypes, arguments, null);
    }

    public static Object newInstance(char[] className, Class<?>[] parameterTypes, Object ... arguments) {
        return ClassNameTools.newInstance(className, parameterTypes, arguments, null);
    }

    public static Object newInstance(String className, ClassLoader classLoader) {
        return ClassTools.newInstance(ClassTools.forName(className, false, classLoader));
    }

    public static Object newInstance(char[] className, ClassLoader classLoader) {
        return ClassTools.newInstance(ClassTools.forName(className, false, classLoader));
    }

    public static Object newInstance(String className, Class<?> parameterType, Object argument, ClassLoader classLoader) {
        return ClassTools.newInstance(ClassTools.forName(className, false, classLoader), parameterType, argument);
    }

    public static Object newInstance(char[] className, Class<?> parameterType, Object argument, ClassLoader classLoader) {
        return ClassTools.newInstance(ClassTools.forName(className, false, classLoader), parameterType, argument);
    }

    public static Object newInstance(String className, Class<?>[] parameterTypes, Object[] arguments, ClassLoader classLoader) {
        return ClassTools.newInstance(ClassTools.forName(className, false, classLoader), parameterTypes, arguments);
    }

    public static Object newInstance(char[] className, Class<?>[] parameterTypes, Object[] arguments, ClassLoader classLoader) {
        return ClassTools.newInstance(ClassTools.forName(className, false, classLoader), parameterTypes, arguments);
    }

    private ClassNameTools() {
        throw new UnsupportedOperationException();
    }
}

