/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility;

import java.util.Vector;
import org.eclipse.persistence.tools.utility.ExceptionHandler;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.collection.CollectionTools;
import org.eclipse.persistence.tools.utility.iterable.SnapshotCloneIterable;

public abstract class AbstractCompositeExceptionHandler<H extends ExceptionHandler>
implements ExceptionHandler {
    private final Vector<H> exceptionHandlers = new Vector();

    protected AbstractCompositeExceptionHandler() {
    }

    protected AbstractCompositeExceptionHandler(H ... exceptionHandlers) {
        CollectionTools.addAll(this.exceptionHandlers, exceptionHandlers);
        this.checkExceptionHandlers();
    }

    protected AbstractCompositeExceptionHandler(Iterable<? extends H> exceptionHandlers) {
        CollectionTools.addAll(this.exceptionHandlers, exceptionHandlers);
        this.checkExceptionHandlers();
    }

    private void checkExceptionHandlers() {
        for (ExceptionHandler exceptionHandler : this.exceptionHandlers) {
            if (exceptionHandler != null) continue;
            throw new NullPointerException();
        }
    }

    @Override
    public void handleException(Throwable t) {
        for (ExceptionHandler handler : this.getExceptionHandlers()) {
            handler.handleException(t);
        }
    }

    public Iterable<H> getExceptionHandlers() {
        return new SnapshotCloneIterable<H>(this.exceptionHandlers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExceptionHandler(H exceptionHandler) {
        if (exceptionHandler == null) {
            throw new NullPointerException();
        }
        Vector<H> vector = this.exceptionHandlers;
        synchronized (vector) {
            if (this.exceptionHandlers.contains(exceptionHandler)) {
                throw new IllegalArgumentException("duplicate handler: " + exceptionHandler);
            }
            this.exceptionHandlers.add(exceptionHandler);
        }
    }

    public void removeExceptionHandler(H exceptionHandler) {
        if (!this.exceptionHandlers.remove(exceptionHandler)) {
            throw new IllegalArgumentException("handler not registered: " + exceptionHandler);
        }
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.exceptionHandlers);
    }
}

