/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.FetchType;
import org.eclipse.persistence.tools.mapping.orm.ExternalDiscriminatorClass;
import org.eclipse.persistence.tools.mapping.orm.ExternalDiscriminatorColumn;
import org.eclipse.persistence.tools.mapping.orm.ExternalJoinColumn;
import org.eclipse.persistence.tools.mapping.orm.ExternalVariableOneToOneMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.DiscriminatorClass;
import org.eclipse.persistence.tools.mapping.orm.dom.DiscriminatorColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.EmbeddableEntity;
import org.eclipse.persistence.tools.mapping.orm.dom.JoinColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.NonTransientMapping;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.iterable.EmptyListIterable;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;
import org.eclipse.persistence.tools.utility.iterable.ListListIterable;
import org.w3c.dom.Element;

final class VariableOneToOneMapping
extends NonTransientMapping
implements ExternalVariableOneToOneMapping {
    private List<String> cascadeTypeIndices;
    static final String CASCADE = "cascade";
    static final String CASCADE_ALL = "cascade-all";
    static final String CASCADE_DETACH = "cascade-detach";
    static final String CASCADE_MERGE = "cascade-merge";
    static final String CASCADE_PERSIST = "cascade-persist";
    static final String CASCADE_REFRESH = "cascade-refresh";
    static final String CASCADE_REMOVE = "cascade-remove";
    static final String FETCH = "fetch";
    static final String OPTIONAL = "optional";
    static final String PRIVATE_OWNED = "private-owned";
    static final String TARGET_INTERFACE = "target-interface";
    static final String VARIABLE_ONE_TO_ONE = "variable-one-to-one";

    VariableOneToOneMapping(EmbeddableEntity parent, int index) {
        super(parent, index);
    }

    @Override
    public void addCascadeType(CascadeType type) {
        Element element = this.getChild(CASCADE);
        if (element == null) {
            element = this.addChild(CASCADE);
        }
        this.addChild(element, this.cascadeType(type), this.cascadeTypeIndices);
    }

    @Override
    public void addDiscriminatorClass(int index, String discrimator, String value) {
        DiscriminatorClass discriminatorClass = this.buildDiscriminatorClass(index);
        discriminatorClass.addSelf();
        discriminatorClass.setDiscriminator(discrimator);
        discriminatorClass.setValue(value);
    }

    @Override
    public void addDiscriminatorColumn() {
        DiscriminatorColumn discriminatorColumn = this.buildDiscriminatorColumn();
        discriminatorColumn.addSelf();
    }

    @Override
    public void addJoinColumn(int index, String name) {
        JoinColumn joinColumn = this.buildJoinColumn(index);
        joinColumn.addSelf();
        joinColumn.setName(name);
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("name");
        names.add(TARGET_INTERFACE);
        names.add(FETCH);
        names.add(OPTIONAL);
        names.add("orphan-removal");
        return names;
    }

    private List<String> buildCascadeTypeIndices() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(CASCADE_ALL);
        names.add(CASCADE_PERSIST);
        names.add(CASCADE_MERGE);
        names.add(CASCADE_REMOVE);
        names.add(CASCADE_REFRESH);
        names.add(CASCADE_DETACH);
        return names;
    }

    private DiscriminatorClass buildDiscriminatorClass(int index) {
        return new DiscriminatorClass(this, index);
    }

    private DiscriminatorColumn buildDiscriminatorColumn() {
        return new DiscriminatorColumn(this);
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(CASCADE);
        names.add("discriminator-column");
        names.add("discriminator-class");
        names.add("join-column");
        names.add(PRIVATE_OWNED);
        names.add("property");
        names.add("access-methods");
        return names;
    }

    private JoinColumn buildJoinColumn(int index) {
        return new JoinColumn(this, index);
    }

    private String cascadeType(CascadeType type) {
        switch (type) {
            case ALL: {
                return CASCADE_ALL;
            }
            case DETACH: {
                return CASCADE_DETACH;
            }
            case MERGE: {
                return CASCADE_MERGE;
            }
            case PERSIST: {
                return CASCADE_PERSIST;
            }
            case REFRESH: {
                return CASCADE_REFRESH;
            }
            case REMOVE: {
                return CASCADE_REMOVE;
            }
        }
        return null;
    }

    private CascadeType cascadeType(Element element) {
        String elementName = this.getNodeName(element);
        if (ObjectTools.equals((Object)elementName, (Object)CASCADE_ALL)) {
            return CascadeType.ALL;
        }
        if (ObjectTools.equals((Object)elementName, (Object)CASCADE_MERGE)) {
            return CascadeType.MERGE;
        }
        if (ObjectTools.equals((Object)elementName, (Object)CASCADE_DETACH)) {
            return CascadeType.DETACH;
        }
        if (ObjectTools.equals((Object)elementName, (Object)CASCADE_PERSIST)) {
            return CascadeType.PERSIST;
        }
        if (ObjectTools.equals((Object)elementName, (Object)CASCADE_REFRESH)) {
            return CascadeType.REFRESH;
        }
        if (ObjectTools.equals((Object)elementName, (Object)CASCADE_REMOVE)) {
            return CascadeType.REMOVE;
        }
        return null;
    }

    @Override
    public ListIterable<CascadeType> cascadeTypes() {
        Element element = this.getChild(CASCADE);
        if (element == null) {
            return EmptyListIterable.instance();
        }
        List<Element> children = this.getChildren(element);
        ArrayList<CascadeType> cascadeTypes = new ArrayList<CascadeType>(children.size());
        for (Element childElement : children) {
            CascadeType cascadeType = this.cascadeType(childElement);
            if (cascadeType == null) continue;
            cascadeTypes.add(cascadeType);
        }
        return new ListListIterable(cascadeTypes);
    }

    @Override
    public ListIterable<ExternalDiscriminatorClass> discriminatorClasses() {
        int count = this.discriminatorClassesSize();
        ArrayList<DiscriminatorClass> discriminatorClasses = new ArrayList<DiscriminatorClass>(count);
        int index = count;
        while (--index >= 0) {
            DiscriminatorClass discriminatorClass = this.buildDiscriminatorClass(index);
            discriminatorClasses.add(0, discriminatorClass);
        }
        return new ListListIterable(discriminatorClasses);
    }

    @Override
    public int discriminatorClassesSize() {
        return this.getChildrenSize("discriminator-class");
    }

    @Override
    public ExternalDiscriminatorClass getDiscriminatorClass(String value, String discriminator) {
        int count;
        int index = count = this.discriminatorClassesSize();
        while (--index >= 0) {
            DiscriminatorClass discriminatorClass = this.buildDiscriminatorClass(index);
            if (!ObjectTools.equals((Object)discriminator, (Object)discriminatorClass.getDiscriminator()) || !ObjectTools.equals((Object)value, (Object)discriminatorClass.getValue())) continue;
            return discriminatorClass;
        }
        return null;
    }

    @Override
    public ExternalDiscriminatorColumn getDiscriminatorColumn() {
        if (this.hasChild("discriminator-column")) {
            return this.buildDiscriminatorColumn();
        }
        return null;
    }

    @Override
    protected String getElementName() {
        return VARIABLE_ONE_TO_ONE;
    }

    @Override
    public FetchType getFetchType() {
        return this.getEnumAttribute(FETCH, FetchType.class);
    }

    @Override
    public ExternalJoinColumn getJoinColumn(int index) {
        Element element = this.getChild("join-column", index);
        if (element == null) {
            return null;
        }
        return this.buildJoinColumn(index);
    }

    @Override
    public String getTargetInterfaceName() {
        return this.getAttribute(TARGET_INTERFACE);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.cascadeTypeIndices = this.buildCascadeTypeIndices();
    }

    @Override
    public Boolean isOptional() {
        return this.getBooleanAttribute(OPTIONAL);
    }

    @Override
    public Boolean isOrphanRemoval() {
        return this.getBooleanAttribute("orphan-removal");
    }

    @Override
    public Boolean isPrivateOwned() {
        return this.hasChild(PRIVATE_OWNED);
    }

    @Override
    public ListIterable<ExternalJoinColumn> joinColumns() {
        int count = this.joinColumnsSize();
        ArrayList<JoinColumn> joinColumns = new ArrayList<JoinColumn>(count);
        int index = count;
        while (--index >= 0) {
            JoinColumn joinColumn = this.buildJoinColumn(index);
            joinColumns.add(0, joinColumn);
        }
        return new ListListIterable(joinColumns);
    }

    @Override
    public int joinColumnsSize() {
        return this.getChildrenSize("join-column");
    }

    @Override
    public void removeCascadeType(CascadeType type) {
        Element element = this.getChild(CASCADE);
        if (element != null) {
            this.removeChild(element, this.cascadeType(type));
            if (!this.hasAnyChildren(element)) {
                this.remove(element);
            }
        }
    }

    @Override
    public void removeDiscriminatorClass(int index) {
        DiscriminatorClass discClass = this.buildDiscriminatorClass(index);
        discClass.removeSelf();
    }

    @Override
    public void removeDiscriminatorColumn() {
        DiscriminatorColumn column = this.buildDiscriminatorColumn();
        column.removeSelf();
    }

    @Override
    public void removeJoinColumn(int index) {
        JoinColumn joinColumn = this.buildJoinColumn(index);
        joinColumn.removeSelf();
    }

    @Override
    public void setFetchType(FetchType type) {
        this.setAttribute(FETCH, (Enum<?>)type);
    }

    @Override
    public void setOptional(Boolean optional) {
        this.setAttribute(OPTIONAL, optional);
    }

    @Override
    public void setOrphanRemoval(Boolean value) {
        this.setAttribute("orphan-removal", value);
    }

    @Override
    public void setPrivateOwned(Boolean privateOwned) {
        if (privateOwned == Boolean.TRUE) {
            this.addChild(PRIVATE_OWNED);
        } else {
            this.removeChild(PRIVATE_OWNED);
        }
    }

    @Override
    public void setTargetInterfaceName(String entityName) {
        this.setAttribute(TARGET_INTERFACE, entityName);
    }
}

