/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.orm.ExternalBasicColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.AbstractExternalForm;
import org.w3c.dom.Element;

abstract class AbstractColumn
extends AbstractExternalForm
implements ExternalBasicColumn {
    static final String COLUMN_DEFINITION = "column-definition";
    static final String INSERTABLE = "insertable";
    static final String LENGTH = "length";
    static final String NAME = "name";
    static final String NULLABLE = "nullable";
    static final String PRECISION = "precision";
    static final String SCALE = "scale";
    static final String TABLE = "table";
    static final String UNIQUE = "unique";
    static final String UPDATABLE = "updatable";

    AbstractColumn(AbstractExternalForm parent) {
        super(parent);
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(NAME);
        names.add(UNIQUE);
        names.add(NULLABLE);
        names.add(INSERTABLE);
        names.add(UPDATABLE);
        names.add(COLUMN_DEFINITION);
        names.add(TABLE);
        names.add(LENGTH);
        names.add(PRECISION);
        names.add(SCALE);
        return names;
    }

    @Override
    public final String getColumnDefinition() {
        return this.getAttribute(COLUMN_DEFINITION);
    }

    @Override
    public Element getElement() {
        return this.getChild(this.getParent(), this.getElementName());
    }

    @Override
    public final String getName() {
        return this.getAttribute(NAME);
    }

    @Override
    public final String getTable() {
        return this.getAttribute(TABLE);
    }

    @Override
    public final Boolean isInstertable() {
        return this.getBooleanAttribute(INSERTABLE);
    }

    @Override
    public final Boolean isNullable() {
        return this.getBooleanAttribute(NULLABLE);
    }

    @Override
    public final Boolean isUnique() {
        return this.getBooleanAttribute(UNIQUE);
    }

    @Override
    public final Boolean isUpdatable() {
        return this.getBooleanAttribute(UPDATABLE);
    }

    @Override
    public final void setColumnDefinition(String columnDefinition) {
        this.setAttribute(COLUMN_DEFINITION, columnDefinition);
        if (this.shouldRemoveEmptyElement() && !this.hasAnyChildren() && !this.hasAttributes()) {
            this.removeSelf();
        }
    }

    @Override
    public final void setInsertable(Boolean insertable) {
        this.setAttribute(INSERTABLE, insertable);
        if (this.shouldRemoveEmptyElement() && !this.hasAnyChildren() && !this.hasAttributes()) {
            this.removeSelf();
        }
    }

    @Override
    public final void setName(String name) {
        this.setAttribute(NAME, name);
        if (this.shouldRemoveEmptyElement() && !this.hasAnyChildren() && !this.hasAttributes()) {
            this.removeSelf();
        }
    }

    @Override
    public final void setNullable(Boolean nullable) {
        this.setAttribute(NULLABLE, nullable);
        if (this.shouldRemoveEmptyElement() && !this.hasAnyChildren() && !this.hasAttributes()) {
            this.removeSelf();
        }
    }

    @Override
    public final void setTable(String table) {
        this.setAttribute(TABLE, table);
        if (this.shouldRemoveEmptyElement() && !this.hasAnyChildren() && !this.hasAttributes()) {
            this.removeSelf();
        }
    }

    @Override
    public final void setUnique(Boolean unique) {
        this.setAttribute(UNIQUE, unique);
        if (this.shouldRemoveEmptyElement() && !this.hasAnyChildren() && !this.hasAttributes()) {
            this.removeSelf();
        }
    }

    @Override
    public final void setUpdatable(Boolean updatable) {
        this.setAttribute(UPDATABLE, updatable);
        if (this.shouldRemoveEmptyElement() && !this.hasAnyChildren() && !this.hasAttributes()) {
            this.removeSelf();
        }
    }

    boolean shouldRemoveEmptyElement() {
        return false;
    }
}

