/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests.model.value.swing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.ListModel;
import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.model.event.PropertyChangeEvent;
import org.eclipse.persistence.tools.utility.model.listener.PropertyChangeListener;
import org.eclipse.persistence.tools.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.persistence.tools.utility.model.value.SimpleListValueModel;
import org.eclipse.persistence.tools.utility.model.value.SimplePropertyValueModel;
import org.eclipse.persistence.tools.utility.model.value.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.utility.tests.model.Displayable;
import org.eclipse.persistence.tools.utility.tests.model.SimpleDisplayable;
import org.eclipse.persistence.tools.utility.tests.model.value.CoordinatedList;

public class ComboBoxModelAdapterTests
extends TestCase {
    public ComboBoxModelAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testHasListeners() throws Exception {
        SimpleListValueModel<Displayable> listHolder = this.buildListHolder();
        ComboBoxModelAdapterTests.assertFalse((boolean)listHolder.hasAnyListChangeListeners("list values"));
        SimplePropertyValueModel selectionHolder = new SimplePropertyValueModel(listHolder.iterator().next());
        ComboBoxModelAdapterTests.assertFalse((boolean)selectionHolder.hasAnyPropertyChangeListeners("value"));
        ComboBoxModelAdapter comboBoxModel = new ComboBoxModelAdapter(listHolder, (ModifiablePropertyValueModel)selectionHolder);
        ComboBoxModelAdapterTests.assertFalse((boolean)listHolder.hasAnyListChangeListeners("list values"));
        ComboBoxModelAdapterTests.assertFalse((boolean)selectionHolder.hasAnyPropertyChangeListeners("value"));
        this.verifyHasNoListeners((ListModel)comboBoxModel);
        CoordinatedList synchList = new CoordinatedList((ListModel)comboBoxModel);
        PropertyChangeListener selectionListener = this.buildSelectionListener();
        selectionHolder.addPropertyChangeListener("value", selectionListener);
        ComboBoxModelAdapterTests.assertTrue((boolean)listHolder.hasAnyListChangeListeners("list values"));
        ComboBoxModelAdapterTests.assertTrue((boolean)selectionHolder.hasAnyPropertyChangeListeners("value"));
        this.verifyHasListeners((ListModel)comboBoxModel);
        comboBoxModel.removeListDataListener(synchList);
        selectionHolder.removePropertyChangeListener("value", selectionListener);
        ComboBoxModelAdapterTests.assertFalse((boolean)listHolder.hasAnyListChangeListeners("list values"));
        ComboBoxModelAdapterTests.assertFalse((boolean)selectionHolder.hasAnyPropertyChangeListeners("value"));
        this.verifyHasNoListeners((ListModel)comboBoxModel);
    }

    private PropertyChangeListener buildSelectionListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent evt) {
            }
        };
    }

    private void verifyHasNoListeners(ListModel listModel) throws Exception {
        boolean hasNoListeners = (Boolean)ObjectTools.execute((Object)listModel, (String)"hasNoListDataListeners");
        ComboBoxModelAdapterTests.assertTrue((boolean)hasNoListeners);
    }

    private void verifyHasListeners(ListModel listModel) throws Exception {
        boolean hasListeners = (Boolean)ObjectTools.execute((Object)listModel, (String)"hasListDataListeners");
        ComboBoxModelAdapterTests.assertTrue((boolean)hasListeners);
    }

    private SimpleListValueModel<Displayable> buildListHolder() {
        return new SimpleListValueModel(this.buildList());
    }

    private List<Displayable> buildList() {
        ArrayList<Displayable> list = new ArrayList<Displayable>();
        this.populateCollection(list);
        return list;
    }

    private void populateCollection(Collection<Displayable> c) {
        c.add(new SimpleDisplayable("foo"));
        c.add(new SimpleDisplayable("bar"));
        c.add(new SimpleDisplayable("baz"));
        c.add(new SimpleDisplayable("joo"));
        c.add(new SimpleDisplayable("jar"));
        c.add(new SimpleDisplayable("jaz"));
    }
}

