/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests.model.value;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.collection.Bag;
import org.eclipse.persistence.tools.utility.collection.CollectionTools;
import org.eclipse.persistence.tools.utility.collection.HashBag;
import org.eclipse.persistence.tools.utility.iterator.IteratorTools;
import org.eclipse.persistence.tools.utility.model.event.CollectionAddEvent;
import org.eclipse.persistence.tools.utility.model.event.CollectionChangeEvent;
import org.eclipse.persistence.tools.utility.model.event.CollectionClearEvent;
import org.eclipse.persistence.tools.utility.model.event.CollectionEvent;
import org.eclipse.persistence.tools.utility.model.event.CollectionRemoveEvent;
import org.eclipse.persistence.tools.utility.model.listener.ChangeAdapter;
import org.eclipse.persistence.tools.utility.model.listener.ChangeListener;
import org.eclipse.persistence.tools.utility.model.listener.CollectionChangeListener;
import org.eclipse.persistence.tools.utility.model.value.SimpleCollectionValueModel;
import org.eclipse.persistence.tools.utility.tests.TestTools;

public class SimpleCollectionValueModelTests
extends TestCase {
    private SimpleCollectionValueModel<String> bagHolder;
    CollectionEvent bagEvent;
    String bagEventType;
    private SimpleCollectionValueModel<String> setHolder;
    CollectionEvent setEvent;
    String setEventType;
    private static final String ADD = "add";
    private static final String REMOVE = "remove";
    private static final String CHANGE = "change";
    private static final String CLEAR = "clear";

    public SimpleCollectionValueModelTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.bagHolder = new SimpleCollectionValueModel(this.buildBag());
        this.setHolder = new SimpleCollectionValueModel(this.buildSet());
    }

    private Bag<String> buildBag() {
        HashBag result = new HashBag();
        this.addItemsTo((Collection<String>)result);
        return result;
    }

    private Set<String> buildSet() {
        HashSet<String> result = new HashSet<String>();
        this.addItemsTo(result);
        return result;
    }

    private void addItemsTo(Collection<String> c) {
        c.add("foo");
        c.add("bar");
        c.add("baz");
    }

    private Bag<String> buildAddItems() {
        HashBag result = new HashBag();
        result.add((Object)"joo");
        result.add((Object)"jar");
        result.add((Object)"jaz");
        return result;
    }

    private Bag<String> buildRemoveItems() {
        HashBag result = new HashBag();
        result.add((Object)"foo");
        result.add((Object)"baz");
        return result;
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testIterator() {
        SimpleCollectionValueModelTests.assertEquals(this.buildBag(), (Object)CollectionTools.bag((Iterator)this.bagHolder.iterator()));
        SimpleCollectionValueModelTests.assertEquals(this.buildSet(), (Object)CollectionTools.set((Iterator)this.setHolder.iterator()));
    }

    public void testSize() {
        SimpleCollectionValueModelTests.assertEquals((int)this.buildBag().size(), (int)IteratorTools.size((Iterator)this.bagHolder.iterator()));
        SimpleCollectionValueModelTests.assertEquals((int)this.buildSet().size(), (int)IteratorTools.size((Iterator)this.setHolder.iterator()));
    }

    private boolean bagHolderContains(Object item) {
        return IteratorTools.contains((Iterator)this.bagHolder.iterator(), (Object)item);
    }

    private boolean setHolderContains(Object item) {
        return IteratorTools.contains((Iterator)this.setHolder.iterator(), (Object)item);
    }

    private boolean bagHolderContainsAll(Collection<String> items) {
        return IteratorTools.containsAll((Iterator)this.bagHolder.iterator(), items);
    }

    private boolean setHolderContainsAll(Collection<String> items) {
        return IteratorTools.containsAll((Iterator)this.setHolder.iterator(), items);
    }

    private boolean bagHolderContainsAny(Collection<String> items) {
        HashBag bag = CollectionTools.bag((Iterator)this.bagHolder.iterator());
        for (String string : items) {
            if (!bag.contains((Object)string)) continue;
            return true;
        }
        return false;
    }

    private boolean setHolderContainsAny(Collection<String> items) {
        HashSet set = CollectionTools.set((Iterator)this.setHolder.iterator());
        for (String string : items) {
            if (!set.contains(string)) continue;
            return true;
        }
        return false;
    }

    public void testAdd() {
        SimpleCollectionValueModelTests.assertFalse((boolean)this.bagHolderContains("joo"));
        this.bagHolder.add((Object)"joo");
        SimpleCollectionValueModelTests.assertTrue((boolean)this.bagHolderContains("joo"));
        SimpleCollectionValueModelTests.assertFalse((boolean)this.bagHolderContains(null));
        this.bagHolder.add(null);
        SimpleCollectionValueModelTests.assertTrue((boolean)this.bagHolderContains(null));
        SimpleCollectionValueModelTests.assertFalse((boolean)this.setHolderContains("joo"));
        this.setHolder.add((Object)"joo");
        SimpleCollectionValueModelTests.assertTrue((boolean)this.setHolderContains("joo"));
        SimpleCollectionValueModelTests.assertFalse((boolean)this.setHolderContains(null));
        this.setHolder.add(null);
        SimpleCollectionValueModelTests.assertTrue((boolean)this.setHolderContains(null));
    }

    public void testAddAll() {
        SimpleCollectionValueModelTests.assertFalse((boolean)this.bagHolderContainsAny((Collection<String>)this.buildAddItems()));
        this.bagHolder.addAll(this.buildAddItems());
        SimpleCollectionValueModelTests.assertTrue((boolean)this.bagHolderContainsAll((Collection<String>)this.buildAddItems()));
        SimpleCollectionValueModelTests.assertFalse((boolean)this.setHolderContainsAny((Collection<String>)this.buildAddItems()));
        this.setHolder.addAll(this.buildAddItems());
        SimpleCollectionValueModelTests.assertTrue((boolean)this.setHolderContainsAll((Collection<String>)this.buildAddItems()));
    }

    public void testRemove() {
        SimpleCollectionValueModelTests.assertTrue((boolean)this.bagHolderContains("bar"));
        this.bagHolder.remove((Object)"bar");
        SimpleCollectionValueModelTests.assertFalse((boolean)this.bagHolderContains("bar"));
        this.bagHolder.add(null);
        SimpleCollectionValueModelTests.assertTrue((boolean)this.bagHolderContains(null));
        this.bagHolder.remove(null);
        SimpleCollectionValueModelTests.assertFalse((boolean)this.bagHolderContains(null));
        SimpleCollectionValueModelTests.assertTrue((boolean)this.setHolderContains("bar"));
        this.setHolder.remove((Object)"bar");
        SimpleCollectionValueModelTests.assertFalse((boolean)this.setHolderContains("bar"));
        this.setHolder.add(null);
        SimpleCollectionValueModelTests.assertTrue((boolean)this.setHolderContains(null));
        this.setHolder.remove(null);
        SimpleCollectionValueModelTests.assertFalse((boolean)this.setHolderContains(null));
    }

    public void testRemoveAll() {
        SimpleCollectionValueModelTests.assertTrue((boolean)this.bagHolderContainsAll((Collection<String>)this.buildRemoveItems()));
        this.bagHolder.removeAll(this.buildRemoveItems());
        SimpleCollectionValueModelTests.assertFalse((boolean)this.bagHolderContainsAny((Collection<String>)this.buildRemoveItems()));
        SimpleCollectionValueModelTests.assertTrue((boolean)this.setHolderContainsAll((Collection<String>)this.buildRemoveItems()));
        this.setHolder.removeAll(this.buildRemoveItems());
        SimpleCollectionValueModelTests.assertFalse((boolean)this.setHolderContainsAny((Collection<String>)this.buildRemoveItems()));
    }

    public void testSetValues() {
        SimpleCollectionValueModelTests.assertTrue((boolean)this.bagHolderContains("bar"));
        SimpleCollectionValueModelTests.assertFalse((boolean)this.bagHolderContains("jar"));
        this.bagHolder.setValues(this.buildAddItems());
        SimpleCollectionValueModelTests.assertFalse((boolean)this.bagHolderContains("bar"));
        SimpleCollectionValueModelTests.assertTrue((boolean)this.bagHolderContains("jar"));
        this.bagHolder.add(null);
        SimpleCollectionValueModelTests.assertTrue((boolean)this.bagHolderContains(null));
        this.bagHolder.remove(null);
        SimpleCollectionValueModelTests.assertFalse((boolean)this.bagHolderContains(null));
        this.bagHolder.setValues((Iterable)new HashBag());
        SimpleCollectionValueModelTests.assertFalse((boolean)this.bagHolderContains("jar"));
        SimpleCollectionValueModelTests.assertTrue((boolean)this.setHolderContains("bar"));
        SimpleCollectionValueModelTests.assertFalse((boolean)this.setHolderContains("jar"));
        this.setHolder.setValues(this.buildAddItems());
        SimpleCollectionValueModelTests.assertFalse((boolean)this.setHolderContains("bar"));
        SimpleCollectionValueModelTests.assertTrue((boolean)this.setHolderContains("jar"));
        this.setHolder.add(null);
        SimpleCollectionValueModelTests.assertTrue((boolean)this.setHolderContains(null));
        this.setHolder.remove(null);
        SimpleCollectionValueModelTests.assertFalse((boolean)this.setHolderContains(null));
        this.setHolder.setValues((Iterable)new HashBag());
        SimpleCollectionValueModelTests.assertFalse((boolean)this.setHolderContains("jar"));
    }

    public void testCollectionChange1() {
        this.bagHolder.addChangeListener(this.buildBagListener());
        this.verifyBagChange();
        this.setHolder.addChangeListener(this.buildSetListener());
        this.verifySetChange();
    }

    public void testCollectionChange2() {
        this.bagHolder.addCollectionChangeListener("values", (CollectionChangeListener)this.buildBagListener());
        this.verifyBagChange();
        this.setHolder.addCollectionChangeListener("values", (CollectionChangeListener)this.buildSetListener());
        this.verifySetChange();
    }

    private void verifyBagChange() {
        this.bagEvent = null;
        this.bagEventType = null;
        this.bagHolder.add((Object)"foo");
        this.verifyBagEvent(ADD, "foo");
        this.bagEvent = null;
        this.bagEventType = null;
        this.bagHolder.add((Object)"foo");
        this.verifyBagEvent(ADD, "foo");
        this.bagEvent = null;
        this.bagEventType = null;
        this.bagHolder.add((Object)"joo");
        this.verifyBagEvent(ADD, "joo");
        this.bagEvent = null;
        this.bagEventType = null;
        this.bagHolder.add(null);
        this.verifyBagEvent(ADD, null);
        this.bagEvent = null;
        this.bagEventType = null;
        this.bagHolder.add(null);
        this.verifyBagEvent(ADD, null);
        this.bagEvent = null;
        this.bagEventType = null;
        this.bagHolder.remove((Object)"joo");
        this.verifyBagEvent(REMOVE, "joo");
        this.bagEvent = null;
        this.bagEventType = null;
        this.bagHolder.remove(null);
        this.verifyBagEvent(REMOVE, null);
        this.bagEvent = null;
        this.bagEventType = null;
        this.bagHolder.setValues(this.buildBag());
        this.verifyBagEvent(CHANGE);
        this.bagEvent = null;
        this.bagEventType = null;
        this.bagHolder.addAll(this.buildBag());
        this.verifyBagEvent(ADD);
        SimpleCollectionValueModelTests.assertEquals(this.buildBag(), (Object)CollectionTools.bag((Iterable)((CollectionAddEvent)this.bagEvent).getItems()));
    }

    private void verifySetChange() {
        this.setEvent = null;
        this.setEventType = null;
        this.setHolder.add((Object)"foo");
        SimpleCollectionValueModelTests.assertNull((Object)this.setEvent);
        SimpleCollectionValueModelTests.assertNull((Object)this.setEventType);
        this.setEvent = null;
        this.setEventType = null;
        this.setHolder.add((Object)"joo");
        this.verifySetEvent(ADD, "joo");
        this.setEvent = null;
        this.setEventType = null;
        this.setHolder.add((Object)"joo");
        SimpleCollectionValueModelTests.assertNull((Object)this.setEvent);
        SimpleCollectionValueModelTests.assertNull((Object)this.setEventType);
        this.setEvent = null;
        this.setEventType = null;
        this.setHolder.add(null);
        this.verifySetEvent(ADD, null);
        this.setEvent = null;
        this.setEventType = null;
        this.setHolder.add(null);
        SimpleCollectionValueModelTests.assertNull((Object)this.setEvent);
        SimpleCollectionValueModelTests.assertNull((Object)this.setEventType);
        this.setEvent = null;
        this.setEventType = null;
        this.setHolder.remove((Object)"joo");
        this.verifySetEvent(REMOVE, "joo");
        this.setEvent = null;
        this.setEventType = null;
        this.setHolder.remove((Object)"joo");
        SimpleCollectionValueModelTests.assertNull((Object)this.setEvent);
        SimpleCollectionValueModelTests.assertNull((Object)this.setEventType);
        this.setEvent = null;
        this.setEventType = null;
        this.setHolder.remove(null);
        this.verifySetEvent(REMOVE, null);
        this.setEvent = null;
        this.setEventType = null;
        this.setHolder.setValues(this.buildSet());
        this.verifySetEvent(CHANGE);
        this.setEvent = null;
        this.setEventType = null;
        this.setHolder.addAll(this.buildSet());
        SimpleCollectionValueModelTests.assertNull((Object)this.setEvent);
        SimpleCollectionValueModelTests.assertNull((Object)this.setEventType);
    }

    private ChangeListener buildBagListener() {
        return new ChangeAdapter(){

            public void itemsAdded(CollectionAddEvent e) {
                SimpleCollectionValueModelTests.this.bagEventType = SimpleCollectionValueModelTests.ADD;
                SimpleCollectionValueModelTests.this.bagEvent = e;
            }

            public void itemsRemoved(CollectionRemoveEvent e) {
                SimpleCollectionValueModelTests.this.bagEventType = SimpleCollectionValueModelTests.REMOVE;
                SimpleCollectionValueModelTests.this.bagEvent = e;
            }

            public void collectionCleared(CollectionClearEvent e) {
                SimpleCollectionValueModelTests.this.bagEventType = SimpleCollectionValueModelTests.CLEAR;
                SimpleCollectionValueModelTests.this.bagEvent = e;
            }

            public void collectionChanged(CollectionChangeEvent e) {
                SimpleCollectionValueModelTests.this.bagEventType = SimpleCollectionValueModelTests.CHANGE;
                SimpleCollectionValueModelTests.this.bagEvent = e;
            }
        };
    }

    private ChangeListener buildSetListener() {
        return new ChangeAdapter(){

            public void itemsAdded(CollectionAddEvent e) {
                SimpleCollectionValueModelTests.this.setEventType = SimpleCollectionValueModelTests.ADD;
                SimpleCollectionValueModelTests.this.setEvent = e;
            }

            public void itemsRemoved(CollectionRemoveEvent e) {
                SimpleCollectionValueModelTests.this.setEventType = SimpleCollectionValueModelTests.REMOVE;
                SimpleCollectionValueModelTests.this.setEvent = e;
            }

            public void collectionCleared(CollectionClearEvent e) {
                SimpleCollectionValueModelTests.this.setEventType = SimpleCollectionValueModelTests.CLEAR;
                SimpleCollectionValueModelTests.this.setEvent = e;
            }

            public void collectionChanged(CollectionChangeEvent e) {
                SimpleCollectionValueModelTests.this.setEventType = SimpleCollectionValueModelTests.CHANGE;
                SimpleCollectionValueModelTests.this.setEvent = e;
            }
        };
    }

    private void verifyBagEvent(String eventType) {
        SimpleCollectionValueModelTests.assertEquals((String)eventType, (String)this.bagEventType);
        SimpleCollectionValueModelTests.assertEquals(this.bagHolder, (Object)this.bagEvent.getSource());
        SimpleCollectionValueModelTests.assertEquals((String)"values", (String)this.bagEvent.getCollectionName());
    }

    private void verifyBagEvent(String eventType, Object item) {
        this.verifyBagEvent(eventType);
        SimpleCollectionValueModelTests.assertEquals((Object)item, this.getBagEventItems().iterator().next());
    }

    private Iterable<?> getBagEventItems() {
        if (this.bagEvent instanceof CollectionAddEvent) {
            return ((CollectionAddEvent)this.bagEvent).getItems();
        }
        if (this.bagEvent instanceof CollectionRemoveEvent) {
            return ((CollectionRemoveEvent)this.bagEvent).getItems();
        }
        throw new IllegalStateException();
    }

    private void verifySetEvent(String eventType) {
        SimpleCollectionValueModelTests.assertEquals((String)eventType, (String)this.setEventType);
        SimpleCollectionValueModelTests.assertEquals(this.setHolder, (Object)this.setEvent.getSource());
        SimpleCollectionValueModelTests.assertEquals((String)"values", (String)this.setEvent.getCollectionName());
    }

    private void verifySetEvent(String eventType, Object item) {
        this.verifySetEvent(eventType);
        SimpleCollectionValueModelTests.assertEquals((Object)item, this.getSetEventItems().iterator().next());
    }

    private Iterable<?> getSetEventItems() {
        if (this.setEvent instanceof CollectionAddEvent) {
            return ((CollectionAddEvent)this.setEvent).getItems();
        }
        if (this.setEvent instanceof CollectionRemoveEvent) {
            return ((CollectionRemoveEvent)this.setEvent).getItems();
        }
        throw new IllegalStateException();
    }
}

