/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests.filter;

import java.io.Serializable;
import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.filter.Filter;
import org.eclipse.persistence.tools.utility.filter.FilterAdapter;
import org.eclipse.persistence.tools.utility.filter.NOTFilter;
import org.eclipse.persistence.tools.utility.tests.TestTools;

public class NOTFilterTests
extends TestCase {
    private NOTFilter<Number> notFilter;

    public NOTFilterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.notFilter = new NOTFilter(this.buildPositiveFilter());
    }

    private Filter<Number> buildPositiveFilter() {
        return new PositiveFilter();
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testFiltering() {
        NOTFilterTests.assertTrue((boolean)this.notFilter.accept((Object)new Integer(0)));
        NOTFilterTests.assertTrue((boolean)this.notFilter.accept((Object)new Integer(-1)));
        NOTFilterTests.assertTrue((boolean)this.notFilter.accept((Object)new Double(-0.001)));
        NOTFilterTests.assertFalse((boolean)this.notFilter.accept((Object)new Double(1.0)));
        NOTFilterTests.assertFalse((boolean)this.notFilter.accept((Object)new Double(11.0)));
        NOTFilterTests.assertFalse((boolean)this.notFilter.accept((Object)new Double(111.0)));
    }

    public void testClone() {
        NOTFilter notFilter2 = (NOTFilter)this.notFilter.clone();
        NOTFilterTests.assertEquals((Object)this.notFilter.getFilter(), (Object)notFilter2.getFilter());
        NOTFilterTests.assertNotSame(this.notFilter, (Object)notFilter2);
    }

    public void testEquals() {
        NOTFilter notFilter2 = new NOTFilter(this.buildPositiveFilter());
        NOTFilterTests.assertEquals(this.notFilter, (Object)notFilter2);
        NOTFilterTests.assertEquals((int)this.notFilter.hashCode(), (int)notFilter2.hashCode());
    }

    public void testSerialization() throws Exception {
        NOTFilter<Number> notFilter2 = TestTools.serialize(this.notFilter);
        NOTFilterTests.assertEquals((Object)this.notFilter.getFilter(), (Object)notFilter2.getFilter());
        NOTFilterTests.assertNotSame(this.notFilter, notFilter2);
    }

    static class PositiveFilter
    extends FilterAdapter<Number>
    implements Serializable {
        private static final long serialVersionUID = 1L;

        PositiveFilter() {
        }

        public boolean accept(Number number) {
            return number.doubleValue() > 0.0;
        }

        public boolean equals(Object obj) {
            return this.getClass() == obj.getClass();
        }

        public int hashCode() {
            return 789;
        }
    }
}

