/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.ReverseComparator;
import org.eclipse.persistence.tools.utility.tests.TestTools;

public class ReverseComparatorTests
extends TestCase {
    private Comparator<String> naturalReverseComparator;
    private Comparator<String> customComparator;
    private Comparator<String> customReverseComparator;

    public ReverseComparatorTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.naturalReverseComparator = new ReverseComparator();
        this.customComparator = this.buildCustomComparator();
        this.customReverseComparator = new ReverseComparator(this.customComparator);
    }

    private Comparator<String> buildCustomComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                String lower2;
                String lower1 = s1.toLowerCase();
                int result = lower1.compareTo(lower2 = s2.toLowerCase());
                if (result == 0) {
                    return s1.compareTo(s2);
                }
                return result;
            }
        };
    }

    private List<String> buildUnsortedList() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("T");
        result.add("Z");
        result.add("Y");
        result.add("M");
        result.add("m");
        result.add("a");
        result.add("B");
        result.add("b");
        result.add("A");
        return result;
    }

    private List<String> buildNaturallySortedList() {
        ArrayList<String> result = new ArrayList<String>(this.buildUnsortedList());
        Collections.sort(result);
        return result;
    }

    private List<String> buildCustomSortedList() {
        ArrayList<String> result = new ArrayList<String>(this.buildUnsortedList());
        Collections.sort(result, this.customComparator);
        return result;
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testNatural() {
        List<String> list = this.buildUnsortedList();
        Collections.sort(list, this.naturalReverseComparator);
        this.verifyList(this.buildNaturallySortedList(), list);
    }

    public void testCustom() {
        List<String> list = this.buildUnsortedList();
        Collections.sort(list, this.customReverseComparator);
        this.verifyList(this.buildCustomSortedList(), list);
    }

    public void testCustom_nonComparable() {
        List<Foo> list = this.buildUnsortedFooList();
        Collections.sort(list, new ReverseComparator(Foo.COMPARATOR));
        this.verifyList(this.buildSortedFooList(), list);
    }

    private List<Foo> buildUnsortedFooList() {
        ArrayList<Foo> result = new ArrayList<Foo>();
        result.add(new Foo("T"));
        result.add(new Foo("Z"));
        result.add(new Foo("Y"));
        result.add(new Foo("M"));
        result.add(new Foo("m"));
        result.add(new Foo("a"));
        result.add(new Foo("B"));
        result.add(new Foo("b"));
        result.add(new Foo("A"));
        return result;
    }

    private List<Foo> buildSortedFooList() {
        ArrayList<Foo> result = new ArrayList<Foo>(this.buildUnsortedFooList());
        Collections.sort(result, Foo.COMPARATOR);
        return result;
    }

    private <T> void verifyList(List<T> normal, List<T> reverse) {
        int size = normal.size();
        int max = size - 1;
        int i = 0;
        while (i < size) {
            ReverseComparatorTests.assertEquals(normal.get(i), reverse.get(max - i));
            ++i;
        }
    }

    public static class Foo {
        public final String string;
        public static final Comparator<Foo> COMPARATOR = new FooComparator();

        public Foo(String string) {
            this.string = string;
        }

        public boolean equals(Object o) {
            return o instanceof Foo && this.string.equals(((Foo)o).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public String toString() {
            return ObjectTools.toString((Object)this, (String)this.string);
        }

        public static class FooComparator
        implements Comparator<Foo> {
            @Override
            public int compare(Foo foo1, Foo foo2) {
                String lower2;
                String s1 = foo1.string;
                String s2 = foo2.string;
                String lower1 = s1.toLowerCase();
                int result = lower1.compareTo(lower2 = s2.toLowerCase());
                if (result == 0) {
                    return s1.compareTo(s2);
                }
                return result;
            }

            public String toString() {
                return ObjectTools.singletonToString((Object)this);
            }
        }
    }
}

