/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.db.relational.platformsmodel;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.persistence.tools.db.relational.platformsmodel.CorruptXMLException;
import org.eclipse.persistence.tools.db.relational.platformsmodel.DatabasePlatformRepository;
import org.eclipse.persistence.tools.db.relational.platformsmodel.DatabaseType;
import org.eclipse.persistence.tools.db.relational.platformsmodel.JDBCType;
import org.eclipse.persistence.tools.db.relational.platformsmodel.JDBCTypeRepository;
import org.eclipse.persistence.tools.db.relational.platformsmodel.JDBCTypeToDatabaseTypeMapping;
import org.eclipse.persistence.tools.utility.XMLTools;
import org.eclipse.persistence.tools.utility.collection.CollectionTools;
import org.eclipse.persistence.tools.utility.iterable.LiveCloneIterable;
import org.eclipse.persistence.tools.utility.iterator.CloneIterator;
import org.eclipse.persistence.tools.utility.iterator.IteratorTools;
import org.eclipse.persistence.tools.utility.iterator.TransformationIterator;
import org.eclipse.persistence.tools.utility.node.AbstractNode;
import org.eclipse.persistence.tools.utility.node.Node;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class DatabasePlatform
extends AbstractNode {
    private String name;
    public static final String NAME_PROPERTY = "name";
    private String shortFileName;
    public static final String SHORT_FILE_NAME_PROPERTY = "shortFileName";
    private String runtimePlatformClassName;
    public static final String RUNTIME_PLATFORM_CLASS_NAME_PROPERTY = "runtimePlatformClassName";
    private boolean supportsNativeSequencing;
    public static final String SUPPORTS_NATIVE_SEQUENCING_PROPERTY = "supportsNativeSequencing";
    private boolean supportsIdentityClause;
    public static final String SUPPORTS_IDENTITY_CLAUSE_PROPERTY = "supportsIdentityClause";
    private boolean supportsNativeReturning;
    public static final String SUPPORTS_NATIVE_RETURNING_PROPERTY = "supportsNativeReturning";
    private Collection<DatabaseType> databaseTypes;
    public static final String DATABASE_TYPES_COLLECTION = "databaseTypes";
    private Collection<JDBCTypeToDatabaseTypeMapping> jdbcTypeToDatabaseTypeMappings;
    public static final String JDBC_TYPE_TO_DATABASE_TYPE_MAPPINGS_COLLECTION = "jdbcTypeToDatabaseTypeMappings";

    DatabasePlatform(DatabasePlatformRepository repository, File file) throws CorruptXMLException {
        super((Node)repository);
        this.read(file);
    }

    DatabasePlatform(DatabasePlatformRepository repository, String name, String shortFileName) {
        super((Node)repository);
        this.name = name;
        this.shortFileName = shortFileName;
        this.initializeJDBCTypeToDatabaseTypeMappings();
    }

    protected void initialize() {
        super.initialize();
        this.runtimePlatformClassName = this.defaultRuntimePlatformClassName();
        this.supportsNativeSequencing = false;
        this.supportsNativeReturning = false;
        this.supportsIdentityClause = false;
        this.databaseTypes = new Vector<DatabaseType>();
        this.jdbcTypeToDatabaseTypeMappings = new Vector<JDBCTypeToDatabaseTypeMapping>();
    }

    private String defaultRuntimePlatformClassName() {
        return "org.eclipse.persistence.platform.database.DatabasePlatform";
    }

    private void initializeJDBCTypeToDatabaseTypeMappings() {
        for (JDBCType jdbcType : this.jdbcTypeRepository().jdbcTypes()) {
            this.jdbcTypeToDatabaseTypeMappings.add(new JDBCTypeToDatabaseTypeMapping(this, jdbcType));
        }
    }

    public DatabasePlatformRepository getRepository() {
        return (DatabasePlatformRepository)this.getParent();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name != null && name.equals(this.name)) {
            return;
        }
        this.getRepository().checkPlatformName(name);
        String old = this.name;
        this.name = name;
        this.firePropertyChanged(NAME_PROPERTY, old, name);
    }

    public String getShortFileName() {
        return this.shortFileName;
    }

    public void setShortFileName(String shortFileName) {
        if (shortFileName != null && shortFileName.equals(this.shortFileName)) {
            return;
        }
        this.getRepository().checkPlatformShortFileName(shortFileName);
        String old = this.shortFileName;
        this.shortFileName = shortFileName;
        this.firePropertyChanged(SHORT_FILE_NAME_PROPERTY, old, shortFileName);
    }

    public String getRuntimePlatformClassName() {
        return this.runtimePlatformClassName;
    }

    public void setRuntimePlatformClassName(String runtimePlatformClassName) {
        if (runtimePlatformClassName == null || runtimePlatformClassName.length() == 0) {
            throw new IllegalArgumentException("run-time platform class name is required");
        }
        String old = runtimePlatformClassName;
        this.runtimePlatformClassName = runtimePlatformClassName;
        this.firePropertyChanged(RUNTIME_PLATFORM_CLASS_NAME_PROPERTY, old, runtimePlatformClassName);
    }

    public boolean supportsNativeReturning() {
        return this.supportsNativeReturning;
    }

    public void setSupportsNativeReturning(boolean supportNativeReturning) {
        boolean old = this.supportsNativeReturning;
        this.supportsNativeReturning = supportNativeReturning;
        this.firePropertyChanged(SUPPORTS_NATIVE_RETURNING_PROPERTY, old, supportNativeReturning);
    }

    public boolean supportsNativeSequencing() {
        return this.supportsNativeSequencing;
    }

    public void setSupportsNativeSequencing(boolean supportsNativeSequencing) {
        boolean old = this.supportsNativeSequencing;
        this.supportsNativeSequencing = supportsNativeSequencing;
        this.firePropertyChanged(SUPPORTS_NATIVE_SEQUENCING_PROPERTY, old, supportsNativeSequencing);
        if (!supportsNativeSequencing) {
            this.setSupportsIdentityClause(false);
        }
    }

    public boolean supportsIdentityClause() {
        return this.supportsIdentityClause;
    }

    public void setSupportsIdentityClause(boolean supportsIdentityClause) {
        boolean old = this.supportsIdentityClause;
        this.supportsIdentityClause = supportsIdentityClause;
        this.firePropertyChanged(SUPPORTS_IDENTITY_CLAUSE_PROPERTY, old, supportsIdentityClause);
        if (supportsIdentityClause) {
            this.setSupportsNativeSequencing(true);
        }
    }

    public Iterable<DatabaseType> databaseTypes() {
        return new LiveCloneIterable<DatabaseType>(this.databaseTypes){

            protected void remove(DatabaseType current) {
                DatabasePlatform.this.removeDatabaseType(current);
            }
        };
    }

    public int databaseTypesSize() {
        return this.databaseTypes.size();
    }

    public DatabaseType addDatabaseType(String typeName) {
        this.checkDatabaseTypeName(typeName);
        return this.addDatabaseType(new DatabaseType(this, typeName));
    }

    private DatabaseType addDatabaseType(DatabaseType type) {
        this.addItemToCollection((Object)type, this.databaseTypes, DATABASE_TYPES_COLLECTION);
        return type;
    }

    public void removeDatabaseType(DatabaseType type) {
        this.removeItemFromCollection((Object)type, this.databaseTypes, DATABASE_TYPES_COLLECTION);
        this.databaseTypeRemoved(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void databaseTypeRemoved(DatabaseType removedType) {
        Collection<JDBCTypeToDatabaseTypeMapping> collection = this.jdbcTypeToDatabaseTypeMappings;
        synchronized (collection) {
            for (JDBCTypeToDatabaseTypeMapping mapping : this.jdbcTypeToDatabaseTypeMappings) {
                if (mapping.getDatabaseType() != removedType) continue;
                mapping.setDatabaseType(null);
            }
        }
    }

    public void removeDatabaseTypes(Collection<DatabaseType> types) {
        this.removeItemsFromCollection(types, this.databaseTypes, DATABASE_TYPES_COLLECTION);
        this.databaseTypesRemoved(types);
    }

    private void databaseTypesRemoved(Collection<DatabaseType> removedTypes) {
        for (DatabaseType type : removedTypes) {
            this.databaseTypeRemoved(type);
        }
    }

    public void removeDatabaseTypes(Iterator<DatabaseType> types) {
        this.removeDatabaseTypes((Collection<DatabaseType>)CollectionTools.collection(types));
    }

    public Iterator<JDBCTypeToDatabaseTypeMapping> jdbcTypeToDatabaseTypeMappings() {
        return new CloneIterator(this.jdbcTypeToDatabaseTypeMappings);
    }

    public int jdbcTypeToDatabaseTypeMappingsSize() {
        return this.jdbcTypeToDatabaseTypeMappings.size();
    }

    private JDBCTypeToDatabaseTypeMapping addJDBCTypeToDatabaseTypeMapping(JDBCType jdbcType) {
        return this.addJDBCTypeToDatabaseTypeMapping(new JDBCTypeToDatabaseTypeMapping(this, jdbcType));
    }

    private JDBCTypeToDatabaseTypeMapping addJDBCTypeToDatabaseTypeMapping(JDBCTypeToDatabaseTypeMapping mapping) {
        this.addItemToCollection((Object)mapping, this.jdbcTypeToDatabaseTypeMappings, JDBC_TYPE_TO_DATABASE_TYPE_MAPPINGS_COLLECTION);
        return mapping;
    }

    private Iterable<JDBCTypeToDatabaseTypeMapping> internalJDBCTypeToDatabaseTypeMappings() {
        return new LiveCloneIterable<JDBCTypeToDatabaseTypeMapping>(this.jdbcTypeToDatabaseTypeMappings){

            protected void remove(JDBCTypeToDatabaseTypeMapping current) {
                DatabasePlatform.this.removeJDBCTypeToDatabaseTypeMapping(current);
            }
        };
    }

    void removeJDBCTypeToDatabaseTypeMapping(JDBCTypeToDatabaseTypeMapping mapping) {
        this.removeItemFromCollection((Object)mapping, this.jdbcTypeToDatabaseTypeMappings, JDBC_TYPE_TO_DATABASE_TYPE_MAPPINGS_COLLECTION);
    }

    public DatabaseType databaseTypeNamed(String databaseTypeName) {
        Collection<DatabaseType> collection = this.databaseTypes;
        synchronized (collection) {
            for (DatabaseType databaseType : this.databaseTypes) {
                if (!databaseType.getName().equals(databaseTypeName)) continue;
                return databaseType;
            }
            throw new IllegalArgumentException("missing database type named: " + databaseTypeName + " (platform: " + this.name + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean containsDatabaseTypeNamed(String databaseTypeName) {
        Collection<DatabaseType> collection = this.databaseTypes;
        synchronized (collection) {
            DatabaseType databaseType;
            Iterator<DatabaseType> iterator = this.databaseTypes.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(databaseType = iterator.next()).getName().equals(databaseTypeName));
            return true;
        }
    }

    private JDBCTypeRepository jdbcTypeRepository() {
        return this.getRepository().getJDBCTypeRepository();
    }

    private JDBCType jdbcTypeForCode(int jdbcTypeCode) {
        return this.jdbcTypeRepository().jdbcTypeForCode(jdbcTypeCode);
    }

    JDBCType jdbcTypeNamed(String jdbcTypeName) {
        return this.jdbcTypeRepository().jdbcTypeNamed(jdbcTypeName);
    }

    public DatabaseType defaultDatabaseType() {
        return this.databaseTypeFor(this.jdbcTypeRepository().getDefaultJDBCType());
    }

    public DatabaseType databaseTypeFor(DatabaseType otherType) {
        try {
            return this.databaseTypeNamed(otherType.getName());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return this.databaseTypeFor(otherType.getJDBCType());
        }
    }

    private Iterator<String> databaseTypeNames() {
        return new TransformationIterator<DatabaseType, String>(this.databaseTypes()){

            protected String transform(DatabaseType next) {
                return next.getName();
            }
        };
    }

    private boolean maps(JDBCType type) {
        for (JDBCTypeToDatabaseTypeMapping mapping : this.jdbcTypeToDatabaseTypeMappings) {
            if (mapping.getJDBCType() != type) continue;
            return true;
        }
        return false;
    }

    private JDBCTypeToDatabaseTypeMapping jdbcTypeToDatabaseTypeMappingFor(JDBCType jdbcType) {
        Collection<JDBCTypeToDatabaseTypeMapping> collection = this.jdbcTypeToDatabaseTypeMappings;
        synchronized (collection) {
            for (JDBCTypeToDatabaseTypeMapping mapping : this.jdbcTypeToDatabaseTypeMappings) {
                if (!mapping.maps(jdbcType)) continue;
                return mapping;
            }
            throw new IllegalStateException("JDBC type to database type mapping is missing: " + jdbcType.getName() + " (platform: " + this.name + ")");
        }
    }

    private DatabaseType databaseTypeFor(JDBCType jdbcType) {
        return this.jdbcTypeToDatabaseTypeMappingFor(jdbcType).getDatabaseType();
    }

    public DatabaseType databaseTypeForJDBCTypeCode(int jdbcTypeCode) {
        return this.databaseTypeFor(this.jdbcTypeForCode(jdbcTypeCode));
    }

    public boolean javaTypeDeclarationCanBeMappedToDatabaseType(String javaClassName, int arrayDepth) {
        return this.jdbcTypeRepository().javaTypeDeclarationCanBeMappedToJDBCType(javaClassName, arrayDepth);
    }

    public DatabaseType databaseTypeForJavaTypeDeclaration(String javaClassName, int arrayDepth) {
        return this.databaseTypeFor(this.jdbcTypeRepository().jdbcTypeForJavaTypeDeclaration(javaClassName, arrayDepth));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List<Node> children) {
        super.addChildrenTo(children);
        Collection<AbstractNode> collection = this.databaseTypes;
        synchronized (collection) {
            children.addAll(this.databaseTypes);
        }
        collection = this.jdbcTypeToDatabaseTypeMappings;
        synchronized (collection) {
            children.addAll(this.jdbcTypeToDatabaseTypeMappings);
        }
    }

    public void nodeRemoved(Node node) {
        super.nodeRemoved(node);
        Iterator<JDBCTypeToDatabaseTypeMapping> stream = this.internalJDBCTypeToDatabaseTypeMappings().iterator();
        while (stream.hasNext()) {
            if (stream.next().getJDBCType() != node) continue;
            stream.remove();
            break;
        }
    }

    void jdbcTypeAdded(JDBCType newJDBCType) {
        this.addJDBCTypeToDatabaseTypeMapping(newJDBCType);
    }

    void cloneFrom(DatabasePlatform originalPlatform) {
        this.runtimePlatformClassName = originalPlatform.getRuntimePlatformClassName();
        this.supportsNativeSequencing = originalPlatform.supportsNativeSequencing();
        this.supportsNativeReturning = originalPlatform.supportsNativeReturning();
        this.supportsIdentityClause = originalPlatform.supportsIdentityClause();
        for (DatabaseType originalType : originalPlatform.databaseTypes()) {
            DatabaseType cloneType = this.addDatabaseType(originalType.getName());
            cloneType.cloneFrom(originalType);
        }
        Iterator<AbstractNode> stream = originalPlatform.jdbcTypeToDatabaseTypeMappings();
        while (stream.hasNext()) {
            JDBCTypeToDatabaseTypeMapping originalMapping = (JDBCTypeToDatabaseTypeMapping)stream.next();
            JDBCTypeToDatabaseTypeMapping cloneMapping = this.jdbcTypeToDatabaseTypeMappingFor(originalMapping.getJDBCType());
            cloneMapping.cloneFrom(originalMapping);
        }
    }

    private void checkDatabaseType(DatabaseType databaseType) {
        this.checkDatabaseTypeName(databaseType.getName());
    }

    void checkDatabaseTypeName(String databaseTypeName) {
        if (databaseTypeName == null || databaseTypeName.length() == 0) {
            throw new IllegalArgumentException("database type name is required");
        }
        if (IteratorTools.contains(this.databaseTypeNames(), (Object)databaseTypeName)) {
            throw new IllegalArgumentException("duplicate database type name: " + databaseTypeName);
        }
    }

    private void read(File file) throws CorruptXMLException {
        this.shortFileName = file.getName();
        Document doc = XMLTools.parse((File)file);
        org.w3c.dom.Node root = XMLTools.getChild((org.w3c.dom.Node)doc, (String)"database-platform");
        if (root == null) {
            throw new CorruptXMLException("missing root node: database-platform (" + file.getPath() + ")");
        }
        this.name = XMLTools.getChildTextContent((org.w3c.dom.Node)root, (String)NAME_PROPERTY, null);
        if (this.name == null || this.name.length() == 0) {
            throw new CorruptXMLException("name is required (" + file.getPath() + ")");
        }
        this.runtimePlatformClassName = XMLTools.getChildTextContent((org.w3c.dom.Node)root, (String)"runtime-platform-class", null);
        if (this.runtimePlatformClassName == null || this.runtimePlatformClassName.length() == 0) {
            throw this.buildCorruptXMLException("run-time platform class name is required");
        }
        this.supportsNativeSequencing = XMLTools.getChildBooleanContent((org.w3c.dom.Node)root, (String)"supports-native-sequencing", (boolean)false);
        this.supportsNativeReturning = XMLTools.getChildBooleanContent((org.w3c.dom.Node)root, (String)"supports-native-returning", (boolean)false);
        this.supportsIdentityClause = XMLTools.getChildBooleanContent((org.w3c.dom.Node)root, (String)"supports-identity-clause", (boolean)false);
        if (this.supportsIdentityClause && !this.supportsNativeSequencing) {
            throw this.buildCorruptXMLException("platform must support native sequencing if it supports the IDENTITY clause");
        }
        this.readDatabaseTypeNodes(XMLTools.getChild((org.w3c.dom.Node)root, (String)"database-types"));
        this.readJDBCMappingNodes(XMLTools.getChild((org.w3c.dom.Node)root, (String)"jdbc-mappings"));
    }

    private void readDatabaseTypeNodes(org.w3c.dom.Node databaseTypesNode) throws CorruptXMLException {
        for (org.w3c.dom.Node databaseTypeNode : XMLTools.getChildren((org.w3c.dom.Node)databaseTypesNode, (String)"database-type")) {
            DatabaseType databaseType = new DatabaseType(this, databaseTypeNode);
            try {
                this.checkDatabaseType(databaseType);
            }
            catch (IllegalArgumentException ex) {
                throw this.buildCorruptXMLException(ex);
            }
            this.databaseTypes.add(databaseType);
        }
    }

    private void readJDBCMappingNodes(org.w3c.dom.Node mappingsNode) throws CorruptXMLException {
        for (org.w3c.dom.Node mappingNode : XMLTools.getChildren((org.w3c.dom.Node)mappingsNode, (String)"jdbc-mapping")) {
            JDBCTypeToDatabaseTypeMapping mapping = new JDBCTypeToDatabaseTypeMapping(this, mappingNode);
            if (this.maps(mapping.getJDBCType())) {
                throw this.buildCorruptXMLException("duplicate JDBC to database type mapping: " + (Object)((Object)mapping));
            }
            this.jdbcTypeToDatabaseTypeMappings.add(mapping);
        }
        if (this.jdbcTypeToDatabaseTypeMappings.size() != this.jdbcTypeRepository().jdbcTypesSize()) {
            throw this.buildCorruptXMLException("missing JDBC to database type mappings (number of mappings: " + this.jdbcTypeToDatabaseTypeMappings.size() + " - number of JDBC types: " + this.jdbcTypeRepository().jdbcTypesSize() + ")");
        }
    }

    private CorruptXMLException buildCorruptXMLException(String message) {
        return new CorruptXMLException(String.valueOf(message) + " (platform: " + this.name + ")");
    }

    private CorruptXMLException buildCorruptXMLException(Throwable t) {
        return new CorruptXMLException("platform: " + this.name, t);
    }

    void write(File platformsDirectory) {
        if (this.isCleanBranch()) {
            return;
        }
        Document document = XMLTools.newDocument();
        Element root = document.createElement("database-platform");
        document.appendChild(root);
        XMLTools.addSimpleTextNode((org.w3c.dom.Node)root, (String)NAME_PROPERTY, (String)this.name);
        XMLTools.addSimpleTextNode((org.w3c.dom.Node)root, (String)"runtime-platform-class", (String)this.runtimePlatformClassName);
        XMLTools.addSimpleTextNode((org.w3c.dom.Node)root, (String)"supports-native-sequencing", (boolean)this.supportsNativeSequencing, (boolean)false);
        XMLTools.addSimpleTextNode((org.w3c.dom.Node)root, (String)"supports-native-returning", (boolean)this.supportsNativeReturning, (boolean)false);
        XMLTools.addSimpleTextNode((org.w3c.dom.Node)root, (String)"supports-identity-clause", (boolean)this.supportsIdentityClause, (boolean)false);
        this.writeDatabaseTypeNodes(root.appendChild(document.createElement("database-types")));
        this.writeJDBCMappingNodes(root.appendChild(document.createElement("jdbc-mappings")));
        XMLTools.print((Document)document, (File)new File(platformsDirectory, this.shortFileName));
        this.markEntireBranchClean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDatabaseTypeNodes(org.w3c.dom.Node databaseTypesNode) {
        Document document = databaseTypesNode.getOwnerDocument();
        Collection<DatabaseType> collection = this.databaseTypes;
        synchronized (collection) {
            Iterator<DatabaseType> stream = new TreeSet<DatabaseType>(this.databaseTypes).iterator();
            while (stream.hasNext()) {
                Element databaseTypeNode = document.createElement("database-type");
                databaseTypesNode.appendChild(databaseTypeNode);
                stream.next().write(databaseTypeNode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeJDBCMappingNodes(org.w3c.dom.Node mappingsNode) {
        Document document = mappingsNode.getOwnerDocument();
        Collection<JDBCTypeToDatabaseTypeMapping> collection = this.jdbcTypeToDatabaseTypeMappings;
        synchronized (collection) {
            Iterator<JDBCTypeToDatabaseTypeMapping> stream = new TreeSet<JDBCTypeToDatabaseTypeMapping>(this.jdbcTypeToDatabaseTypeMappings).iterator();
            while (stream.hasNext()) {
                Element mappingNode = document.createElement("jdbc-mapping");
                mappingsNode.appendChild(mappingNode);
                stream.next().write(mappingNode);
            }
        }
    }

    public String displayString() {
        return this.name;
    }

    public void toString(StringBuffer sb) {
        sb.append(this.name);
    }
}

