/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.db;

import java.util.Iterator;
import org.eclipse.persistence.tools.db.EclipseLinkColumn;
import org.eclipse.persistence.tools.db.EclipseLinkColumnPair;
import org.eclipse.persistence.tools.db.EclipseLinkDatabase;
import org.eclipse.persistence.tools.db.EclipseLinkTable;
import org.eclipse.persistence.tools.db.model.ELColumn;
import org.eclipse.persistence.tools.db.model.ELColumnPair;
import org.eclipse.persistence.tools.db.model.ELReference;
import org.eclipse.persistence.tools.gen.db.Column;
import org.eclipse.persistence.tools.gen.db.ConnectionProfile;
import org.eclipse.persistence.tools.gen.db.ForeignKey;
import org.eclipse.persistence.tools.gen.db.Table;
import org.eclipse.persistence.tools.utility.iterable.FilteringIterable;
import org.eclipse.persistence.tools.utility.iterable.TransformationIterable;
import org.eclipse.persistence.tools.utility.iterator.TransformationIterator;

public class EclipseLinkForeignKey
implements ForeignKey {
    private String defaultAttributeName;
    private boolean defaultAttributeNameCalculated = false;
    private ELReference reference;
    private EclipseLinkTable table;

    public EclipseLinkForeignKey(EclipseLinkTable table, ELReference reference) {
        this.table = table;
        this.reference = reference;
    }

    private String buildDefaultAttributeName() {
        if (!this.referencesSingleColumnPrimaryKey()) {
            return null;
        }
        ForeignKey.ColumnPair columnPair = this.getColumnPair();
        String baseColName = columnPair.getBaseColumn().getName();
        String refColName = columnPair.getReferencedColumn().getName();
        if (baseColName.length() <= refColName.length() + 1) {
            return null;
        }
        if (!baseColName.endsWith(refColName)) {
            return null;
        }
        int _index = baseColName.length() - refColName.length() - 1;
        if (baseColName.charAt(_index) != '_') {
            return null;
        }
        return baseColName.substring(0, _index);
    }

    public String getAttributeName() {
        String defaultName = this.getDefaultAttributeName();
        return defaultName != null ? defaultName : this.getNonDefaultAttributeName();
    }

    public Iterable<Column> getBaseColumns() {
        return new TransformationIterable<ELColumn, Column>((Iterable)new Iterable<ELColumn>(){

            @Override
            public Iterator<ELColumn> iterator() {
                return new TransformationIterator<ELColumnPair, ELColumn>(EclipseLinkForeignKey.this.reference.columnPairs()){

                    protected ELColumn transform(ELColumnPair column) {
                        return column.getSourceColumn();
                    }
                };
            }
        }){

            protected Column transform(ELColumn column) {
                return new EclipseLinkColumn(EclipseLinkForeignKey.this.table, column);
            }
        };
    }

    public Table getBaseTable() {
        return this.table;
    }

    public ForeignKey.ColumnPair getColumnPair() {
        if (this.getColumnPairsSize() > 0) {
            return this.getColumnPairs().iterator().next();
        }
        throw new IllegalStateException();
    }

    public Iterable<ForeignKey.ColumnPair> getColumnPairs() {
        return new TransformationIterable<ELColumnPair, ForeignKey.ColumnPair>(this.reference.columnPairs()){

            protected ForeignKey.ColumnPair transform(ELColumnPair columnPair) {
                return new EclipseLinkColumnPair(EclipseLinkForeignKey.this.table, columnPair);
            }
        };
    }

    public int getColumnPairsSize() {
        return this.reference.columnPairsSize();
    }

    public ConnectionProfile getConnectionProfile() {
        throw new UnsupportedOperationException("Not Supported!");
    }

    public EclipseLinkDatabase getDatabase() {
        return this.table.getDatabase();
    }

    public synchronized String getDefaultAttributeName() {
        if (!this.defaultAttributeNameCalculated) {
            this.defaultAttributeNameCalculated = true;
            this.defaultAttributeName = this.buildDefaultAttributeName();
        }
        return this.defaultAttributeName;
    }

    public String getIdentifier() {
        return this.getName();
    }

    public String getIdentifier(String defaultName) {
        return this.getDatabase().convertNameToIdentifier(this.getName());
    }

    public String getJoinColumnAnnotationIdentifier(String attributeName) {
        String baseColumnName = this.getColumnPair().getBaseColumn().getName();
        String defaultBaseColumnName = String.valueOf(attributeName) + '_' + this.getReferencedTable().getPrimaryKeyColumn().getName();
        return this.getDatabase().getIdentifier(baseColumnName, defaultBaseColumnName);
    }

    public String getName() {
        return this.reference.getName();
    }

    private String getNonDefaultAttributeName() {
        return this.getColumnPairsSize() == 1 ? this.getNonDefaultAttributeNameFromBaseColumn() : this.getReferencedTable().getName();
    }

    private String getNonDefaultAttributeNameFromBaseColumn() {
        int refLen;
        ForeignKey.ColumnPair columnPair = this.getColumnPair();
        String baseColName = columnPair.getBaseColumn().getName();
        String refColName = columnPair.getReferencedColumn().getName();
        int len = baseColName.length();
        if (len > (refLen = refColName.length()) && baseColName.endsWith(refColName) && (len -= refLen) > 1 && baseColName.charAt(len - 1) == '_') {
            --len;
        }
        return baseColName.substring(0, len);
    }

    public Iterable<Column> getNonPrimaryKeyBaseColumns() {
        return new FilteringIterable<Column>(this.getBaseColumns()){

            protected boolean accept(Column column) {
                return !column.isPartOfPrimaryKey();
            }
        };
    }

    public Iterable<Column> getReferencedColumns() {
        return new TransformationIterable<ELColumn, Column>((Iterable)new Iterable<ELColumn>(){

            @Override
            public Iterator<ELColumn> iterator() {
                return new TransformationIterator<ELColumnPair, ELColumn>(EclipseLinkForeignKey.this.reference.columnPairs()){

                    protected ELColumn transform(ELColumnPair column) {
                        return column.getTargetColumn();
                    }
                };
            }
        }){

            protected Column transform(ELColumn column) {
                return new EclipseLinkColumn(EclipseLinkForeignKey.this.table, column);
            }
        };
    }

    public Table getReferencedTable() {
        return new EclipseLinkTable(this.table.getSchema(), this.reference.getTargetTable());
    }

    public boolean referencesSingleColumnPrimaryKey() {
        if (this.getColumnPairsSize() != 1) {
            return false;
        }
        if (this.getReferencedTable().getPrimaryKeyColumnsSize() != 1) {
            return false;
        }
        return this.getColumnPair().getReferencedColumn() == this.getReferencedTable().getPrimaryKeyColumn();
    }
}

