/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.cascadedeletes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.cascadedeletes.BranchA;
import org.eclipse.persistence.testing.models.jpa.cascadedeletes.BranchB;
import org.eclipse.persistence.testing.models.jpa.cascadedeletes.CascadeDeleteTableCreator;
import org.eclipse.persistence.testing.models.jpa.cascadedeletes.LeafA;
import org.eclipse.persistence.testing.models.jpa.cascadedeletes.LeafB;
import org.eclipse.persistence.testing.models.jpa.cascadedeletes.MachineState;
import org.eclipse.persistence.testing.models.jpa.cascadedeletes.PersistentIdentity;
import org.eclipse.persistence.testing.models.jpa.cascadedeletes.RootA;
import org.eclipse.persistence.testing.models.jpa.cascadedeletes.ThreadInfo;

public class CascadeDeletesJUnitTestSuite
extends JUnitTestCase {
    public CascadeDeletesJUnitTestSuite() {
    }

    public CascadeDeletesJUnitTestSuite(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("CascadeDeletesJUnitTestSuite");
        suite.addTest((Test)new CascadeDeletesJUnitTestSuite("testSetup"));
        suite.addTest((Test)new CascadeDeletesJUnitTestSuite("testDeleteWholeTree"));
        suite.addTest((Test)new CascadeDeletesJUnitTestSuite("testRemoveMachineState"));
        suite.addTest((Test)new CascadeDeletesJUnitTestSuite("testDeletePrivateOwned"));
        suite.addTest((Test)new CascadeDeletesJUnitTestSuite("testDeleteBranchBTree"));
        suite.addTest((Test)new CascadeDeletesJUnitTestSuite("testDeletePrivateOwnedChild"));
        return suite;
    }

    public void testSetup() {
        new CascadeDeleteTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession((String)"cascade-deletes"));
        CascadeDeletesJUnitTestSuite.clearCache((String)"cascade-deletes");
    }

    public void testRemoveMachineState() {
        EntityManager em = CascadeDeletesJUnitTestSuite.createEntityManager((String)"cascade-deletes");
        this.beginTransaction(em);
        MachineState ms = new MachineState();
        ms.setId(1L);
        ms.setThreads(new ArrayList());
        ms.getThreads().add(new ThreadInfo(1L, "main"));
        em.persist((Object)ms);
        this.commitTransaction(em);
        this.beginTransaction(em);
        ms = (MachineState)em.find(MachineState.class, (Object)1L);
        em.remove((Object)ms);
        this.commitTransaction(em);
    }

    public void testDeleteWholeTree() {
        ArrayList<PersistentIdentity> allEntities = new ArrayList<PersistentIdentity>();
        RootA rootA = this.createTree(allEntities);
        EntityManager em = CascadeDeletesJUnitTestSuite.createEntityManager((String)"cascade-deletes");
        try {
            this.beginTransaction(em);
            rootA = (RootA)em.find(RootA.class, (Object)rootA.getId());
            for (BranchA a : rootA.getBranchAs()) {
                a.getLeafs().size();
            }
            em.remove((Object)rootA);
            for (PersistentIdentity entity : allEntities) {
                CascadeDeletesJUnitTestSuite.assertNull((String)"Contains found removed entity", (Object)em.find(entity.getClass(), (Object)entity.getId()));
            }
            this.commitTransaction(em);
            this.closeEntityManager(em);
            CascadeDeletesJUnitTestSuite.clearCache((String)"cascade-deletes");
            em = CascadeDeletesJUnitTestSuite.createEntityManager((String)"cascade-deletes");
            for (PersistentIdentity entity : allEntities) {
                CascadeDeletesJUnitTestSuite.assertNull((String)("Failed to remove all entities, found entity class: " + entity.getClass() + " with Id: " + entity.getId()), (Object)em.find(entity.getClass(), (Object)entity.getId()));
            }
            this.closeEntityManager(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        finally {
            this.deleteTree();
        }
    }

    public void testDeletePrivateOwned() {
        ArrayList<PersistentIdentity> allEntities = new ArrayList<PersistentIdentity>();
        RootA rootA = this.createTree(allEntities);
        EntityManager em = CascadeDeletesJUnitTestSuite.createEntityManager((String)"cascade-deletes");
        try {
            this.beginTransaction(em);
            BranchB branchB = (BranchB)em.createQuery("Select b from BranchB b join b.branchBs bb where bb.leafBs is not empty").getResultList().get(0);
            BranchB subB = (BranchB)branchB.getBranchBs().get(0);
            subB.getLeafBs().size();
            branchB.getBranchBs().clear();
            this.commitTransaction(em);
            this.closeEntityManager(em);
            CascadeDeletesJUnitTestSuite.clearCache((String)"cascade-deletes");
            em = CascadeDeletesJUnitTestSuite.createEntityManager((String)"cascade-deletes");
            CascadeDeletesJUnitTestSuite.assertNull((String)"private owned object was not deleted.", (Object)em.find(BranchB.class, (Object)subB.getId()));
            CascadeDeletesJUnitTestSuite.assertNotNull((String)"child of PO object was deleted in error", (Object)em.find(LeafB.class, (Object)((LeafB)subB.getLeafBs().get(0)).getId()));
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        finally {
            this.deleteTree();
        }
    }

    public void testDeletePrivateOwnedChild() {
        ArrayList<PersistentIdentity> allEntities = new ArrayList<PersistentIdentity>();
        this.createTree(allEntities);
        EntityManager em = CascadeDeletesJUnitTestSuite.createEntityManager((String)"cascade-deletes");
        try {
            this.beginTransaction(em);
            RootA rootA = (RootA)em.createQuery("Select r from RootA r join r.branchAs ba where ba.secondSet is not empty").getResultList().get(0);
            BranchA subA = (BranchA)rootA.getBranchAs().get(0);
            subA.getLeafs().size();
            rootA.getBranchAs().remove(subA);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            CascadeDeletesJUnitTestSuite.clearCache((String)"cascade-deletes");
            em = CascadeDeletesJUnitTestSuite.createEntityManager((String)"cascade-deletes");
            CascadeDeletesJUnitTestSuite.assertNull((String)"private owned object was not deleted.", (Object)em.find(BranchA.class, (Object)subA.getId()));
            for (LeafA leafA : subA.getLeafs()) {
                CascadeDeletesJUnitTestSuite.assertNull((String)"child of PO object was deleted in error", (Object)em.find(LeafA.class, (Object)leafA.getId()));
            }
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        finally {
            this.deleteTree();
        }
    }

    public void testDeleteBranchBTree() {
        ArrayList<PersistentIdentity> allEntities = new ArrayList<PersistentIdentity>();
        RootA rootA = this.createTree(allEntities);
        EntityManager em = CascadeDeletesJUnitTestSuite.createEntityManager((String)"cascade-deletes");
        try {
            this.beginTransaction(em);
            rootA = (RootA)em.find(RootA.class, (Object)rootA.getId());
            BranchB removed = rootA.getBranchB();
            em.remove((Object)removed);
            rootA.setBranchB(null);
            CascadeDeletesJUnitTestSuite.assertFalse((String)"Failed to remove all entities in tree", (boolean)removed.checkTreeForRemoval(em));
            this.commitTransaction(em);
            this.closeEntityManager(em);
            CascadeDeletesJUnitTestSuite.clearCache((String)"cascade-deletes");
            em = CascadeDeletesJUnitTestSuite.createEntityManager((String)"cascade-deletes");
            CascadeDeletesJUnitTestSuite.assertFalse((String)"Failed to remove all entities in tree", (boolean)removed.checkTreeForRemoval(em));
            this.closeEntityManager(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        finally {
            this.deleteTree();
        }
    }

    public RootA createTree(Collection<PersistentIdentity> allEntities) {
        EntityManager em = CascadeDeletesJUnitTestSuite.createEntityManager((String)"cascade-deletes");
        this.beginTransaction(em);
        RootA rootA = new RootA();
        em.persist((Object)rootA);
        allEntities.add((PersistentIdentity)rootA);
        BranchA branchA = new BranchA();
        em.persist((Object)branchA);
        allEntities.add((PersistentIdentity)branchA);
        BranchA subBranch = new BranchA();
        em.persist((Object)subBranch);
        allEntities.add((PersistentIdentity)subBranch);
        branchA.setBranchA(subBranch);
        LeafA leafA = new LeafA();
        em.persist((Object)leafA);
        allEntities.add((PersistentIdentity)leafA);
        leafA.setBranchA(branchA);
        branchA.getLeafs().add(leafA);
        leafA = new LeafA();
        em.persist((Object)leafA);
        allEntities.add((PersistentIdentity)leafA);
        branchA.getSecondSet().add(leafA);
        leafA = new LeafA();
        em.persist((Object)leafA);
        allEntities.add((PersistentIdentity)leafA);
        branchA.getSecondSet().add(leafA);
        leafA = new LeafA();
        em.persist((Object)leafA);
        allEntities.add((PersistentIdentity)leafA);
        leafA.setBranchA(branchA);
        branchA.getLeafs().add(leafA);
        rootA.getBranchAs().add(branchA);
        branchA = new BranchA();
        em.persist((Object)branchA);
        allEntities.add((PersistentIdentity)branchA);
        subBranch = new BranchA();
        em.persist((Object)subBranch);
        allEntities.add((PersistentIdentity)subBranch);
        branchA.setBranchA(subBranch);
        leafA = new LeafA();
        em.persist((Object)leafA);
        allEntities.add((PersistentIdentity)leafA);
        leafA.setBranchA(branchA);
        branchA.getLeafs().add(leafA);
        leafA = new LeafA();
        em.persist((Object)leafA);
        allEntities.add((PersistentIdentity)leafA);
        leafA.setBranchA(branchA);
        branchA.getLeafs().add(leafA);
        rootA.getBranchAs().add(branchA);
        BranchB branchB = new BranchB();
        em.persist((Object)branchB);
        allEntities.add((PersistentIdentity)branchB);
        rootA.setBranchB(branchB);
        BranchB subbranchB = new BranchB();
        em.persist((Object)subbranchB);
        allEntities.add((PersistentIdentity)subbranchB);
        LeafB subbranchBLeafB = new LeafB();
        em.persist((Object)subbranchBLeafB);
        subbranchB.getLeafBs().add(subbranchBLeafB);
        branchB.getBranchBs().add(subbranchB);
        subbranchB = new BranchB();
        em.persist((Object)subbranchB);
        allEntities.add((PersistentIdentity)subbranchB);
        branchB.getBranchBs().add(subbranchB);
        LeafB leafB = new LeafB();
        em.persist((Object)leafB);
        allEntities.add((PersistentIdentity)leafB);
        branchB.getLeafBs().add(leafB);
        leafB = new LeafB();
        em.persist((Object)leafB);
        allEntities.add((PersistentIdentity)leafB);
        branchB.getLeafBs().add(leafB);
        this.commitTransaction(em);
        this.closeEntityManager(em);
        CascadeDeletesJUnitTestSuite.clearCache((String)"cascade-deletes");
        return rootA;
    }

    public void deleteTree() {
        EntityManager em = CascadeDeletesJUnitTestSuite.createEntityManager((String)"cascade-deletes");
        this.beginTransaction(em);
        List result = em.createQuery("Select r from RootA r").getResultList();
        for (RootA root : result) {
            root.getBranchAs().clear();
            root.setBranchB(null);
        }
        List result2 = em.createQuery("Select r from BranchA r").getResultList();
        for (BranchA root : result2) {
            root.getLeafs().clear();
            root.getSecondSet().clear();
            root.setBranchA(null);
        }
        List result3 = em.createQuery("Select r from BranchB r").getResultList();
        for (BranchB root : result3) {
            root.getBranchBs().clear();
            root.getLeafBs().clear();
        }
        List result4 = em.createQuery("Select r from LeafA r").getResultList();
        for (LeafA root : result4) {
            root.setBranchA(null);
        }
        em.flush();
        em.createQuery("delete from RootA").executeUpdate();
        em.createQuery("delete from BranchA").executeUpdate();
        em.createQuery("delete from BranchB").executeUpdate();
        em.createQuery("delete from LeafA").executeUpdate();
        em.createQuery("delete from LeafB").executeUpdate();
        this.commitTransaction(em);
        this.closeEntityManager(em);
        CascadeDeletesJUnitTestSuite.clearCache((String)"cascade-deletes");
    }
}

