/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import java.util.Vector;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.sessions.SessionEventListener;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestProblemException;
import org.eclipse.persistence.testing.framework.WriteObjectTest;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.EmployeePopulator;
import org.eclipse.persistence.testing.models.employee.domain.LargeProject;
import org.eclipse.persistence.testing.models.employee.domain.Project;
import org.eclipse.persistence.testing.models.employee.domain.SmallProject;

public class UnitOfWorkResumeOnFailureTest
extends WriteObjectTest {
    public Employee unitOfWorkWorkingCopy;
    public UnitOfWork unitOfWork;
    SessionEventListener listener;

    public UnitOfWorkResumeOnFailureTest(Employee originalObject) {
        super((Object)originalObject);
    }

    protected void changeInFirstUnitOfWork() {
        this.unitOfWorkWorkingCopy.setProjects(new Vector());
        this.unitOfWorkWorkingCopy.addProject((Project)this.unitOfWork.readObject(SmallProject.class));
        this.unitOfWorkWorkingCopy.addProject((Project)this.unitOfWork.readObject(LargeProject.class));
        this.unitOfWorkWorkingCopy.setResponsibilitiesList(new Vector());
        this.unitOfWorkWorkingCopy.addResponsibility("does not make cafee");
        this.unitOfWorkWorkingCopy.addResponsibility("does not buy donuts");
        Address address = new EmployeePopulator().addressExample10();
        this.unitOfWorkWorkingCopy.setAddress(address);
        this.unitOfWorkWorkingCopy.setManager((Employee)this.unitOfWork.readObject(Employee.class));
        this.unitOfWorkWorkingCopy.setFirstName(new String(new byte[100]));
    }

    protected void changeInSecondUnitOfWork() {
        this.unitOfWorkWorkingCopy.setProjects(new Vector());
        this.unitOfWorkWorkingCopy.addResponsibility("eat not buy donuts");
        this.unitOfWorkWorkingCopy.setAddress(new EmployeePopulator().addressExample12());
        this.unitOfWorkWorkingCopy.setManager(null);
        this.unitOfWorkWorkingCopy.setFirstName("Bojo");
    }

    public void reset() {
        super.reset();
        if (this.listener != null) {
            this.getAbstractSession().getParent().getEventManager().removeListener(this.listener);
            this.listener = null;
        }
    }

    protected void setup() {
        if (this.getSession().isRemoteSession()) {
            this.throwWarning("Test not supported on remote.");
        }
        if (this.getSession().isClientSession()) {
            this.listener = this.checkTransactionIsolation();
        }
        super.setup();
        this.unitOfWork = this.getSession().acquireUnitOfWork();
    }

    protected void test() {
        this.unitOfWork.commitAndResumeOnFailure();
        this.unitOfWorkWorkingCopy = (Employee)this.unitOfWork.registerObject(this.objectToBeWritten);
        this.changeInFirstUnitOfWork();
        if (this.compareObjects(this.originalObject, this.unitOfWorkWorkingCopy)) {
            throw new TestErrorException("The original object was changed through changing the clone.");
        }
        this.getSession().executeNonSelectingCall((Call)new SQLCall("update EMPLOYEE set VERSION = 0 where EMP_ID = " + this.unitOfWorkWorkingCopy.getId()));
        try {
            this.unitOfWork.commitAndResumeOnFailure();
            throw new TestProblemException("Should have failed");
        }
        catch (Exception exception) {
            this.getAbstractSession().rollbackTransaction();
            this.getAbstractSession().beginTransaction();
            this.changeInSecondUnitOfWork();
            if (this.compareObjects(this.originalObject, this.unitOfWorkWorkingCopy)) {
                throw new TestErrorException("The original object was changed through changing the clone.");
            }
            this.unitOfWork.commitAndResumeOnFailure();
            this.unitOfWork.release();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verify() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.unitOfWork = this.getSession().acquireUnitOfWork();
        this.unitOfWork.beginEarlyTransaction();
        this.objectFromDatabase = this.unitOfWork.executeQuery((DatabaseQuery)this.query);
        try {
            if (!this.compareObjects(this.unitOfWorkWorkingCopy, this.objectFromDatabase)) {
                throw new TestErrorException("The object inserted into the database, '" + this.objectFromDatabase + "' does not match the original, '" + this.unitOfWorkWorkingCopy + "'.");
            }
            if (!((Employee)this.objectFromDatabase).getResponsibilitiesList().contains("eat not buy donuts")) {
                throw new TestErrorException("The Changes made after the resume were lost because the deferred set was not merged into new ChangeSet");
            }
        }
        finally {
            this.unitOfWork.release();
        }
    }
}

