/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.security;

import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.security.Securable;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;

public class JCEEncryptionTest
extends AutoVerifyTestCase {
    String toEncrypt;
    String decrypted;
    Securable encryptor;

    public JCEEncryptionTest() {
        this.setDescription("Test the encryption/decryption using JCE");
    }

    public void reset() {
    }

    protected void setup() throws Exception {
        this.toEncrypt = "testString";
        this.encryptor = this.convertToEncryptionObject("org.eclipse.persistence.internal.security.JCEEncryptor");
    }

    public void test() {
        if (this.encryptor != null) {
            this.decrypted = this.encryptor.decryptPassword(this.encryptor.encryptPassword(this.toEncrypt));
        }
    }

    protected void verify() {
        if (this.encryptor == null) {
            throw new TestWarningException("JCE object could not be created.");
        }
        if (!this.decrypted.equals(this.toEncrypt)) {
            throw new TestErrorException("The JCE encryption --> decryption failed");
        }
    }

    private Securable convertToEncryptionObject(String encryptionClassName) {
        try {
            ConversionManager cm = ConversionManager.getDefaultManager();
            Class securableClass = (Class)cm.convertObject((Object)encryptionClassName, Class.class);
            return (Securable)securableClass.newInstance();
        }
        catch (Throwable e) {
            return null;
        }
    }
}

