/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.remote.RemoteSession;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.queries.RefreshTest;
import org.eclipse.persistence.testing.tests.remote.RemoteModel;

public class PessimisticLockTest
extends RefreshTest {
    public UnitOfWork uow;
    public int lockMode;

    public PessimisticLockTest(int lockMode) {
        this.lockMode = lockMode;
        this.setName(this.getName() + "(mode=" + lockMode + ")");
        this.setDescription("This test verifies the pessimistic locking feature works properly");
    }

    @Override
    public void reset() {
        super.reset();
        if (this.uow != null) {
            this.uow.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void test() throws Exception {
        this.checkSelectForUpateSupported();
        if (this.getSession().getPlatform().isHANA()) {
            throw new TestWarningException("This database does not support FOR UPDATE on multiple tables");
        }
        if (this.lockMode == 2) {
            this.checkNoWaitSupported();
        }
        this.uow = this.getSession().acquireUnitOfWork();
        this.employeeObject = (Employee)this.uow.registerObject((Object)this.employeeObject);
        this.city = this.employeeObject.getAddress().getCity();
        this.employeeObject.getAddress().setCity("Chelmsford");
        this.startTime = this.employeeObject.getStartTime();
        this.employeeObject.setStartTime(null);
        this.endDate = this.employeeObject.getPeriod().getEndDate();
        this.employeeObject.getPeriod().setEndDate(null);
        this.managerName = this.employeeObject.getManager().getFirstName();
        this.employeeObject.getManager().setFirstName("Karl");
        this.collectionSize = this.employeeObject.getPhoneNumbers().size();
        this.employeeObject.getPhoneNumbers().removeAllElements();
        this.responsibilityListSize = this.employeeObject.getResponsibilitiesList().size();
        this.employeeObject.getResponsibilitiesList().removeAllElements();
        this.uow.refreshAndLockObject((Object)this.employeeObject, (short)this.lockMode);
        DatabaseSession session2 = null;
        UnitOfWork uow2 = null;
        try {
            session2 = this.getSession() instanceof RemoteSession ? RemoteModel.getServerSession().getProject().createDatabaseSession() : this.getSession().getProject().createDatabaseSession();
            session2.setSessionLog(this.getSession().getSessionLog());
            session2.login();
            uow2 = session2.acquireUnitOfWork();
            boolean isLocked = false;
            Object result = null;
            try {
                result = uow2.refreshAndLockObject((Object)this.employeeObject, (short)2);
            }
            catch (EclipseLinkException exeception) {
                session2.logMessage(exeception.toString());
                isLocked = true;
            }
            if (result == null) {
                isLocked = true;
            }
            if (!isLocked) {
                throw new TestWarningException("Select for update does not acquire a lock");
            }
        }
        finally {
            if (uow2 != null) {
                uow2.release();
            }
            if (session2 != null) {
                session2.logout();
            }
        }
    }
}

