/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.distributedservers.rcm.broadcast;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.persistence.exceptions.ExceptionHandler;
import org.eclipse.persistence.exceptions.RemoteCommandManagerException;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.coordination.TransportManager;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWrapper;
import org.eclipse.persistence.testing.tests.distributedservers.rcm.broadcast.BroadcastEventLock;
import org.eclipse.persistence.testing.tests.distributedservers.rcm.broadcast.BroadcastSetupHelper;

public class BroadcastReconnectionTest
extends TestWrapper {
    BroadcastSetupHelper helper;
    BroadcastEventLock eventLock;
    ArrayList localConnectionCreators;
    boolean shouldDestroyFactory;
    boolean shouldRemoveConnectionOnError;
    boolean shouldRemoveConnectionOnErrorOriginal;
    boolean sourceHasThrownErrorPropagatingCommandException;
    boolean sourceHasRemovedRemoteConnection;
    Exception firstRunTestException;
    Exception firstRunVerifyException;

    public BroadcastReconnectionTest(BroadcastSetupHelper.TestWrapperWithEventLock test, boolean shouldDestroyFactory, boolean shouldRemoveConnectionOnError, BroadcastSetupHelper helper) {
        super((TestCase)test);
        this.helper = helper;
        this.eventLock = test.getEventLock();
        this.shouldDestroyFactory = shouldDestroyFactory;
        this.shouldRemoveConnectionOnError = shouldRemoveConnectionOnError;
        this.setName("BroadcastReconnectionTest: shouldDestroyFactory = " + shouldDestroyFactory + "; shouldRemoveConnectionOnError = " + shouldRemoveConnectionOnError);
        this.setDescription("Invalidates RemoteConnection then removes it and runs cache sync test again");
    }

    protected TransportManager getTransportManager() {
        return ((AbstractSession)this.getSession()).getCommandManager().getTransportManager();
    }

    protected void setup() throws Throwable {
        this.shouldRemoveConnectionOnErrorOriginal = this.getTransportManager().shouldRemoveConnectionOnError();
        this.getTransportManager().setShouldRemoveConnectionOnError(this.shouldRemoveConnectionOnError);
        if (this.shouldRemoveConnectionOnError && this.helper.isLocalConnectionRemovedOnListeningError()) {
            this.localConnectionCreators = new ArrayList();
            Iterator it = this.helper.getSessionsIterator();
            while (it.hasNext()) {
                AbstractSession session = (AbstractSession)it.next();
                if (session == this.getSession()) continue;
                this.localConnectionCreators.add(new LocalConnectionCreator(session));
            }
        }
        if (this.shouldDestroyFactory) {
            this.helper.destroyFactory();
        } else {
            this.stopFactory();
        }
        if (this.helper.shouldIgnoreTargetListenerInReconnectionTest()) {
            this.eventLock.disableState(3);
        }
        super.setup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void test() throws Throwable {
        try {
            super.test();
        }
        catch (Exception ex) {
            this.firstRunTestException = ex;
        }
        try {
            super.verify();
        }
        catch (Exception ex) {
            this.firstRunVerifyException = ex;
        }
        finally {
            super.reset();
        }
        int state = this.eventLock.getState();
        this.sourceHasThrownErrorPropagatingCommandException = state == 4;
        boolean bl = this.sourceHasRemovedRemoteConnection = state == 5;
        if (this.shouldDestroyFactory) {
            this.resetConnections();
        } else {
            this.helper.startFactory();
        }
        if (this.shouldRemoveConnectionOnError || this.shouldDestroyFactory) {
            this.eventLock.disableState(5);
        }
        super.setup();
        super.test();
    }

    protected void verify() throws Throwable {
        if (this.shouldRemoveConnectionOnError) {
            if (this.sourceHasThrownErrorPropagatingCommandException) {
                throw new TestErrorException("With shouldRemoveConnectionOnError==true there should've been NO ErrorPropagatingCommand RCMException thrown");
            }
            if (!this.sourceHasRemovedRemoteConnection) {
                throw new TestErrorException("With shouldRemoveConnectionOnError==true remote connection should've been removed");
            }
        } else {
            if (!this.sourceHasThrownErrorPropagatingCommandException) {
                throw new TestErrorException("With shouldRemoveConnectionOnError==false there should've been ErrorPropagatingCommand RCMException thrown");
            }
            if (this.sourceHasRemovedRemoteConnection) {
                throw new TestErrorException("With shouldRemoveConnectionOnError==false remote connection should've NOT been removed");
            }
        }
        if (this.firstRunTestException != null) {
            throw new TestErrorException("Unexpectedly firstRunTestException was thrown: ", (Throwable)this.firstRunTestException);
        }
        int state = this.eventLock.getState();
        if (this.helper.shouldIgnoreTargetListenerInReconnectionTest()) {
            if (state != 2) {
                throw new TestErrorException("Unexpected state " + state + " after the second run, BroadcastEventLock.UNLOCKED_BY_TIMER was expected");
            }
        } else {
            if (state != 3) {
                throw new TestErrorException("Unexpected state " + state + " after the second run, BroadcastEventLock.UNLOCKED_BY_TARGET_LISTENER was expected");
            }
            if (this.firstRunVerifyException == null) {
                throw new TestErrorException("Unexpectedly firstRunVerifyException was NOT thrown");
            }
        }
        super.verify();
    }

    public void reset() throws Throwable {
        if (this.localConnectionCreators != null) {
            for (LocalConnectionCreator localConnectionCreator : this.localConnectionCreators) {
                localConnectionCreator.clear();
            }
            this.localConnectionCreators = null;
        }
        if (this.shouldRemoveConnectionOnError) {
            this.helper.removeConnectionsForAllSessionsExcept((AbstractSession)this.getSession(), "external");
        }
        this.getTransportManager().setShouldRemoveConnectionOnError(this.shouldRemoveConnectionOnErrorOriginal);
        this.firstRunTestException = null;
        this.firstRunVerifyException = null;
        this.eventLock.enableAllStates();
        super.reset();
    }

    protected void stopFactory() throws Exception {
        this.helper.stopFactory();
    }

    protected void resetConnections() throws Exception {
        AbstractSession abstractSession = (AbstractSession)this.getSession();
        if (this.shouldRemoveConnectionOnError) {
            if (!this.helper.isLocalConnectionRemovedOnListeningError()) {
                if (this.helper.isLocalConnectionAlsoExternalConnection()) {
                    this.helper.removeConnectionsForAllSessionsExcept(abstractSession, "local");
                } else {
                    this.helper.removeConnectionsForAllSessions("local");
                }
            }
        } else {
            this.helper.removeConnectionsForAllSessions("all");
        }
        this.helper.createFactory();
        this.helper.startFactory();
        if (this.localConnectionCreators != null) {
            boolean allReconnected;
            do {
                allReconnected = true;
                for (LocalConnectionCreator localConnectionCreator : this.localConnectionCreators) {
                    allReconnected = allReconnected && localConnectionCreator.hasReconnected;
                }
                if (allReconnected) continue;
                Thread.sleep(1000L);
            } while (!allReconnected);
        } else {
            this.helper.createConnectionsForAllSessionsExcept(abstractSession, "local");
        }
    }

    class LocalConnectionCreator
    implements ExceptionHandler,
    Runnable {
        AbstractSession session;
        ExceptionHandler originalExceptionHandler;
        boolean isActive;
        boolean hasReconnected;

        LocalConnectionCreator(AbstractSession session) {
            this.originalExceptionHandler = session.getExceptionHandler();
            session.setExceptionHandler((ExceptionHandler)this);
            this.session = session;
        }

        public Object handleException(RuntimeException exception) {
            if (exception instanceof RemoteCommandManagerException && ((RemoteCommandManagerException)((Object)exception)).getErrorCode() == BroadcastReconnectionTest.this.helper.getRcmExceptionErrorCodeOnFailureToCreateLocalConnection()) {
                if (!this.isActive) {
                    this.isActive = true;
                    this.hasReconnected = false;
                    this.session.getServerPlatform().launchContainerRunnable((Runnable)this);
                }
                return null;
            }
            if (this.originalExceptionHandler != null) {
                return this.originalExceptionHandler.handleException(exception);
            }
            throw exception;
        }

        @Override
        public void run() {
            while (this.isActive) {
                this.session.getCommandManager().getTransportManager().createLocalConnection();
                if (this.session.getCommandManager().getTransportManager().getConnectionToLocalHost() == null) continue;
                this.isActive = false;
                this.hasReconnected = true;
            }
        }

        void clear() {
            if (this.isActive) {
                this.isActive = false;
            }
            this.session.setExceptionHandler(this.originalExceptionHandler);
        }
    }
}

