/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.jpa.xml.inherited;

import java.io.Serializable;
import java.io.StringWriter;
import javax.persistence.IdClass;
import org.eclipse.persistence.testing.models.jpa.xml.inherited.BeerConsumer;
import org.eclipse.persistence.testing.models.jpa.xml.inherited.TelephoneNumberPK;

@IdClass(value=TelephoneNumberPK.class)
public class TelephoneNumber
implements Serializable {
    private String type = "Unknown";
    private String number = "#######";
    private String areaCode = "###";
    private BeerConsumer beerConsumer = null;

    public TelephoneNumberPK buildPK() {
        TelephoneNumberPK pk = new TelephoneNumberPK();
        pk.setType(this.getType());
        pk.setNumber(this.getNumber());
        pk.setAreaCode(this.getAreaCode());
        return pk;
    }

    public boolean equals(Object telephoneNumber) {
        if (telephoneNumber.getClass() != TelephoneNumber.class) {
            return false;
        }
        return ((TelephoneNumber)telephoneNumber).buildPK().equals(this.buildPK());
    }

    public String getAreaCode() {
        return this.areaCode;
    }

    public BeerConsumer getBeerConsumer() {
        return this.beerConsumer;
    }

    public String getNumber() {
        return this.number;
    }

    public String getType() {
        return this.type;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public void setBeerConsumer(BeerConsumer beerConsumer) {
        this.beerConsumer = beerConsumer;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        writer.write("TelephoneNumber[");
        writer.write(this.getType());
        writer.write("]: (");
        writer.write(this.getAreaCode());
        writer.write(") ");
        int numberLength = this.getNumber().length();
        writer.write(this.getNumber().substring(0, Math.min(3, numberLength)));
        if (numberLength > 3) {
            writer.write("-");
            writer.write(this.getNumber().substring(3, Math.min(7, numberLength)));
        }
        return writer.toString();
    }
}

