/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility;

import java.io.Serializable;
import org.eclipse.persistence.tools.workbench.utility.Command;

public class SynchronizedObject
implements Cloneable,
Serializable {
    private Object value;
    private final Object mutex;
    private static final long serialVersionUID = 1L;

    public SynchronizedObject(Object value, Object mutex) {
        this.value = value;
        this.mutex = mutex;
    }

    public SynchronizedObject(Object value) {
        this.value = value;
        this.mutex = this;
    }

    public SynchronizedObject() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue() {
        Object object = this.mutex;
        synchronized (object) {
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNull() {
        Object object = this.mutex;
        synchronized (object) {
            return this.value == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNotNull() {
        Object object = this.mutex;
        synchronized (object) {
            return this.value != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(Object value) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.value != value) {
                this.value = value;
                this.mutex.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNull() {
        Object object = this.mutex;
        synchronized (object) {
            this.setValue(null);
        }
    }

    public Object getMutex() {
        return this.mutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilValueIs(Object x) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            while (this.value != x) {
                this.mutex.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilValueIsNot(Object x) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            while (this.value == x) {
                this.mutex.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilNull() throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilValueIs(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilNotNull() throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilValueIsNot(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitToSetValue(Object x) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilValueIsNot(x);
            this.setValue(x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitToSetNull() throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilNotNull();
            this.setValue(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilValueIs(Object x, long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            if (timeout == 0L) {
                this.waitUntilValueIs(x);
                return true;
            }
            long stop = System.currentTimeMillis() + timeout;
            long remaining = timeout;
            while (this.value != x && remaining > 0L) {
                this.mutex.wait(remaining);
                remaining = stop - System.currentTimeMillis();
            }
            return this.value == x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilValueIsNot(Object x, long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            if (timeout == 0L) {
                this.waitUntilValueIsNot(x);
                return true;
            }
            long stop = System.currentTimeMillis() + timeout;
            long remaining = timeout;
            while (this.value == x && remaining > 0L) {
                this.mutex.wait(remaining);
                remaining = stop - System.currentTimeMillis();
            }
            return this.value != x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilNull(long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            return this.waitUntilValueIs(null, timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilNotNull(long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            return this.waitUntilValueIsNot(null, timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitToSetValue(Object x, long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            boolean success = this.waitUntilValueIsNot(x, timeout);
            if (success) {
                this.setValue(x);
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitToSetNull(long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            boolean success = this.waitUntilNotNull(timeout);
            if (success) {
                this.setValue(null);
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Command command) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object object = this.mutex;
        synchronized (object) {
            command.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() {
        try {
            Object object = this.mutex;
            synchronized (object) {
                return super.clone();
            }
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SynchronizedObject)) {
            return false;
        }
        Object thisValue = this.getValue();
        Object otherValue = ((SynchronizedObject)obj).getValue();
        return thisValue == null ? otherValue == null : thisValue.equals(otherValue);
    }

    public int hashCode() {
        Object temp = this.getValue();
        return temp == null ? 0 : temp.hashCode();
    }

    public String toString() {
        return String.valueOf(this.getValue());
    }
}

