/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.persistence.internal.indirection.IndirectionPolicy;
import org.eclipse.persistence.internal.indirection.ProxyIndirectionPolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumnPair;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWReference;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalClassDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWColumnPairHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWProxyIndirectionMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWAbstractTableReferenceMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWVariableOneToOneMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassCodeGenPolicy;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public final class MWOneToOneMapping
extends MWAbstractTableReferenceMapping
implements MWProxyIndirectionMapping {
    private Collection targetForeignKeyHandles;
    public static final String TARGET_FOREIGN_KEYS_COLLECTION = "targetForeignKeys";
    private MWHandle.NodeReferenceScrubber targetForeignKeyScrubber;

    private MWOneToOneMapping() {
    }

    MWOneToOneMapping(MWRelationalClassDescriptor descriptor, MWClassAttribute attribute, String mappingName) {
        super(descriptor, attribute, mappingName);
    }

    @Override
    protected void initialize(Node parent) {
        super.initialize(parent);
        this.targetForeignKeyHandles = new Vector();
    }

    @Override
    protected void initialize(MWClassAttribute attribute, String name) {
        super.initialize(attribute, name);
        if (!this.getInstanceVariable().isValueHolder() && this.getInstanceVariable().getType().isInterface()) {
            this.indirectionType = "proxy-indirection";
        }
        if (this.getProject().usesWeaving()) {
            this.indirectionType = "value-holder-indirection";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        Collection collection = this.targetForeignKeyHandles;
        synchronized (collection) {
            children.addAll(this.targetForeignKeyHandles);
        }
    }

    private MWHandle.NodeReferenceScrubber targetForeignKeyScrubber() {
        if (this.targetForeignKeyScrubber == null) {
            this.targetForeignKeyScrubber = this.buildTargetForeignKeyScrubber();
        }
        return this.targetForeignKeyScrubber;
    }

    private MWHandle.NodeReferenceScrubber buildTargetForeignKeyScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            @Override
            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWOneToOneMapping.this.removeTargetForeignKeyHandle((MWColumnPairHandle)handle);
            }

            public String toString() {
                return "MWOneToOneMapping.buildTargetForeignKeyScrubber()";
            }
        };
    }

    @Override
    protected void automapIndirection() {
        if (this.getInstanceVariable().isValueHolder() || this.getProject().usesWeaving()) {
            this.setUseValueHolderIndirection();
        }
    }

    private Iterator targetForeignKeyHandles() {
        return new CloneIterator(this.targetForeignKeyHandles){

            @Override
            protected void remove(Object current) {
                MWOneToOneMapping.this.removeTargetForeignKeyHandle((MWColumnPairHandle)current);
            }
        };
    }

    void removeTargetForeignKeyHandle(MWColumnPairHandle handle) {
        this.targetForeignKeyHandles.remove(handle);
        this.fireItemRemoved(TARGET_FOREIGN_KEYS_COLLECTION, handle.getColumnPair());
    }

    public Iterator targetForeignKeys() {
        return new TransformationIterator(this.targetForeignKeyHandles()){

            @Override
            protected Object transform(Object next) {
                return ((MWColumnPairHandle)next).getColumnPair();
            }
        };
    }

    public int targetForeignKeysSize() {
        return this.targetForeignKeyHandles.size();
    }

    public void addTargetForeignKey(MWColumnPair targetForeignKey) {
        this.targetForeignKeyHandles.add(new MWColumnPairHandle(this, targetForeignKey, this.targetForeignKeyScrubber()));
        this.fireItemAdded(TARGET_FOREIGN_KEYS_COLLECTION, targetForeignKey);
    }

    public void removeTargetForeignKey(MWColumnPair targetForeignKey) {
        Iterator stream = this.targetForeignKeys();
        while (stream.hasNext()) {
            if (stream.next() != targetForeignKey) continue;
            stream.remove();
            return;
        }
        throw new IllegalArgumentException(targetForeignKey.toString());
    }

    public void clearTargetForeignKeys() {
        Iterator stream = this.targetForeignKeyHandles();
        while (stream.hasNext()) {
            stream.next();
            stream.remove();
        }
    }

    @Override
    public void setReference(MWReference reference) {
        if (this.getReference() != reference) {
            this.clearTargetForeignKeys();
        }
        super.setReference(reference);
    }

    @Override
    public boolean usesProxyIndirection() {
        return this.getIndirectionType() == "proxy-indirection";
    }

    @Override
    public void setUseProxyIndirection() {
        this.setIndirectionType("proxy-indirection");
    }

    public boolean containsTargetForeignKey(MWColumnPair targetForeignKey) {
        return CollectionTools.contains(this.targetForeignKeys(), (Object)targetForeignKey);
    }

    @Override
    protected boolean fieldIsWritten(MWColumnPair columnPair) {
        return !this.containsTargetForeignKey(columnPair);
    }

    @Override
    protected Set buildCandidateReferences() {
        HashSet references = new HashSet();
        references.addAll(this.buildCandidateSourceReferences());
        references.addAll(this.buildCandidateTargetReferences());
        return references;
    }

    @Override
    public boolean sourceReferenceFieldsAreFromSourceDescriptorTables() {
        return true;
    }

    @Override
    public boolean isOneToOneMapping() {
        return true;
    }

    @Override
    public MWOneToOneMapping asMWOneToOneMapping() {
        return this;
    }

    @Override
    protected void initializeOn(MWMapping newMapping) {
        newMapping.initializeFromMWOneToOneMapping(this);
    }

    @Override
    public void initializeFromMWDirectMapping(MWDirectMapping oldMapping) {
        super.initializeFromMWDirectMapping(oldMapping);
    }

    @Override
    public void initializeFromMWVariableOneToOneMapping(MWVariableOneToOneMapping oldMapping) {
        super.initializeFromMWVariableOneToOneMapping(oldMapping);
        if (oldMapping.usesValueHolderIndirection()) {
            this.setUseValueHolderIndirection();
        } else if (oldMapping.usesNoIndirection()) {
            this.setUseNoIndirection();
        }
    }

    @Override
    public String initialValue(MWClassCodeGenPolicy classCodeGenPolicy) {
        String initialValue = super.initialValue(classCodeGenPolicy);
        if (this.isResponsibleForWritingPrimaryKey()) {
            initialValue = StringTools.CR + "\t\t" + classCodeGenPolicy.oneToOneMappingThatControlsWritingOfPrimaryKeyComment(this) + StringTools.CR + "\t\t" + this.getInstanceVariable().initialValueSourceCodeFor(null);
        }
        return initialValue;
    }

    protected boolean isResponsibleForWritingPrimaryKey() {
        if (this.parentDescriptorIsAggregate() || this.isReadOnly()) {
            return false;
        }
        ArrayList writableFields = new ArrayList();
        this.addWrittenFieldsTo(writableFields);
        Iterator stream = ((MWTableDescriptor)this.getParentDescriptor()).primaryKeyPolicy().primaryKeys();
        while (stream.hasNext()) {
            if (!writableFields.contains(stream.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Collection buildAggregateFieldNameGenerators() {
        Collection generators = super.buildAggregateFieldNameGenerators();
        if (this.getReference() != null) {
            Iterator stream = this.getReference().columnPairs();
            while (stream.hasNext()) {
                generators.add(new MWAbstractTableReferenceMapping.ColumnPairAggregateRuntimeFieldNameGenerator(this, (MWColumnPair)stream.next(), true));
            }
        }
        return generators;
    }

    @Override
    public boolean usesAnyOf() {
        return false;
    }

    @Override
    public boolean isTraversableForReadAllQueryOrderable() {
        return true;
    }

    @Override
    public String iconKey() {
        return "mapping.oneToOne";
    }

    @Override
    protected void addProblemsTo(List newProblems) {
        super.addProblemsTo(newProblems);
        this.addUsesIndirectionWhileMaintainsBiDirectionalRelationship(newProblems);
    }

    private void addUsesIndirectionWhileMaintainsBiDirectionalRelationship(List newProblems) {
        if (this.maintainsBidirectionalRelationship() && this.usesNoIndirection()) {
            newProblems.add(this.buildProblem("0468"));
        }
    }

    @Override
    public void addWrittenFieldsTo(Collection writtenFields) {
        if (this.isReadOnly()) {
            return;
        }
        if (this.getReference() != null) {
            Iterator stream = this.getReference().columnPairs();
            while (stream.hasNext()) {
                MWColumnPair pair = (MWColumnPair)stream.next();
                if (this.containsTargetForeignKey(pair) || pair.getSourceColumn() == null) continue;
                writtenFields.add(pair.getSourceColumn());
            }
        }
    }

    @Override
    protected DatabaseMapping buildRuntimeMapping() {
        return new OneToOneMapping();
    }

    @Override
    public DatabaseMapping runtimeMapping() {
        OneToOneMapping runtimeMapping = (OneToOneMapping)super.runtimeMapping();
        if (this.getReference() == null) {
            return runtimeMapping;
        }
        Iterator stream = this.getReference().columnPairs();
        while (stream.hasNext()) {
            MWColumnPair pair = (MWColumnPair)stream.next();
            MWColumn foreignKeyColumn = pair.getSourceColumn();
            MWColumn primaryKeyColumn = pair.getTargetColumn();
            if (foreignKeyColumn == null || primaryKeyColumn == null) continue;
            if (this.containsTargetForeignKey(pair)) {
                if (CollectionTools.contains(this.getParentRelationalDescriptor().candidateTables(), (Object)pair.sourceTable()) && !CollectionTools.contains(this.getParentRelationalDescriptor().candidateTables(), (Object)pair.targetTable())) {
                    foreignKeyColumn = pair.getTargetColumn();
                    primaryKeyColumn = pair.getSourceColumn();
                }
                if (!this.parentDescriptorIsAggregate()) {
                    runtimeMapping.addTargetForeignKeyFieldName(foreignKeyColumn.qualifiedName(), primaryKeyColumn.qualifiedName());
                    continue;
                }
                runtimeMapping.addTargetForeignKeyFieldName(foreignKeyColumn.qualifiedName(), this.getName() + "->" + primaryKeyColumn.qualifiedName() + "_IN_REFERENCE_" + this.getReference().getName());
                continue;
            }
            if (!this.parentDescriptorIsAggregate()) {
                runtimeMapping.addForeignKeyFieldName(foreignKeyColumn.qualifiedName(), primaryKeyColumn.qualifiedName());
                continue;
            }
            runtimeMapping.addForeignKeyFieldName(this.getName() + "->" + foreignKeyColumn.getName() + "_IN_REFERENCE_" + this.getReference().getName(), primaryKeyColumn.qualifiedName());
        }
        if (this.usesProxyIndirection()) {
            runtimeMapping.setIndirectionPolicy((IndirectionPolicy)new ProxyIndirectionPolicy());
        }
        return runtimeMapping;
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWOneToOneMapping.class);
        descriptor.getInheritancePolicy().setParentClass(MWAbstractTableReferenceMapping.class);
        XMLCompositeCollectionMapping targetForeignKeyHandlesMapping = new XMLCompositeCollectionMapping();
        targetForeignKeyHandlesMapping.setAttributeName("targetForeignKeyHandles");
        targetForeignKeyHandlesMapping.setGetMethodName("getTargetForeignKeyHandlesForTopLink");
        targetForeignKeyHandlesMapping.setSetMethodName("setTargetForeignKeyHandlesForTopLink");
        targetForeignKeyHandlesMapping.setReferenceClass(MWColumnPairHandle.class);
        targetForeignKeyHandlesMapping.setXPath("target-foreign-key-handles/column-pair-handle");
        descriptor.addMapping((DatabaseMapping)targetForeignKeyHandlesMapping);
        return descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getTargetForeignKeyHandlesForTopLink() {
        Collection collection = this.targetForeignKeyHandles;
        synchronized (collection) {
            return new TreeSet(this.targetForeignKeyHandles);
        }
    }

    private void setTargetForeignKeyHandlesForTopLink(Collection handles) {
        Iterator stream = handles.iterator();
        while (stream.hasNext()) {
            ((MWColumnPairHandle)stream.next()).setScrubber(this.targetForeignKeyScrubber());
        }
        this.targetForeignKeyHandles = handles;
    }

    public static XMLDescriptor legacy60BuildDescriptor() {
        XMLDescriptor descriptor = MWModel.legacy60BuildStandardDescriptor();
        descriptor.setJavaClass(MWOneToOneMapping.class);
        descriptor.getInheritancePolicy().setParentClass(MWAbstractTableReferenceMapping.class);
        ((XMLDirectMapping)descriptor.addDirectMapping("usesJoining", "legacyGetUsesJoiningForToplink", "legacySetUsesJoiningForToplink", "uses-joining")).setNullValue((Object)Boolean.FALSE);
        XMLCompositeCollectionMapping targetForeignKeyHandlesMapping = new XMLCompositeCollectionMapping();
        targetForeignKeyHandlesMapping.setAttributeName("targetForeignKeyHandles");
        targetForeignKeyHandlesMapping.setGetMethodName("getTargetForeignKeyHandlesForTopLink");
        targetForeignKeyHandlesMapping.setSetMethodName("setTargetForeignKeyHandlesForTopLink");
        targetForeignKeyHandlesMapping.setReferenceClass(MWColumnPairHandle.class);
        targetForeignKeyHandlesMapping.setXPath("target-foreign-key-handles/column-pair-handle");
        descriptor.addMapping((DatabaseMapping)targetForeignKeyHandlesMapping);
        return descriptor;
    }

    private boolean legacyGetUsesJoiningForToplink() {
        throw new UnsupportedOperationException();
    }

    private void legacySetUsesJoiningForToplink(boolean usesJoining) {
        if (usesJoining) {
            this.setJoinFetchingForToplink("INNER");
        } else {
            this.setJoinFetchingForToplink("NONE");
        }
    }
}

