/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.layer.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.IStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.RowVisualChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralDiff;
import org.eclipse.swt.graphics.Rectangle;

public abstract class RowStructuralChangeEvent
extends RowVisualChangeEvent
implements IStructuralChangeEvent {
    public RowStructuralChangeEvent(ILayer layer, Range ... rowPositionRanges) {
        this(layer, Arrays.asList(rowPositionRanges));
    }

    public RowStructuralChangeEvent(ILayer layer, Collection<Range> rowPositionRanges) {
        super(layer, rowPositionRanges);
    }

    public RowStructuralChangeEvent(ILayer layer, Collection<Range> rowPositionRanges, Collection<Integer> rowIndexes) {
        super(layer, rowPositionRanges, rowIndexes);
    }

    protected RowStructuralChangeEvent(RowStructuralChangeEvent event) {
        super(event);
    }

    @Override
    public Collection<Rectangle> getChangedPositionRectangles() {
        ArrayList<Rectangle> changedPositionRectangles = new ArrayList<Rectangle>();
        Collection<Range> ranges = this.getRowPositionRanges();
        if (ranges != null && ranges.size() > 0) {
            int topmostColumnPosition = Integer.MAX_VALUE;
            for (Range range : ranges) {
                if (range.start >= topmostColumnPosition) continue;
                topmostColumnPosition = range.start;
            }
            int columnCount = this.getLayer().getColumnCount();
            int rowCount = this.getLayer().getRowCount();
            changedPositionRectangles.add(new Rectangle(0, topmostColumnPosition, columnCount, rowCount - topmostColumnPosition));
        }
        return changedPositionRectangles;
    }

    @Override
    public boolean isHorizontalStructureChanged() {
        return false;
    }

    @Override
    public boolean isVerticalStructureChanged() {
        return true;
    }

    @Override
    public Collection<StructuralDiff> getColumnDiffs() {
        return null;
    }
}

