/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.hierarchical;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.nebula.widgets.nattable.hierarchical.HierarchicalWrapper;

public class HierarchicalHelper {
    public static final String PROPERTY_SEPARATOR_REGEX = "\\.";

    public static List<HierarchicalWrapper> deNormalize(List<?> input, boolean addParentObject, String ... propertyNames) {
        return HierarchicalHelper.deNormalize(input, addParentObject, Arrays.asList(propertyNames));
    }

    public static List<HierarchicalWrapper> deNormalize(List<?> input, boolean addParentObject, List<String> propertyNames) {
        ArrayList<HierarchicalWrapper> result = new ArrayList<HierarchicalWrapper>();
        if (input != null) {
            LinkedHashSet<String> nested = new LinkedHashSet<String>();
            for (String name : propertyNames) {
                String[] prop = name.split(PROPERTY_SEPARATOR_REGEX);
                if (prop.length <= 1) continue;
                nested.add(prop[prop.length - 2]);
            }
            String[] nestedArray = nested.toArray(new String[0]);
            for (Object root : input) {
                if (root == null) continue;
                HierarchicalWrapper rootWrapper = new HierarchicalWrapper(nestedArray.length + 1);
                rootWrapper.setObject(0, root);
                result.addAll(HierarchicalHelper.deNormalizeWithDirectChildren(rootWrapper, 0, nestedArray, new HashMap(), addParentObject));
            }
        }
        return result;
    }

    private static List<HierarchicalWrapper> deNormalizeWithDirectChildren(HierarchicalWrapper parent, int level, String[] nested, Map<Class<?>, Map<String, PropertyDescriptor>> propertyDescriptorMap, boolean addParentObject) {
        Object child;
        if (level < nested.length && (child = HierarchicalHelper.getDataValue(parent.getObject(level), nested[level], propertyDescriptorMap)) != null && child instanceof Collection) {
            ArrayList<HierarchicalWrapper> result = new ArrayList<HierarchicalWrapper>();
            Collection children = (Collection)child;
            if (addParentObject) {
                result.add(parent);
            }
            for (Object root : children) {
                HierarchicalWrapper rootWrapper = parent.clone();
                rootWrapper.setObject(level + 1, root);
                result.addAll(HierarchicalHelper.deNormalizeWithDirectChildren(rootWrapper, level + 1, nested, propertyDescriptorMap, addParentObject));
            }
            return result;
        }
        return Arrays.asList(parent);
    }

    private static Object getDataValue(Object rowObj, String propertyName, Map<Class<?>, Map<String, PropertyDescriptor>> propertyDescriptorMap) {
        try {
            PropertyDescriptor propertyDesc = HierarchicalHelper.getPropertyDescriptor(rowObj, propertyName, propertyDescriptorMap);
            Method readMethod = propertyDesc.getReadMethod();
            return readMethod.invoke(rowObj, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PropertyDescriptor getPropertyDescriptor(Object rowObj, String propertyName, Map<Class<?>, Map<String, PropertyDescriptor>> propertyDescriptorMap) throws IntrospectionException {
        Object object = rowObj;
        synchronized (object) {
            Map<String, PropertyDescriptor> descriptorMap = propertyDescriptorMap.get(rowObj.getClass());
            if (descriptorMap == null) {
                PropertyDescriptor[] propertyDescriptors = Introspector.getBeanInfo(rowObj.getClass()).getPropertyDescriptors();
                HashMap<String, PropertyDescriptor> propertiesByAttribute = new HashMap<String, PropertyDescriptor>();
                PropertyDescriptor[] propertyDescriptorArray = propertyDescriptors;
                int n = propertyDescriptors.length;
                int n2 = 0;
                while (n2 < n) {
                    PropertyDescriptor propertyDescriptor = propertyDescriptorArray[n2];
                    propertiesByAttribute.put(propertyDescriptor.getName(), propertyDescriptor);
                    ++n2;
                }
                descriptorMap = propertiesByAttribute;
                propertyDescriptorMap.put(rowObj.getClass(), propertiesByAttribute);
            }
            return descriptorMap.get(propertyName);
        }
    }

    public static Object getLevelObjectByProperty(HierarchicalWrapper wrapper, String propertyName) {
        String[] split = propertyName.split(PROPERTY_SEPARATOR_REGEX);
        return wrapper.getObject(split.length - 1);
    }

    public static Map<Integer, List<Integer>> getLevelIndexMapping(String[] propertyNames) {
        LinkedHashMap<Integer, List<Integer>> levelIndexMapping = new LinkedHashMap<Integer, List<Integer>>();
        if (propertyNames.length > 0) {
            int currentLevel = 1;
            ArrayList<Integer> columns = new ArrayList<Integer>();
            columns.add(0);
            levelIndexMapping.put(0, columns);
            int col = 1;
            while (col < propertyNames.length) {
                String[] split = propertyNames[col].split(PROPERTY_SEPARATOR_REGEX);
                if (split.length == currentLevel) {
                    columns.add(col);
                } else if (split.length > currentLevel) {
                    columns = new ArrayList();
                    columns.add(col);
                    levelIndexMapping.put(currentLevel, columns);
                    ++currentLevel;
                }
                ++col;
            }
        }
        return levelIndexMapping;
    }
}

