/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.sdk.util.junit5.extension;

import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestWatcher;

public class TestResultLogger
implements TestWatcher {
    public void testDisabled(ExtensionContext context, Optional<String> reason) {
        TestResultLogger.printWithReason("Test disabled: ", context, reason.orElse(""));
    }

    public void testSuccessful(ExtensionContext context) {
    }

    public void testAborted(ExtensionContext context, Throwable cause) {
        TestResultLogger.printWithReason("Test aborted: ", context, String.valueOf(cause));
    }

    public void testFailed(ExtensionContext context, Throwable cause) {
        TestResultLogger.printWithReason("Test failed: ", context, String.valueOf(cause));
    }

    private static void printWithReason(String prefix, ExtensionContext context, String reason) {
        System.err.println(prefix + TestResultLogger.formatTestName(context) + (String)(reason != null && !reason.isEmpty() ? ", reason: " + reason : ""));
    }

    private static String formatTestName(ExtensionContext context) {
        String className = context.getRequiredTestClass().getSimpleName();
        String methodName = context.getRequiredTestMethod().getName();
        return className + "." + methodName;
    }
}

