/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.sdk.util;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.commons.sdk.util.FixtureConfiguration;
import org.eclipse.mylyn.commons.sdk.util.MylynResourceMissingException;
import org.eclipse.osgi.util.NLS;

public class TestConfiguration {
    static final String URL_SERVICES_LOCALHOST = System.getProperty("localhost.test.server", "https://mylyn.local");
    static final String URL_SERVICES_DEFAULT = System.getProperty("mylyn.test.server", "http://mylyn.frank-becker.de");
    static final String URL_SERVICES_CI_DEFAULT = System.getProperty("mylyn.test.server.ci", "https://mylyn.frank-becker.de");
    public static TestConfiguration defaultConfiguration;
    private boolean localOnly;
    private boolean defaultOnly;
    private boolean headless;

    public static TestConfiguration getDefault() {
        if (defaultConfiguration == null) {
            defaultConfiguration = new TestConfiguration();
            defaultConfiguration.setDefaultOnly(CommonTestUtil.runHeartbeatTestsOnly());
        }
        return defaultConfiguration;
    }

    public static void setDefault(TestConfiguration defaultConfiguration) {
        TestConfiguration.defaultConfiguration = defaultConfiguration;
    }

    public boolean isDefaultOnly() {
        return this.defaultOnly;
    }

    public boolean isHeadless() {
        return this.headless;
    }

    public boolean isLocalOnly() {
        return this.localOnly;
    }

    public void setDefaultOnly(boolean heartbeat) {
        this.defaultOnly = heartbeat;
    }

    public void setHeadless(boolean headless) {
        this.headless = headless;
    }

    public void setLocalOnly(boolean localOnly) {
        this.localOnly = localOnly;
    }

    public <T> List<T> discover(Class<T> clazz, String fixtureType) {
        return this.discover(clazz, fixtureType, this.isDefaultOnly());
    }

    public <T> T discoverDefault(Class<T> clazz, String fixtureType) {
        List<T> fixtures = this.discover(clazz, fixtureType, true);
        if (fixtures.isEmpty()) {
            throw new RuntimeException(NLS.bind((String)"No default fixture available for {0}", (Object)fixtureType));
        }
        return fixtures.get(0);
    }

    public <T> List<T> discover(Class<T> clazz, String fixtureType, boolean defaultOnly) {
        List fixtures = Collections.emptyList();
        Exception[] exception = new Exception[1];
        if (!CommonTestUtil.ignoreLocalTestServices()) {
            try {
                File file = CommonTestUtil.getFile(clazz, "local.json");
                fixtures = TestConfiguration.discover(file.toURI().toASCIIString(), "", clazz, fixtureType, defaultOnly, "local.json", exception);
            }
            catch (IOException | MylynResourceMissingException object) {
                // empty catch block
            }
            if (fixtures.isEmpty()) {
                fixtures = TestConfiguration.discover(URL_SERVICES_LOCALHOST + "/mylyn_idx/service", URL_SERVICES_LOCALHOST, clazz, fixtureType, defaultOnly, "URL_SERVICES_LOCALHOST", exception);
            }
        }
        if (fixtures.isEmpty() && !CommonTestUtil.ignoreGlobalTestServices()) {
            fixtures = TestConfiguration.discover(URL_SERVICES_DEFAULT + "/mylyn_idx/service", URL_SERVICES_DEFAULT, clazz, fixtureType, defaultOnly, "URL_SERVICES_DEFAULT", exception);
        }
        if (fixtures.isEmpty() && CommonTestUtil.runOnCIServerTestsOnly()) {
            throw new RuntimeException(NLS.bind((String)"Failed to discover any fixtures for kind {0} with defaultOnly={1} ({2} and {3})", (Object[])new String[]{fixtureType, Boolean.toString(defaultOnly), URL_SERVICES_LOCALHOST, URL_SERVICES_DEFAULT}), exception[0]);
        }
        return fixtures;
    }

    private static <T> List<T> discover(String location, String baseUrl, Class<T> clazz, String fixtureType, boolean defaultOnly, String kind, Exception[] result) {
        Assert.isNotNull((Object)fixtureType);
        List<FixtureConfiguration> configurations = TestConfiguration.getConfigurations(location, result);
        if (configurations != null) {
            for (FixtureConfiguration configuration : configurations) {
                if (configuration == null) continue;
                if (configuration.getUrl() != null && !configuration.getUrl().startsWith("http")) {
                    configuration.setUrl(baseUrl + configuration.getUrl());
                }
                configuration.getProperties().put("kind", kind);
            }
            return TestConfiguration.loadFixtures(configurations, clazz, fixtureType, defaultOnly);
        }
        return Collections.emptyList();
    }

    private static <T> List<T> loadFixtures(List<FixtureConfiguration> configurations, Class<T> clazz, String fixtureType, boolean defaultOnly) {
        ArrayList<T> result = new ArrayList<T>();
        String defaultOverwriteUrl = System.getProperty("mylyn.tests.configuration.url", "");
        for (FixtureConfiguration configuration : configurations) {
            if (configuration == null || !fixtureType.equals(configuration.getType()) || defaultOnly && (!defaultOverwriteUrl.equals("") || !configuration.isDefault()) && !configuration.url.equals(defaultOverwriteUrl)) continue;
            try {
                Constructor<T> constructor = clazz.getConstructor(FixtureConfiguration.class);
                result.add(constructor.newInstance(configuration));
            }
            catch (Exception e) {
                throw new RuntimeException("Unexpected error creating test fixture", e);
            }
        }
        return result;
    }

    private static List<FixtureConfiguration> getConfigurations(String url, Exception[] result) {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HostnameVerifier allHostsValid = (hostname, session) -> true;
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
            URLConnection connection = new URL(url).openConnection();
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            InputStreamReader in = new InputStreamReader(connection.getInputStream());
            Throwable throwable = null;
            Object var8_12 = null;
            try {
                try {
                    TypeToken<List<FixtureConfiguration>> type = new TypeToken<List<FixtureConfiguration>>(){};
                    return (List)new Gson().fromJson((Reader)in, type.getType());
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            result[0] = new IOException("IOException accessing " + url, e);
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            result[0] = new NoSuchAlgorithmException("NoSuchAlgorithmException accessing " + url, e);
            return null;
        }
        catch (KeyManagementException e) {
            result[0] = new KeyManagementException("KeyManagementException accessing " + url, e);
            return null;
        }
    }
}

